/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.HttpRequestMessageImpl;
import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;

public class AccessLogPort
extends AccessLogData {
    private static final TraceComponent tc = Tr.register(AccessLogPort.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    public static final String TYPE_REMOTE = "remote";

    public AccessLogPort() {
        super("%p");
    }

    @Override
    public Object init(String rawToken) {
        if (rawToken != null && rawToken.length() == 0) {
            return null;
        }
        return rawToken;
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        this.logSafe(accessLogEntry, AccessLogPort.getPort(response, request, data));
        return true;
    }

    public static String getPort(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        if (TYPE_REMOTE.equals(data)) {
            return AccessLogPort.getRemotePort(response, request, data);
        }
        return AccessLogPort.getLocalPort(response, request, data);
    }

    public static String getLocalPort(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        HttpRequestMessageImpl requestMessageImpl = null;
        String localPort = null;
        if (request != null) {
            requestMessageImpl = (HttpRequestMessageImpl)request;
        }
        if (requestMessageImpl != null) {
            localPort = Integer.toString(requestMessageImpl.getServiceContext().getLocalPort());
        }
        return localPort;
    }

    public static String getRemotePort(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        HttpRequestMessageImpl requestMessageImpl = null;
        String remotePort = null;
        if (request != null) {
            requestMessageImpl = (HttpRequestMessageImpl)request;
        }
        if (requestMessageImpl != null) {
            remotePort = Integer.toString(requestMessageImpl.getServiceContext().getRemotePort());
        }
        return remotePort;
    }
}

