/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.bytebuffer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.bytebuffer.internal.WsByteBufferImpl;
import com.ibm.ws.bytebuffer.internal.WsByteBufferPool;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public class PooledWsByteBufferImpl
extends WsByteBufferImpl {
    private static final TraceComponent tc = Tr.register(PooledWsByteBufferImpl.class, (String)"WsByteBuffer", (String)"com.ibm.ws.bytebuffer.internal.resources.ByteBufferMessages");
    private static final long serialVersionUID = -7843989267561719849L;
    protected int getMin = -1;
    protected int getMax = -1;
    protected int putMin = -1;
    protected int putMax = -1;
    protected int readMin = -1;
    protected int readMax = -1;
    protected static final int COPY_ALL_INIT = 0;
    protected static final int COPY_WHEN_NEEDED_STATE1 = 1;
    protected static final int COPY_WHEN_NEEDED_STATE2 = 2;
    protected static final int COPY_ALL_FINAL = 4;
    protected int actionState = 0;
    protected final Object actionAccess = new Object();
    private final int identifier;
    public transient int intReferenceCount = 1;
    protected WsByteBufferPool pool = null;
    Hashtable<String, String> owners = null;
    private Hashtable<WsByteBuffer, WsByteBuffer> allWsByteBuffers = null;

    public PooledWsByteBufferImpl() {
        this(-1);
    }

    public PooledWsByteBufferImpl(int id) {
        this.wsBBRoot = this;
        this.identifier = id;
    }

    public int getID() {
        return this.identifier;
    }

    public Hashtable<WsByteBuffer, WsByteBuffer> getallBuffers() {
        return this.allWsByteBuffers;
    }

    public void addWsByteBuffer(WsByteBuffer buffer) {
        if (this.allWsByteBuffers == null) {
            this.allWsByteBuffers = new Hashtable();
        }
        this.allWsByteBuffers.put(buffer, buffer);
    }

    public void removeWsByteBuffer(WsByteBuffer buffer) {
        this.allWsByteBuffers.remove(buffer);
    }

    public void addOwner(String owner) {
        if (this.owners == null) {
            this.owners = new Hashtable();
        }
        this.owners.put(owner, owner);
    }

    public void removeOwner(String owner) {
        this.owners.remove(owner);
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(String ownerID) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName());
        sb.append('@');
        sb.append(Integer.toHexString(this.hashCode()));
        sb.append('/').append(this.intReferenceCount);
        sb.append(" ID=").append(this.identifier);
        sb.append(' ').append(super.toString());
        sb.append(' ').append(this.pool);
        if (this.owners != null) {
            sb.append("\nOwnership Entry:");
            int i = 0;
            for (String value : this.owners.values()) {
                if (null != ownerID && !ownerID.equals(value)) continue;
                sb.append("\n[").append(i++).append("] ").append(value);
            }
        }
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput s) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Serializing " + this), (Object[])new Object[0]);
        }
        super.writeExternal(s);
    }

    @Override
    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        super.readExternal(s);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("Deserializing " + this), (Object[])new Object[0]);
        }
    }
}

