/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;

final class SibRaMessageToken
implements Serializable {
    private static final long serialVersionUID = 3701528563970253962L;
    private final String _busName;
    private final String _meUuid;
    private final long _sessionId;
    private final String _j2eeName;
    private ArrayList _messageHandles;
    private transient Map _contextInfo;
    private transient boolean _contextInfoContainsDefaultEntries;
    private boolean _deleteMessagesWhenRead;
    private int _unrecoveredReliability;
    private int _maxFailedDeliveries;
    private int _sequentialMessageThreshold;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaMessageToken.class);

    SibRaMessageToken(String busName, String meUuid, long sessionId, String j2eeName, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialMessageThreshold) {
        String methodName = "SibRaMessageToken";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaMessageToken", (Object)new Object[]{busName, meUuid, sessionId, j2eeName, maxFailedDeliveries, sequentialMessageThreshold});
        }
        this._busName = busName;
        this._meUuid = meUuid;
        this._sessionId = sessionId;
        this._j2eeName = j2eeName;
        this._unrecoveredReliability = unrecoveredReliability.toInt();
        this._messageHandles = new ArrayList();
        this._maxFailedDeliveries = maxFailedDeliveries;
        this._sequentialMessageThreshold = sequentialMessageThreshold;
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaMessageToken");
        }
    }

    String getBusName() {
        return this._busName;
    }

    String getJ2EEName() {
        return this._j2eeName;
    }

    SIMessageHandle getMessageHandle(int index) {
        return (SIMessageHandle)this._messageHandles.get(index);
    }

    int getNumberOfMessageHandles() {
        return this._messageHandles.size();
    }

    String getMeUuid() {
        return this._meUuid;
    }

    long getSessionId() {
        return this._sessionId;
    }

    int getUnrecoveredReliability() {
        return this._unrecoveredReliability;
    }

    public boolean isDeleteMessagesWhenRead() {
        return this._deleteMessagesWhenRead;
    }

    Map getContext() {
        return this._contextInfo;
    }

    void clear() {
        this._deleteMessagesWhenRead = false;
        this._messageHandles.clear();
        this._contextInfo = null;
        this._contextInfoContainsDefaultEntries = false;
    }

    boolean addHandle(SIMessageHandle handle, Map ctxInfo, boolean canBeDeleted) {
        String methodName = "addHandle";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addHandle", (Object)new Object[]{handle, ctxInfo, canBeDeleted});
        }
        boolean addedToThisToken = false;
        if (this._messageHandles.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)("No existing message handles - using current message as template <ctxInfo=" + ctxInfo + "> <canBeDeleted=" + canBeDeleted + "> <handle= " + handle + ">"));
            }
            this._messageHandles.add(handle);
            this._contextInfo = ctxInfo;
            this._deleteMessagesWhenRead = canBeDeleted;
            this._contextInfoContainsDefaultEntries = this._contextInfo.size() == 2;
            addedToThisToken = true;
        } else if (this.matches(ctxInfo, canBeDeleted)) {
            if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
                SibTr.debug((TraceComponent)TRACE, (String)("Message matched token for supplied handle - adding handle to the token <handle=" + handle + ">"));
            }
            this._messageHandles.add(handle);
            addedToThisToken = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addHandle", (Object)addedToThisToken);
        }
        return addedToThisToken;
    }

    boolean matches(Map ctxInfo, boolean canBeDeleted) {
        String methodName = "matches";
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)new Object[]{ctxInfo, canBeDeleted});
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)("Attempting to match againgst token <context=" + this._contextInfo + "> <isBENP=" + this._deleteMessagesWhenRead));
        }
        boolean doesMatch = false;
        if (canBeDeleted != this._deleteMessagesWhenRead || !this._contextInfoContainsDefaultEntries || ctxInfo.size() == this._contextInfo.size()) {
            // empty if block
        }
        if (TraceComponent.isAnyTracingEnabled() && TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)doesMatch);
        }
        return doesMatch;
    }

    SIMessageHandle[] getMessageHandleArray() {
        return this._messageHandles.toArray(new SIMessageHandle[0]);
    }

    int getMaxFailedDeliveries() {
        return this._maxFailedDeliveries;
    }

    int getSequentialMessageThreshold() {
        return this._sequentialMessageThreshold;
    }

    public final String toString() {
        SibRaStringGenerator generator = new SibRaStringGenerator(this);
        generator.addField("busName", this._busName);
        generator.addField("j2eeName", this._j2eeName);
        generator.addField("messageHandles", this._messageHandles.toArray(new SIMessageHandle[0]));
        generator.addField("meUuid", this._meUuid);
        generator.addField("sessionId", this._sessionId);
        generator.addField("deleteMessagesWhenRead", this._deleteMessagesWhenRead);
        generator.addField("contextInfo", this._contextInfo);
        generator.addField("unrecoveredReliability", this._unrecoveredReliability);
        generator.addField("maxFailedDeliveries", this._maxFailedDeliveries);
        generator.addField("sequentialMessageThreshold", this._sequentialMessageThreshold);
        return generator.getStringRepresentation();
    }
}

