/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.inbound.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.inbound.impl.SibRaEndpointActivation;
import com.ibm.ws.sib.ra.inbound.impl.SibRaMessagingEngineConnection;
import com.ibm.ws.sib.ra.inbound.impl.SibRaNonTransactionalDispatcher;
import com.ibm.ws.sib.ra.inbound.impl.SibRaStringGenerator;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.util.ArrayList;
import java.util.List;

final class SibRaBatchMessageDeletionDispatcher
extends SibRaNonTransactionalDispatcher {
    private final List _successfulMessages = new ArrayList();
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaBatchMessageDeletionDispatcher.class);
    private static final String CLASS_NAME = SibRaNonTransactionalDispatcher.class.getName();
    private static final String FFDC_PROBE_1 = "1";

    SibRaBatchMessageDeletionDispatcher(SibRaMessagingEngineConnection connection, AbstractConsumerSession session, SibRaEndpointActivation endpointActivation, Reliability unrecoveredReliability, int maxFailedDeliveries, int sequentialFailureThreshold) throws ResourceException {
        super(connection, session, endpointActivation, unrecoveredReliability, maxFailedDeliveries, sequentialFailureThreshold);
        if (TRACE.isEntryEnabled()) {
            String methodName = "SibRaBatchMessageDeletionDispatcher";
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaBatchMessageDeletionDispatcher", (Object)new Object[]{connection, session, endpointActivation});
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaBatchMessageDeletionDispatcher");
        }
    }

    @Override
    protected void afterDelivery(SIBusMessage message, MessageEndpoint endpoint, boolean success) throws ResourceException {
        String methodName = "afterDelivery";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"afterDelivery", (Object)new Object[]{message, success});
        }
        super.afterDelivery(message, endpoint, success);
        if (success && this.processMessage(message)) {
            this._successfulMessages.add(message);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"afterDelivery");
        }
    }

    @Override
    protected void cleanup() {
        String methodName = "cleanup";
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        super.cleanup();
        if (this._successfulMessages.size() > 0) {
            try {
                this.deleteMessages(SibRaBatchMessageDeletionDispatcher.getMessageHandles(this._successfulMessages), null);
            }
            catch (ResourceException exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "cleanup"), (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)exception));
                }
            }
            finally {
                this._successfulMessages.clear();
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    @Override
    protected SibRaStringGenerator getStringGenerator() {
        SibRaStringGenerator generator = super.getStringGenerator();
        generator.addField("successfulMessages", this._successfulMessages);
        return generator;
    }
}

