/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.api.jms.impl.JmsDestinationImpl;
import com.ibm.ws.sib.api.jms.impl.JmsErrorUtils;
import com.ibm.ws.sib.api.jms.impl.JmsMsgProducerImpl;
import com.ibm.ws.sib.mfp.PersistenceType;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.JMSException;
import java.util.List;
import java.util.Map;

public class ProducerProperties {
    private static TraceComponent tc = SibTr.register(ProducerProperties.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private String inDmOverride = "Application";
    private Integer inPriOverride = null;
    private Long inTTL_Override = null;
    private Reliability nonPerReliability = Reliability.EXPRESS_NONPERSISTENT;
    private Reliability perReliability = Reliability.RELIABLE_PERSISTENT;
    private Reliability outboundReliability;
    private int inDeliveryMode = 2;
    private int inPriority = 4;
    private long inTTL = 0L;
    private List outboundForwardRoutingPath = null;
    private List outboundReverseRoutingPath_Part = null;
    private PersistenceType outboundDeliveryMode = PersistenceType.PERSISTENT;
    private Integer outboundPriority = this.inPriority;
    private long outboundTTL = this.inTTL;
    private String outboundDiscrim = null;

    public ProducerProperties(JmsDestinationImpl dest, JmsMsgProducerImpl producer, Map passThruProps, Reliability perRel, Reliability nonperRel) throws JMSException {
        String connPropVal;
        if (nonperRel == null) {
            if (passThruProps != null && (connPropVal = (String)passThruProps.get("nonPersistentMapping")) != null) {
                this.nonPerReliability = ProducerProperties.lookupReliability(connPropVal);
            }
        } else {
            this.nonPerReliability = nonperRel;
        }
        if (perRel == null) {
            if (passThruProps != null && (connPropVal = (String)passThruProps.get("persistentMapping")) != null) {
                this.perReliability = ProducerProperties.lookupReliability(connPropVal);
            }
        } else {
            this.perReliability = perRel;
        }
        this.setInDeliveryModeOverride(dest.getDeliveryMode());
        this.setInPriorityOverride(dest.getPriority());
        this.setInTTL_Override(dest.getTimeToLive());
        this.outboundForwardRoutingPath = dest.getConvertedFRP();
        this.outboundReverseRoutingPath_Part = dest.getConvertedRRP();
        this.outboundDiscrim = dest.getDestDiscrim();
        if (producer != null) {
            this.setInDeliveryMode(producer.getDeliveryMode());
            this.setInPriority(producer.getPriority());
            this.setInTTL(producer.getTimeToLive());
        }
        this.recalcOutReliability();
    }

    public void setInDeliveryModeOverride(String val) {
        if (!this.inDmOverride.equals(val)) {
            this.inDmOverride = val;
            this.recalcOutDeliveryMode();
        }
    }

    public void setInDeliveryMode(int dm) {
        if (this.inDeliveryMode != dm) {
            this.inDeliveryMode = dm;
            this.recalcOutDeliveryMode();
            this.recalcOutReliability();
        }
    }

    public void setInPriorityOverride(Integer pri) {
        if (this.inPriOverride == null && pri != null || this.inPriOverride != null && !this.inPriOverride.equals(pri)) {
            this.inPriOverride = pri;
            this.recalcOutPriority();
        }
    }

    public void setInPriority(int pri) {
        if (this.inPriority != pri) {
            this.inPriority = pri;
            this.recalcOutPriority();
        }
    }

    public void setInTTL_Override(Long ttl) {
        if (this.inTTL_Override == null && ttl != null || this.inTTL_Override != null && !this.inTTL_Override.equals(ttl)) {
            this.inTTL_Override = ttl;
            this.recalcOutTTL();
        }
    }

    public void setInTTL(long ttl) throws JMSException {
        if (this.inTTL != ttl) {
            if (ttl < 0L || ttl > 9191815209357175807L) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0301", new Object[]{"timeToLive", "" + ttl}, tc);
            }
            this.inTTL = ttl;
            this.recalcOutTTL();
        }
    }

    public PersistenceType getEffectiveDeliveryMode() {
        return this.outboundDeliveryMode;
    }

    public Integer getEffectivePriority() {
        return this.outboundPriority;
    }

    public long getEffectiveTTL() {
        return this.outboundTTL;
    }

    public List getConvertedFRP() {
        return this.outboundForwardRoutingPath;
    }

    public List getConvertedRRP_Part() {
        return this.outboundReverseRoutingPath_Part;
    }

    public String getDiscriminator() {
        return this.outboundDiscrim;
    }

    public Reliability getEffectiveReliability() {
        return this.outboundReliability;
    }

    private void recalcOutDeliveryMode() {
        this.outboundDeliveryMode = this.inDmOverride.equals("Persistent") ? PersistenceType.PERSISTENT : (this.inDmOverride.equals("NonPersistent") ? PersistenceType.NON_PERSISTENT : (this.inDeliveryMode == 2 ? PersistenceType.PERSISTENT : PersistenceType.NON_PERSISTENT));
    }

    private void recalcOutPriority() {
        this.outboundPriority = this.inPriOverride == null ? Integer.valueOf(this.inPriority) : this.inPriOverride;
    }

    private void recalcOutTTL() {
        this.outboundTTL = this.inTTL_Override == null ? this.inTTL : this.inTTL_Override;
    }

    private void recalcOutReliability() {
        this.outboundReliability = this.outboundDeliveryMode == PersistenceType.NON_PERSISTENT ? this.nonPerReliability : this.perReliability;
    }

    static Reliability lookupReliability(String name) throws JMSException {
        Reliability result;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lookupReliability", (Object)name);
        }
        if ("AsSIBDestination".equals(name)) {
            result = Reliability.NONE;
        } else {
            try {
                result = Reliability.getReliabilityByName((String)name);
            }
            catch (Exception e) {
                throw (JMSException)JmsErrorUtils.newThrowable(JMSException.class, "INVALID_VALUE_CWSIA0301", new Object[]{"quality of service", name}, tc);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lookupReliability", (Object)result);
        }
        return result;
    }
}

