/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.util.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.annocache.util.internal.UtilImpl_NonInternSet;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.util.Util_InternMap;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class UtilImpl_Utils {
    private static final String CLASS_NAME = "UtilImpl_Utils";
    public static final String SELECT_ALL_PATTERN = "*";
    public static final String SELECT_NONE_PATTERN = "";
    private static final DateTimeFormatter DATE_FORMATTER;
    static final long serialVersionUID = -1512443745343615875L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static long getSystemTime() {
        return System.nanoTime();
    }

    public static String getSystemProperty(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){
            static final long serialVersionUID = 4415639376608395915L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_Utils$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
    }

    public static String getSystemProperty(Logger logger, String propertyName, String defaultValue) {
        String result;
        String reason;
        String methodName = "getSystemProperty";
        String propertyValue = UtilImpl_Utils.getSystemProperty(propertyName);
        if (propertyValue == null) {
            reason = "Defaulted";
            result = defaultValue;
        } else {
            reason = "Read From Property";
            result = propertyValue;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Property [ {0} ] Read [ {1} ] Returned [ {2} ] ({3})", new Object[]{propertyName, propertyValue, result, reason});
        }
        return result;
    }

    public static boolean getSystemProperty(Logger logger, String propertyName, boolean defaultValue) {
        boolean result;
        String reason;
        String methodName = "getSystemProperty";
        String propertyValue = UtilImpl_Utils.getSystemProperty(propertyName);
        if (propertyValue == null) {
            reason = "Defaulted";
            result = defaultValue;
        } else {
            reason = "Read From Property";
            result = Boolean.parseBoolean(propertyValue);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Property [ {0} ] Read [ {1} ] Returned [ {2} ] ({3})", new Object[]{propertyName, propertyValue, result, reason});
        }
        return result;
    }

    public static int getSystemProperty(Logger logger, String propertyName, int defaultValue) {
        int result;
        String reason;
        String methodName = "getSystemProperty";
        String propertyValue = UtilImpl_Utils.getSystemProperty(propertyName);
        if (propertyValue == null) {
            reason = "Defaulted";
            result = defaultValue;
        } else {
            reason = "Read From Property";
            result = Integer.parseInt(propertyValue);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Property [ {0} ] Read [ {1} ] Returned [ {2} ] ({3})", new Object[]{propertyName, propertyValue, result, reason});
        }
        return result;
    }

    public static Thread createThread(final Runnable runnable, final String threadName) {
        return AccessController.doPrivileged(new PrivilegedAction<Thread>(){
            static final long serialVersionUID = -6046865190375517849L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Thread run() {
                return new Thread(runnable, threadName);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_Utils$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
            }
        });
    }

    public static Set<String> restrict(Set<String> candidates, Set<String> allowed) {
        if (candidates == null || allowed == null || candidates.isEmpty() || allowed.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> restricted = new HashSet<String>();
        for (String candidate : candidates) {
            if (!allowed.contains(candidate)) continue;
            restricted.add(candidate);
        }
        return restricted;
    }

    public static boolean selectsAll(String regEx) {
        return regEx != null && regEx.equals(SELECT_ALL_PATTERN);
    }

    public static boolean selectsNone(String regEx) {
        return regEx != null && regEx.equals(SELECT_NONE_PATTERN);
    }

    public static Pattern compile(String regEx) {
        return Pattern.compile(regEx);
    }

    public static Set<String> unintern(Util_InternMap internMap, Set<String> internSet) {
        if (internSet == null || internSet.isEmpty()) {
            return Collections.emptySet();
        }
        return new UtilImpl_NonInternSet(internMap, internSet);
    }

    public static Set<String> createNonInternSet(Util_InternMap internMap, Set<String> internSet) {
        return new UtilImpl_NonInternSet(internMap, internSet);
    }

    public static Map<String, String> duplicateIdentityMap(Map<String, String> map) {
        IdentityHashMap<String, String> duplicateMap = new IdentityHashMap<String, String>();
        duplicateMap.putAll(map);
        return duplicateMap;
    }

    public static String getDateAndTime() {
        return DATE_FORMATTER.format(ZonedDateTime.now());
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.util.internal.UtilImpl_Utils", UtilImpl_Utils.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        DATE_FORMATTER = DateTimeFormatter.ofPattern("EEE, dd-MMM-uuuu HH:mm:ss Z");
    }
}

