/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.cache.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_Factory;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableTimeStampImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_ReadBuffer;
import com.ibm.ws.annocache.util.internal.UtilImpl_ReadBufferFull;
import com.ibm.ws.annocache.util.internal.UtilImpl_ReadBufferPartial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.annocache.targets.cache.TargetCache_BinaryConstants;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetCacheImpl_ReaderBinary
implements TargetCache_BinaryConstants {
    private static final String CLASS_NAME = TargetCacheImpl_ReaderBinary.class.getSimpleName();
    protected static final Logger logger = AnnotationCacheServiceImpl_Logging.ANNO_LOGGER;
    public static final boolean DO_READ_STRINGS = true;
    public static final boolean DO_READ_FULL = true;
    protected final TargetCacheImpl_Factory factory;
    protected final UtilImpl_ReadBuffer bufInput;
    private final byte[] magicBytes;
    private final String[] strings;
    static final long serialVersionUID = 5769590628293536171L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_ReaderBinary(TargetCacheImpl_Factory factory, String path, Charset charset, boolean readStrings, boolean readFull) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "<init>", new Object[]{factory, path, charset, readStrings, readFull});
        }
        this.magicBytes = new byte[4];
        this.factory = factory;
        if (readFull) {
            this.bufInput = new UtilImpl_ReadBufferFull(path, charset);
            this.strings = readStrings ? this.readStrings() : null;
        } else {
            this.bufInput = new UtilImpl_ReadBufferPartial(path, 820, charset);
            this.strings = null;
        }
        this.requireBegin();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetCacheImpl_Factory getFactory() {
        return this.factory;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public UtilImpl_ReadBuffer getInput() {
        return this.bufInput;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getPath() {
        return this.bufInput.getPath();
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getEncoding() {
        return this.bufInput.getEncoding();
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void close() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "close", new Object[0]);
        }
        String methodName = "close";
        try {
            this.bufInput.close();
        }
        catch (IOException iOException) {
            void e;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", (String)"110", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_CACHE_EXCEPTION", e.getMessage());
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "close");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void requireMagic(byte[] requiredBytes) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireMagic", new Object[]{requiredBytes});
        }
        this.bufInput.read(this.magicBytes, 0, 4);
        if (!Arrays.equals(requiredBytes, this.magicBytes)) {
            throw new IOException("Failed read of [ " + this.getPath() + " ]: Expected magic bytes [ " + requiredBytes + " ] actual magic bytes [ " + this.magicBytes + " ]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireMagic");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void requireBegin() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireBegin", new Object[0]);
        }
        this.requireMagic(MAGIC_BEGIN_BYTES);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireBegin");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void requireEnd() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireEnd", new Object[0]);
        }
        this.requireMagic(MAGIC_END_BYTES);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireEnd");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String[] readStrings() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readStrings", new Object[0]);
        }
        this.bufInput.seekEnd(-9);
        this.bufInput.requireByte((byte)4);
        int stringsOffset = this.bufInput.readLargeInt();
        this.requireEnd();
        this.bufInput.seek(stringsOffset);
        this.bufInput.requireByte((byte)3);
        int numStrings = this.bufInput.readLargeInt();
        String[] useStrings = new String[numStrings];
        for (int strNo = 0; strNo < numStrings; ++strNo) {
            String nextString;
            useStrings[strNo] = nextString = this.bufInput.readString();
        }
        this.bufInput.seek(0);
        String[] stringArray = useStrings;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readStrings", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String requireCompact(byte fieldByte) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireCompact", new Object[]{fieldByte});
        }
        this.bufInput.requireByte(fieldByte);
        String string = this.requireCompact();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireCompact", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String requireCompact() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireCompact", new Object[0]);
        }
        int offset = this.bufInput.readLargeInt();
        if (offset < 0 || offset >= this.strings.length) {
            throw new IOException("Compact string offset [ " + offset + " ] must be at least 0 and less than [ " + this.strings.length + " ]");
        }
        String string = this.strings[offset];
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireCompact", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void requireHeader(String tableName, String tableVersion) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireHeader", new Object[]{tableName, tableVersion});
        }
        this.bufInput.requireByte((byte)1);
        String actualEncoding = this.bufInput.requireField((byte)17, 60);
        String actualTableName = this.bufInput.requireField((byte)18, 60);
        String actualVersion = this.bufInput.requireField((byte)19, 60);
        String writeStamp = this.bufInput.requireField((byte)20, 60);
        if (!this.getEncoding().equals(actualEncoding)) {
            throw new IOException("Incompatible encoding [ " + actualEncoding + " ]: Encoding should be [ " + this.getEncoding() + " ] for [ " + this.getPath() + "]");
        }
        if (!tableName.equals(actualTableName)) {
            throw new IOException("Incorrect table name [ " + actualTableName + " ]: Expecting table name [ " + tableName + " ] for [ " + this.getPath() + "]");
        }
        if (!tableVersion.equals(actualVersion)) {
            throw new IOException("Unexpected table version [ " + actualVersion + " ]: Expecting table version [ " + tableVersion + " ] for [ " + this.getPath() + "]");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireStampHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireStampHeader", new Object[0]);
        }
        this.requireHeader("Stamp", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireStampHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireContainerClassesHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireContainerClassesHeader", new Object[0]);
        }
        this.requireHeader("Classes", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireContainerClassesHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireTargetsHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireTargetsHeader", new Object[0]);
        }
        this.requireHeader("Annotation Targets", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireTargetsHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireContainersHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireContainersHeader", new Object[0]);
        }
        this.requireHeader("Container", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireContainersHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireModuleClassesHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireModuleClassesHeader", new Object[0]);
        }
        this.requireHeader("Classes", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireModuleClassesHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireResolvedRefsHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireResolvedRefsHeader", new Object[0]);
        }
        this.requireHeader("Resolved References", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireResolvedRefsHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void requireUnresolvedRefsHeader() throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireUnresolvedRefsHeader", new Object[0]);
        }
        this.requireHeader("Unresolved References", "1.0");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "requireUnresolvedRefsHeader");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{stampTable});
        }
        this.readFragment(stampTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{classTable});
        }
        this.readFragment(classTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableClassesImpl classTable, TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{classTable, targetTable});
        }
        this.readFragment(classTable);
        this.readFragment(targetTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String readEntire(TargetsTableClassesImpl classTable, TargetsTableAnnotationsImpl targetTable, String currentStamp) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{classTable, targetTable, currentStamp});
        }
        this.readFragment(classTable);
        this.readFragment(targetTable);
        String string = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{targetTable});
        }
        this.readFragment(targetTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readFragment(TargetsTableTimeStampImpl stampTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment", new Object[]{stampTable});
        }
        this.requireHeader("Stamp", "1.0");
        String componentName = this.bufInput.requireField((byte)21);
        String timeStamp = this.bufInput.requireField((byte)22, 60);
        stampTable.setName(componentName);
        stampTable.setStamp(timeStamp);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readFragment(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment", new Object[]{classTable});
        }
        this.requireContainerClassesHeader();
        this.bufInput.requireByte((byte)2);
        this.readPackages(classTable);
        this.readClasses(classTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFragment(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment", new Object[]{targetTable});
        }
        this.requireTargetsHeader();
        this.bufInput.requireByte((byte)2);
        this.readPackageTargets(targetTable);
        this.readClassTargets(targetTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readPackages(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackages", new Object[]{classTable});
        }
        int numPackages = this.bufInput.readLargeInt();
        for (int packageNo = 0; packageNo < numPackages; ++packageNo) {
            String packageName = this.requireCompact((byte)49);
            String i_packageName = classTable.internClassName(packageName);
            classTable.record(i_packageName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readClasses(TargetsTableClassesImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClasses", new Object[]{classTable});
        }
        int numClasses = this.bufInput.readLargeInt();
        ArrayList<String> i_interfaceNames = new ArrayList<String>();
        for (int classNo = 0; classNo < numClasses; ++classNo) {
            String className = this.requireCompact((byte)50);
            String i_className = classTable.internClassName(className);
            String superClassName = this.requireCompact((byte)65);
            String i_superClassName = superClassName.isEmpty() ? null : classTable.internClassName(superClassName);
            int numInterfaces = this.bufInput.readSmallInt();
            if (numInterfaces > 0) {
                for (int interfaceNo = 0; interfaceNo < numInterfaces; ++interfaceNo) {
                    String interfaceName = this.requireCompact((byte)66);
                    i_interfaceNames.add(classTable.internClassName(interfaceName));
                }
            }
            this.bufInput.requireByte((byte)66);
            int modifiers = this.bufInput.readLargeInt();
            classTable.record(i_className, i_superClassName, i_interfaceNames, modifiers);
            i_interfaceNames.clear();
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readPackageTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackageTargets", new Object[]{targetTable});
        }
        int numPackages = this.bufInput.readLargeInt();
        for (int packageNo = 0; packageNo < numPackages; ++packageNo) {
            String packageName = this.requireCompact((byte)49);
            String i_packageName = targetTable.internClassName(packageName);
            int numAnno = this.bufInput.readSmallInt();
            for (int annoNo = 0; annoNo < numAnno; ++annoNo) {
                String annoClassName = this.requireCompact((byte)81);
                String i_annoClassName = targetTable.internClassName(annoClassName);
                targetTable.recordPackageAnnotation(i_packageName, i_annoClassName);
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackageTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readClassTargets(TargetsTableAnnotationsImpl targetTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClassTargets", new Object[]{targetTable});
        }
        int numClasses = this.bufInput.readLargeInt();
        for (int classNo = 0; classNo < numClasses; ++classNo) {
            String className = this.requireCompact((byte)50);
            String i_className = targetTable.internClassName(className);
            int numAnnotations = this.bufInput.readSmallInt();
            for (int annoNo = 0; annoNo < numAnnotations; ++annoNo) {
                byte annoTypeByte = (byte)this.bufInput.read();
                String annoClassName = this.requireCompact();
                String i_annoClassName = targetTable.internClassName(annoClassName);
                if (annoTypeByte == 82) {
                    targetTable.recordClassAnnotation(i_className, i_annoClassName);
                    continue;
                }
                if (annoTypeByte == 83) {
                    targetTable.recordFieldAnnotation(i_className, i_annoClassName);
                    continue;
                }
                if (annoTypeByte == 84) {
                    targetTable.recordMethodAnnotation(i_className, i_annoClassName);
                    continue;
                }
                throw new IOException("Unexpected annotation type [ " + annoTypeByte + " ] for class [ " + className + " ] in [ " + this.getPath() + " ]");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClassTargets");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableContainersImpl containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{containerTable});
        }
        this.readFragment(containerTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFragment(TargetsTableContainersImpl containerTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment", new Object[]{containerTable});
        }
        this.requireContainersHeader();
        this.bufInput.requireByte((byte)2);
        int numContainers = this.bufInput.readLargeInt();
        for (int containerNo = 0; containerNo < numContainers; ++containerNo) {
            ClassSource_Aggregate.ScanPolicy containerPolicy;
            String containerName = this.requireCompact((byte)21);
            if (containerName.equals("/")) {
                containerName = "root";
            }
            String containerPolicyText = this.requireCompact((byte)33);
            try {
                containerPolicy = ClassSource_Aggregate.ScanPolicy.valueOf(containerPolicyText);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", (String)"486", (Object)this, (Object[])new Object[]{containerTable});
                throw new IOException("Unknown policy [ " + containerPolicyText + " ] of container [ " + containerName + " ] of [ " + this.getPath() + " ]");
            }
            containerTable.addName(containerName, containerPolicy);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragment");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntireResolvedRefs(Collection<String> i_resolvedClassNames, UtilImpl_InternMap internMap) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntireResolvedRefs", new Object[]{i_resolvedClassNames, internMap});
        }
        this.readFragmentResolvedRefs(i_resolvedClassNames, internMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntireResolvedRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFragmentResolvedRefs(Collection<String> i_resolvedClassNames, UtilImpl_InternMap internMap) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragmentResolvedRefs", new Object[]{i_resolvedClassNames, internMap});
        }
        this.requireResolvedRefsHeader();
        this.bufInput.requireByte((byte)2);
        int numRefs = this.bufInput.readLargeInt();
        for (int refNo = 0; refNo < numRefs; ++refNo) {
            String className = this.bufInput.requireField((byte)50);
            String i_className = internMap.intern(className);
            i_resolvedClassNames.add(i_className);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragmentResolvedRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntireUnresolvedRefs(Collection<String> i_unresolvedClassNames, UtilImpl_InternMap internMap) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntireUnresolvedRefs", new Object[]{i_unresolvedClassNames, internMap});
        }
        this.readFragmentUnresolvedRefs(i_unresolvedClassNames, internMap);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntireUnresolvedRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readFragmentUnresolvedRefs(Collection<String> i_unresolvedClassNames, UtilImpl_InternMap internMap) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragmentUnresolvedRefs", new Object[]{i_unresolvedClassNames, internMap});
        }
        this.requireUnresolvedRefsHeader();
        this.bufInput.requireByte((byte)2);
        int numRefs = this.bufInput.readLargeInt();
        for (int refNo = 0; refNo < numRefs; ++refNo) {
            String className = this.bufInput.requireField((byte)50);
            String i_className = internMap.intern(className);
            i_unresolvedClassNames.add(i_className);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readFragmentUnresolvedRefs");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void readEntire(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire", new Object[]{classTable});
        }
        this.requireModuleClassesHeader();
        this.bufInput.requireByte((byte)2);
        this.readPackages(classTable);
        this.readClasses(classTable);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readEntire");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readPackages(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackages", new Object[]{classTable});
        }
        int numPackages = this.bufInput.readLargeInt();
        for (int packageNo = 0; packageNo < numPackages; ++packageNo) {
            String packageName = this.requireCompact((byte)49);
            String i_packageName = classTable.internClassName(packageName);
            String sourceName = this.requireCompact((byte)51);
            classTable.record(sourceName, i_packageName);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readPackages");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readClasses(TargetsTableClassesMultiImpl classTable) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClasses", new Object[]{classTable});
        }
        int numClasses = this.bufInput.readLargeInt();
        ArrayList<String> i_interfaceNames = new ArrayList<String>();
        for (int classNo = 0; classNo < numClasses; ++classNo) {
            this.readClass(classTable, i_interfaceNames);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClasses");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void readClass(TargetsTableClassesMultiImpl classTable, List<String> i_interfaceNames) throws IOException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClass", new Object[]{classTable, i_interfaceNames});
        }
        String className = this.requireCompact((byte)50);
        String i_className = classTable.internClassName(className);
        String sourceName = this.requireCompact((byte)51);
        String superClassName = this.requireCompact((byte)65);
        String i_superClassName = superClassName.isEmpty() ? null : classTable.internClassName(superClassName);
        int numInterfaces = this.bufInput.readSmallInt();
        for (int interfaceNo = 0; interfaceNo < numInterfaces; ++interfaceNo) {
            String interfaceName = this.requireCompact((byte)66);
            String i_interfaceName = classTable.internClassName(interfaceName);
            i_interfaceNames.add(i_interfaceName);
        }
        this.bufInput.requireByte((byte)66);
        int modifiers = this.bufInput.readLargeInt();
        classTable.record(sourceName, i_className, i_superClassName, i_interfaceNames, modifiers);
        i_interfaceNames.clear();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_ReaderBinary", "readClass");
        }
    }
}

