/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.info.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.info.internal.ActivityTimer;
import com.ibm.ws.anno.info.internal.ClassInfoCache;
import com.ibm.ws.anno.info.internal.ClassInfoImpl;
import com.ibm.ws.anno.info.internal.InfoStoreFactoryImpl;
import com.ibm.ws.anno.info.internal.InfoVisitor;
import com.ibm.ws.anno.info.internal.NonDelayedClassInfo;
import com.ibm.ws.anno.info.internal.PackageInfoImpl;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.anno.info.InfoStoreException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class InfoStoreImpl
implements InfoStore {
    private static final TraceComponent tc = Tr.register(InfoStoreImpl.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final TraceComponent scanStateLogger = AnnotationServiceImpl_Logging.stateLogger;
    public static final String CLASS_NAME = InfoStoreImpl.class.getName();
    protected final String hashText;
    protected final InfoStoreFactoryImpl infoStoreFactory;
    protected final ClassSource_Aggregate classSource;
    protected ClassInfoCache classInfoCache;
    protected int streamCount;
    protected ActivityTimer activityTimer = new ActivityTimer();
    protected long streamTime;
    protected long scanTime;
    protected long ruleTime;
    static final long serialVersionUID = -174359648717412744L;

    @Override
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    @ManualTrace
    public InfoStoreImpl(InfoStoreFactoryImpl infoStoreFactory, ClassSource_Aggregate classSource) {
        String methodName = "<init>";
        this.hashText = AnnotationServiceImpl_Logging.getBaseHash(this) + "( " + classSource.hashCode() + " )";
        Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{this.hashText});
        this.infoStoreFactory = infoStoreFactory;
        this.classSource = classSource;
        this.classInfoCache = new ClassInfoCache(this);
        Tr.exit((TraceComponent)tc, (String)methodName, (Object)this.hashText);
    }

    @Override
    public InfoStoreFactoryImpl getInfoStoreFactory() {
        return this.infoStoreFactory;
    }

    @Override
    public ClassSource_Aggregate getClassSource() {
        return this.classSource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open() throws InfoStoreException {
        String methodName = "open";
        try {
            this.getClassSource().open();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"93", (Object)this, (Object[])new Object[0]);
            String eMsg = "[ " + this.getHashText() + " ] Failed to open class source ";
            throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws InfoStoreException {
        String methodName = "close";
        try {
            this.getClassSource().close();
        }
        catch (ClassSource_Exception classSource_Exception) {
            void e;
            FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"116", (Object)this, (Object[])new Object[0]);
            String eMsg = "[ " + this.getHashText() + " ] Failed to close class source ";
            throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, (Throwable)e);
        }
    }

    public void scanClass(String className) throws InfoStoreException {
        Object[] logParms;
        if (tc.isDebugEnabled()) {
            logParms = new Object[]{this.getHashText(), className};
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] ENTER", logParms), (Object[])new Object[0]);
        } else {
            logParms = null;
        }
        ClassInfoImpl classInfo = this.getNonDelayedClassInfo(className);
        if (classInfo != null) {
            if (logParms != null) {
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] RETURN Already loaded", logParms), (Object[])new Object[0]);
            }
            return;
        }
        this.scanNewClass(className);
        if (logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] RETURN New load", logParms), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    public void scanNewClass(String className) throws InfoStoreException {
        Object[] logParms;
        block13: {
            String resourceName;
            block12: {
                String methodName = "scanNewClass";
                if (tc.isDebugEnabled()) {
                    logParms = new Object[]{this.getHashText(), className, null};
                    Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] ENTER", logParms), (Object[])new Object[0]);
                } else {
                    logParms = null;
                }
                this.incrementStreamCount();
                this.startStreamTime();
                ClassSource_Aggregate useClassSource = this.getClassSource();
                resourceName = useClassSource.getResourceNameFromClassName(className);
                InputStream inputStream = null;
                try {
                    inputStream = this.getClassSource().openResourceStream(className, resourceName);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"178", (Object)this, (Object[])new Object[]{className});
                    String eMsg = "[ " + this.getHashText() + " ] Failed to open input stream for resource [ " + resourceName + " ] class [ " + className + " ] from [ " + useClassSource.getName() + " ]";
                    throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, (Throwable)e);
                }
                if (inputStream == null) break block12;
                try {
                    this.scanNewClass(resourceName, className, inputStream);
                }
                catch (Throwable throwable) {
                    try {
                        this.getClassSource().closeResourceStream(className, resourceName, inputStream);
                    }
                    catch (ClassSource_Exception classSource_Exception) {
                        void e;
                        FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"197", (Object)this, (Object[])new Object[]{className});
                        String eMsg = "[ " + this.getHashText() + " ] Failed to close input stream for resource [ " + resourceName + " ] for class [ " + className + " ]";
                        throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, (Throwable)e);
                    }
                    this.endStreamTime();
                    throw throwable;
                }
                try {
                    this.getClassSource().closeResourceStream(className, resourceName, inputStream);
                }
                catch (ClassSource_Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"197", (Object)this, (Object[])new Object[]{className});
                    String eMsg = "[ " + this.getHashText() + " ] Failed to close input stream for resource [ " + resourceName + " ] for class [ " + className + " ]";
                    throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, e);
                }
                this.endStreamTime();
                break block13;
            }
            this.endStreamTime();
            if (logParms != null) {
                logParms[2] = resourceName;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Failed to open input stream for Class [ {1} ], resource [ {2} ]", logParms), (Object[])new Object[0]);
            }
        }
        if (logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Class [ {1} ] RETURN", logParms), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    public void scanNewClass(String resourceName, String className, InputStream inputStream) throws InfoStoreException {
        Object[] logParms;
        String methodName = "scanNewClass";
        if (tc.isDebugEnabled()) {
            logParms = new Object[]{this.getHashText(), className, resourceName};
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER Class [ {1} ] from resource [ {2} ]", logParms), (Object[])new Object[0]);
        } else {
            logParms = null;
        }
        this.startScanTime();
        try {
            ClassReader classReader;
            try {
                classReader = new ClassReader(inputStream);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"249", (Object)this, (Object[])new Object[]{resourceName, className, inputStream});
                String eMsg = "Class [ " + className + " ] from resource [ " + resourceName + " ] Exception creating reader";
                throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg, (Throwable)e);
            }
            InfoVisitor infoVisitor = new InfoVisitor(this, className);
            try {
                classReader.accept((ClassVisitor)infoVisitor, 7);
            }
            catch (Exception eMsg) {
                void e;
                FFDCFilter.processException((Throwable)eMsg, (String)"com.ibm.ws.anno.info.internal.InfoStoreImpl", (String)"262", (Object)this, (Object[])new Object[]{resourceName, className, inputStream});
                String eMsg2 = "Target [ " + className + " ] from resource [ " + resourceName + " ] Processing exception: " + e.getMessage();
                throw InfoStoreException.wrap(tc, CLASS_NAME, methodName, eMsg2, (Throwable)e);
            }
        }
        finally {
            this.endScanTime();
        }
        if (logParms != null) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN Class [ {1} ] from resource [ {2} ]", logParms), (Object[])new Object[0]);
        }
    }

    public ClassInfoCache getClassInfoCache() {
        return this.classInfoCache;
    }

    @Override
    public String internDescription(String name) {
        return this.getClassInfoCache().internDescription(name);
    }

    @Override
    public String internPackageName(String packageName) {
        return this.getClassInfoCache().internPackageName(packageName);
    }

    @Override
    public String internClassName(String className) {
        return this.getClassInfoCache().internClassName(className);
    }

    public String internMethodName(String name) {
        return this.getClassInfoCache().internMethodName(name);
    }

    public String internFieldName(String name) {
        return this.getClassInfoCache().internFieldName(name);
    }

    protected PackageInfoImpl basicGetPackageInfo(String name) {
        return this.getClassInfoCache().basicGetPackageInfo(name);
    }

    protected PackageInfoImpl basicAddPackageInfo(String name, int access) {
        return this.getClassInfoCache().basicAddPackageInfo(name, access);
    }

    @Override
    public PackageInfoImpl getPackageInfo(String name) {
        return this.getClassInfoCache().getPackageInfo(name, false);
    }

    protected PackageInfoImpl getPackageInfo(String name, boolean doForce) {
        return this.getClassInfoCache().getPackageInfo(name, doForce);
    }

    @Override
    public ClassInfoImpl getDelayableClassInfo(String name) {
        return this.getClassInfoCache().getDelayableClassInfo(name, true);
    }

    protected ClassInfoImpl getNonDelayedClassInfo(String name) {
        return this.getClassInfoCache().getNonDelayedClassInfo(name, true);
    }

    protected ClassInfoImpl getDelayableClassInfo(Type type) {
        return this.getClassInfoCache().getDelayableClassInfo(type);
    }

    protected boolean addClassInfo(NonDelayedClassInfo classInfo) {
        return this.getClassInfoCache().addClassInfo(classInfo);
    }

    protected NonDelayedClassInfo createClassInfo(String name, String superName, int access, String[] interfaces) {
        return this.getClassInfoCache().createClassInfo(name, superName, access, interfaces);
    }

    protected NonDelayedClassInfo resolveClassInfo(String name) {
        return this.getClassInfoCache().resolveClassInfo(name);
    }

    protected void recordAccess(NonDelayedClassInfo classInfo) {
        this.getClassInfoCache().recordAccess(classInfo);
    }

    protected void removeAsDelayable(NonDelayedClassInfo classInfo) {
        this.getClassInfoCache().removeAsDelayable(classInfo);
    }

    @Override
    @Trivial
    public void log(TraceComponent logger) {
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("BEGIN STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
        this.getClassInfoCache().log(logger);
        Tr.debug((TraceComponent)logger, (String)MessageFormat.format("END STATE [ {0} ]", this.getHashText()), (Object[])new Object[0]);
    }

    @Trivial
    public void logState() {
        if (scanStateLogger.isDebugEnabled()) {
            this.log(scanStateLogger);
        }
    }

    @Override
    public long getStreamCount() {
        return this.streamCount;
    }

    protected void incrementStreamCount() {
        ++this.streamCount;
    }

    protected void startActivity() {
        this.activityTimer.startActivity();
    }

    protected long endActivity() {
        return this.activityTimer.endActivity();
    }

    @Override
    public long getStreamTime() {
        return this.streamTime;
    }

    protected void startStreamTime() {
        this.startActivity();
    }

    protected void endStreamTime() {
        this.streamTime += this.endActivity();
    }

    @Override
    public long getScanTime() {
        return this.scanTime;
    }

    protected void startScanTime() {
        this.startActivity();
    }

    protected void endScanTime() {
        this.scanTime += this.endActivity();
    }

    @Override
    public long getRuleTime() {
        return this.ruleTime;
    }

    protected void startRuleTime() {
        this.startActivity();
    }

    protected void endRuleTime() {
        this.ruleTime += this.endActivity();
    }
}

