/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.anno.classsource.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_Factory;
import com.ibm.ws.anno.classsource.internal.ClassSourceImpl_ScanCounts;
import com.ibm.ws.anno.classsource.internal.JandexLogger;
import com.ibm.ws.anno.service.internal.AnnotationServiceImpl_Logging;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.anno.classsource.ClassSource;
import com.ibm.wsspi.anno.classsource.ClassSource_Aggregate;
import com.ibm.wsspi.anno.classsource.ClassSource_Exception;
import com.ibm.wsspi.anno.classsource.ClassSource_Options;
import com.ibm.wsspi.anno.classsource.ClassSource_ScanCounts;
import com.ibm.wsspi.anno.classsource.ClassSource_Streamer;
import com.ibm.wsspi.anno.util.Util_InternMap;
import java.io.File;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Set;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ClassSourceImpl
implements ClassSource {
    private static final TraceComponent tc = Tr.register(ClassSourceImpl.class, (String)"com.ibm.ws.anno", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
    public static final String CLASS_NAME = ClassSourceImpl.class.getName();
    protected final String hashText;
    protected final ClassSourceImpl_Factory factory;
    protected final String name;
    protected final String canonicalName;
    protected ClassSource parentSource;
    protected final ClassSource_Options options;
    protected final Util_InternMap internMap;
    protected final ClassSourceImpl_ScanCounts scanCounts;
    protected int resourceExclusionCount;
    protected int classExclusionCount;
    protected int classInclusionCount;
    protected boolean processedUsingJandex = false;
    private static final int META_INF_LENGTH = "META-INF".length();
    static final long serialVersionUID = -728630342093167863L;

    @Trivial
    protected static long getTime() {
        return System.currentTimeMillis();
    }

    protected static String getAbsolutePath(String path) {
        return new File(path).getAbsolutePath();
    }

    @Override
    @Trivial
    public String getHashText() {
        return this.hashText;
    }

    @Trivial
    public String toString() {
        return this.hashText;
    }

    @Trivial
    protected ClassSourceImpl(ClassSourceImpl_Factory factory, Util_InternMap internMap, String name, ClassSource_Options options, String hashTextSuffix) {
        this.factory = factory;
        this.internMap = internMap;
        this.name = name;
        this.canonicalName = factory.getCanonicalName(this.name);
        this.parentSource = null;
        this.options = options;
        String useHashText = AnnotationServiceImpl_Logging.getBaseHash(this);
        useHashText = useHashText + "(" + this.canonicalName;
        if (hashTextSuffix != null) {
            useHashText = useHashText + ", " + hashTextSuffix;
        }
        this.hashText = useHashText = useHashText + ")";
        this.scanCounts = new ClassSourceImpl_ScanCounts();
        if (tc.isDebugEnabled()) {
            String msg = MessageFormat.format("[ {0} ] InternMap [ {1} ]", this.hashText, internMap.getHashText());
            Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public ClassSourceImpl_Factory getFactory() {
        return this.factory;
    }

    @Override
    @Trivial
    public String getName() {
        return this.name;
    }

    @Override
    @Trivial
    public String getCanonicalName() {
        return this.canonicalName;
    }

    @Override
    @Trivial
    public ClassSource getParentSource() {
        return this.parentSource;
    }

    @Override
    public void setParentSource(ClassSource parentSource) {
        this.parentSource = parentSource;
    }

    @Override
    @Trivial
    public ClassSource_Options getOptions() {
        return this.options;
    }

    @Trivial
    public boolean getUseJandex() {
        return this.getOptions().getUseJandex();
    }

    @Trivial
    public boolean getConvertResourceNames() {
        return false;
    }

    @Override
    @Trivial
    public String inconvertResourceName(String externalResourceName) {
        return externalResourceName;
    }

    @Override
    @Trivial
    public String outconvertResourceName(String resourceName) {
        return resourceName;
    }

    @Override
    @Trivial
    public Util_InternMap getInternMap() {
        return this.internMap;
    }

    @Trivial
    protected String internClassName(String className) {
        return this.getInternMap().intern(className);
    }

    @Override
    public abstract void open() throws ClassSource_Exception;

    @Override
    public abstract void close() throws ClassSource_Exception;

    @Override
    @Trivial
    public boolean isDirectoryResource(String resourceName) {
        return resourceName.endsWith("/");
    }

    @Override
    @Trivial
    public boolean isClassResource(String resourceName) {
        return resourceName.endsWith(".class");
    }

    @Override
    @Trivial
    public String getClassNameFromResourceName(String resourceName) {
        int endingOffset = resourceName.length() - ".class".length();
        String className = resourceName.substring(0, endingOffset);
        className = className.replace('/', '.');
        return className;
    }

    @Override
    @Trivial
    public String getResourceNameFromClassName(String className) {
        return className.replace('.', '/') + ".class";
    }

    @Override
    @Trivial
    public String resourceAppend(String head, String tail) {
        if (head.isEmpty()) {
            return tail;
        }
        return head + '/' + tail;
    }

    @Override
    @Trivial
    public ClassSourceImpl_ScanCounts getScanResults() {
        return this.scanCounts;
    }

    protected void markResult(ClassSource_ScanCounts.ResultField resultField) {
        this.scanCounts.increment(resultField);
    }

    protected void addResults(ClassSource_ScanCounts partialScanCounts) {
        this.scanCounts.addResults(partialScanCounts);
    }

    @Override
    @Trivial
    public int getResult(ClassSource_ScanCounts.ResultField resultField) {
        return this.scanCounts.getResult(resultField);
    }

    @Override
    @Trivial
    public boolean scanSpecificSeedClass(String className, ClassSource_Streamer streamer) throws ClassSource_Exception {
        return this.scanClass(streamer, className, ClassSource_Aggregate.ScanPolicy.SEED);
    }

    @Override
    @Trivial
    public boolean scanReferencedClass(String referencedClassName, ClassSource_Streamer streamer) throws ClassSource_Exception {
        return this.scanClass(streamer, referencedClassName, ClassSource_Aggregate.ScanPolicy.EXTERNAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    @ManualTrace
    protected boolean scanClass(ClassSource_Streamer streamer, String className, ClassSource_Aggregate.ScanPolicy scanPolicy) throws ClassSource_Exception {
        Object[] logParms;
        String methodName = "scanClass";
        if (tc.isEntryEnabled()) {
            logParms = new Object[]{this.getHashText(), className};
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{MessageFormat.format("[ {0} ] Name [ {1} ]", logParms)});
        } else {
            logParms = null;
        }
        if (!streamer.doProcess(className, scanPolicy)) {
            if (logParms != null) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ false ]: Filtered by streamer", logParms));
            }
            return false;
        }
        String resourceName = this.getResourceNameFromClassName(className);
        InputStream inputStream = this.openResourceStream(className, resourceName);
        if (inputStream == null) {
            if (logParms != null) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ false ]: No resource is available", logParms));
            }
            return false;
        }
        try {
            streamer.process(this.getCanonicalName(), className, inputStream, scanPolicy);
        }
        finally {
            this.closeResourceStream(className, resourceName, inputStream);
        }
        if (logParms != null) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)MessageFormat.format("[ {0} ] Return [ {1} ] [ true ]", logParms));
        }
        return true;
    }

    @Trivial
    protected boolean i_maybeAdd(String i_resourceName, Set<String> i_seedClassNamesSet) {
        String methodName = "i_maybeAdd";
        boolean didAdd = !i_seedClassNamesSet.contains(i_resourceName);
        if (didAdd) {
            i_seedClassNamesSet.add(i_resourceName);
        }
        if (tc.isDebugEnabled()) {
            String msg = MessageFormat.format("[ {0} ] Resource [ {1} ]: [ {2} ]", this.getHashText(), i_resourceName, didAdd);
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{msg});
        }
        return didAdd;
    }

    @Override
    @Trivial
    public InputStream openClassStream(String className) throws ClassSource_Exception {
        String resourceName = this.getResourceNameFromClassName(className);
        return this.openResourceStream(className, resourceName);
    }

    @Override
    @Trivial
    public void closeClassStream(String className, InputStream inputStream) {
        String resourceName = this.getResourceNameFromClassName(className);
        this.closeResourceStream(className, resourceName, inputStream);
    }

    @Override
    public abstract InputStream openResourceStream(String var1, String var2) throws ClassSource_Exception;

    @Override
    public abstract void closeResourceStream(String var1, String var2, InputStream var3);

    protected void incrementResourceExclusionCount() {
        ++this.resourceExclusionCount;
    }

    @Override
    @Trivial
    public int getResourceExclusionCount() {
        return this.resourceExclusionCount;
    }

    protected void incrementClassExclusionCount() {
        ++this.classExclusionCount;
    }

    @Override
    @Trivial
    public int getClassExclusionCount() {
        return this.classExclusionCount;
    }

    protected void incrementClassInclusionCount() {
        ++this.classInclusionCount;
    }

    @Override
    @Trivial
    public int getClassInclusionCount() {
        return this.classInclusionCount;
    }

    @Override
    @Trivial
    public void logState() {
        TraceComponent stateLogger = AnnotationServiceImpl_Logging.stateLogger;
        if (stateLogger.isDebugEnabled()) {
            this.log(stateLogger);
        }
    }

    @Override
    public abstract void log(TraceComponent var1);

    @Trivial
    protected void logCounts(TraceComponent logger) {
        if (logger.isDebugEnabled()) {
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Included classes: [ {0} ]", this.getClassInclusionCount()), (Object[])new Object[0]);
            Tr.debug((TraceComponent)logger, (String)MessageFormat.format("  Excluded classes: [ {0} ]", this.getClassExclusionCount()), (Object[])new Object[0]);
        }
    }

    @Override
    public void scanClasses(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        boolean fromJandex;
        String methodName = "scanClasses";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] ENTER", this.getHashText()), (Object[])new Object[0]);
        }
        int initialClasses = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Processing [ {1} ] Initial classes [ {2} ]", this.getHashText(), this.getCanonicalName(), initialClasses), (Object[])new Object[0]);
        }
        if (this.processFromCache(streamer, i_seedClassNames, scanPolicy)) {
            fromJandex = true;
        } else {
            this.processFromScratch(streamer, i_seedClassNames, scanPolicy);
            fromJandex = false;
        }
        int finalClasses = i_seedClassNames.size();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] Processing [ {1} ] {2}; Final classes [ {3} ]", this.getHashText(), this.getCanonicalName(), fromJandex ? "New Scan" : "Jandex", finalClasses), (Object[])new Object[0]);
            Object[] logParms = new Object[]{this.getHashText(), null, null};
            logParms[1] = finalClasses - initialClasses;
            Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ] RETURN [ {1} ] Added classes", logParms), (Object[])new Object[0]);
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = this.getResult(resultField);
                String nextResultTag = resultField.getTag();
                logParms[1] = nextResult;
                logParms[2] = nextResultTag;
                Tr.debug((TraceComponent)tc, (String)MessageFormat.format("[ {0} ]  [ {1} ] {2}", logParms), (Object[])new Object[0]);
            }
        }
        if (fromJandex && JandexLogger.doLog()) {
            String useHashText = this.getHashText();
            String msg = MessageFormat.format("[ {0} ] Processing [ {1} ] {2}; Final classes [ {3} ]", useHashText, this.getCanonicalName(), fromJandex ? "New Scan" : "Jandex", finalClasses);
            JandexLogger.log(CLASS_NAME, methodName, msg);
            JandexLogger.log(CLASS_NAME, methodName, MessageFormat.format("[ {0} ] Added classes [ {1} ]", useHashText, finalClasses - initialClasses));
            for (ClassSource_ScanCounts.ResultField resultField : ClassSource_ScanCounts.ResultField.values()) {
                int nextResult = this.getResult(resultField);
                String nextResultTag = resultField.getTag();
                JandexLogger.log(CLASS_NAME, methodName, MessageFormat.format("[ {0} ]  [ {1} ] {2}", useHashText, nextResult, nextResultTag));
            }
        }
    }

    protected abstract void processFromScratch(ClassSource_Streamer var1, Set<String> var2, ClassSource_Aggregate.ScanPolicy var3);

    @Trivial
    public String getJandexIndexPath() {
        return "/META-INF/jandex.idx";
    }

    protected Index getJandexIndex() {
        String methodName = "getJandexIndex";
        boolean doLog = tc.isDebugEnabled();
        boolean doJandexLog = JandexLogger.doLog();
        boolean useJandex = this.getUseJandex();
        if (!useJandex) {
            if (doLog || doJandexLog) {
                boolean haveJandex = this.basicHasJandexIndex();
                String msg = haveJandex ? MessageFormat.format("[ {0} ] Jandex disabled; Jandex index [ {1} ] found", this.getHashText(), this.getJandexIndexPath()) : MessageFormat.format("[ {0} ] Jandex disabled; Jandex index [ {1} ] not found", this.getHashText(), this.getJandexIndexPath());
                if (doLog) {
                    Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                }
                if (doJandexLog) {
                    JandexLogger.log(CLASS_NAME, methodName, msg);
                }
            }
            return null;
        }
        Index jandexIndex = this.basicGetJandexIndex();
        if (doLog || doJandexLog) {
            String msg = jandexIndex != null ? MessageFormat.format("[ {0} ] Jandex enabled; Jandex index [ {1} ] found", this.getHashText(), this.getJandexIndexPath()) : MessageFormat.format("[ {0} ] Jandex enabled; Jandex index [ {1} ] not found", this.getHashText(), this.getJandexIndexPath());
            if (doLog) {
                Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            }
            if (doJandexLog) {
                JandexLogger.log(CLASS_NAME, methodName, msg);
            }
        }
        return jandexIndex;
    }

    protected Index basicGetJandexIndex() {
        return null;
    }

    protected boolean basicHasJandexIndex() {
        return false;
    }

    @Override
    public boolean isProcessedUsingJandex() {
        return this.processedUsingJandex;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean processFromCache(ClassSource_Streamer streamer, Set<String> i_seedClassNames, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        if (streamer == null) {
            return false;
        }
        Index jandexIndex = this.getJandexIndex();
        if (jandexIndex == null) {
            return false;
        }
        this.processedUsingJandex = true;
        String useClassSourceName = this.getCanonicalName();
        for (ClassInfo nextJandexClassInfo : jandexIndex.getKnownClasses()) {
            boolean didProcess;
            DotName nextClassDotName = nextJandexClassInfo.name();
            String nextClassName = nextClassDotName.toString();
            this.markResult(ClassSource_ScanCounts.ResultField.ENTRY);
            this.markResult(ClassSource_ScanCounts.ResultField.NON_CONTAINER);
            this.markResult(ClassSource_ScanCounts.ResultField.CLASS);
            String i_nextClassName = this.internClassName(nextClassName);
            boolean didAdd = this.i_maybeAdd(i_nextClassName, i_seedClassNames);
            if (!didAdd) {
                this.incrementClassExclusionCount();
                this.markResult(ClassSource_ScanCounts.ResultField.DUPLICATE_CLASS);
                continue;
            }
            this.incrementClassInclusionCount();
            if (!streamer.doProcess(i_nextClassName, scanPolicy)) {
                didProcess = false;
            } else {
                try {
                    didProcess = streamer.process(useClassSourceName, nextJandexClassInfo, scanPolicy);
                }
                catch (ClassSource_Exception classSource_Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)classSource_Exception, (String)"com.ibm.ws.anno.classsource.internal.ClassSourceImpl", (String)"731", (Object)this, (Object[])new Object[]{streamer, i_seedClassNames, scanPolicy});
                    didProcess = false;
                    Tr.warning((TraceComponent)tc, (String)"JANDEX_SCAN_EXCEPTION", (Object[])new Object[]{i_nextClassName, this.getHashText(), e});
                }
            }
            if (didProcess) {
                this.markResult(ClassSource_ScanCounts.ResultField.PROCESSED_CLASS);
                continue;
            }
            this.markResult(ClassSource_ScanCounts.ResultField.UNPROCESSED_CLASS);
        }
        return true;
    }

    protected boolean isJava9SpecificClass(String className) {
        if (className.length() >= META_INF_LENGTH && className.regionMatches(true, 0, "META-INF", 0, META_INF_LENGTH)) {
            return true;
        }
        return className.endsWith("module-info");
    }
}

