/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TopicWildcardTranslationImpl
extends TopicWildcardTranslation {
    private static TraceComponent tcInt = SibTr.register(TopicWildcardTranslationImpl.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.utils.CWSIUMessages");
    private Pattern sibPattern = Pattern.compile("(//)?([^:./*][^:/*]*|[*])(//?([^:./*][^:/*]*|[*]|[.]))*");

    @Override
    public String convertSIBToEventBroker(String sibTopic) throws ParseException {
        int newStartAt;
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.entry(this, tcInt, "convertSIBToEventBroker", sibTopic);
        }
        if ("//*".equals(sibTopic)) {
            if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
                SibTr.exit(this, tcInt, "convertSIBToEventBroker", "#");
            }
            return "#";
        }
        if ("*".equals(sibTopic)) {
            if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
                SibTr.exit(this, tcInt, "convertSIBToEventBroker", "+");
            }
            return "+";
        }
        int startAt = 0;
        while ((newStartAt = sibTopic.indexOf("//.", startAt)) != -1) {
            sibTopic = sibTopic.substring(0, newStartAt) + "/#" + sibTopic.substring(newStartAt + 3);
            startAt = newStartAt + 1;
        }
        startAt = 0;
        while ((newStartAt = sibTopic.indexOf("/*", startAt)) != -1) {
            sibTopic = sibTopic.replace('*', '+');
            startAt = newStartAt + 1;
        }
        startAt = 0;
        while ((newStartAt = sibTopic.indexOf("/./", startAt)) != -1) {
            sibTopic = sibTopic.substring(0, newStartAt + 1) + sibTopic.substring(newStartAt + 3);
            startAt = newStartAt + 1;
        }
        if (sibTopic.startsWith("//")) {
            sibTopic = "#" + sibTopic.substring(1);
        }
        startAt = 0;
        while ((newStartAt = sibTopic.indexOf("//", startAt)) != -1) {
            sibTopic = sibTopic.substring(0, newStartAt + 1) + "#" + sibTopic.substring(newStartAt + 1);
            startAt = newStartAt + 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.exit(this, tcInt, "convertSIBToEventBroker", sibTopic);
        }
        return sibTopic;
    }

    @Override
    public String convertEventBrokerToSIB(String ebTopic) throws ParseException {
        int newStartAt;
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.entry(this, tcInt, "convertEventBrokerToSIB", ebTopic);
        }
        if ("#".equals(ebTopic)) {
            if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
                SibTr.exit(this, tcInt, "convertEventBrokerToSIB", "//*");
            }
            return "//*";
        }
        if ("+".equals(ebTopic)) {
            if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
                SibTr.exit(this, tcInt, "convertEventBrokerToSIB", "*");
            }
            return "*";
        }
        int startAt = 0;
        while ((newStartAt = ebTopic.indexOf("/#", startAt)) != -1) {
            if (newStartAt + 2 == ebTopic.length()) {
                ebTopic = ebTopic.replace('#', '/');
                ebTopic = ebTopic.substring(0, newStartAt + 2) + "." + ebTopic.substring(newStartAt + 2);
                startAt = newStartAt + 1;
                continue;
            }
            ebTopic = ebTopic.substring(0, newStartAt + 1) + "/" + ebTopic.substring(newStartAt + 3);
            startAt = newStartAt + 1;
        }
        if (ebTopic.startsWith("#/")) {
            ebTopic = "/" + ebTopic.substring(1);
        }
        startAt = 0;
        while ((newStartAt = ebTopic.indexOf("/+", startAt)) != -1) {
            ebTopic = ebTopic.replace('+', '*');
            startAt = newStartAt + 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.exit(this, tcInt, "convertEventBrokerToSIB", ebTopic);
        }
        return ebTopic;
    }

    @Override
    public String convertMA0CToSIB(String ma0cTopic) throws ParseException {
        int newStartAt;
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.entry(this, tcInt, "convertMA0CToSIB", ma0cTopic);
        }
        if (ma0cTopic.indexOf("?") != -1) {
            throw new ParseException(nls.getFormattedMessage("INVALID_WILDCARD_CHAR_CWSIU0011", new Object[]{"?", ma0cTopic}, null), 0);
        }
        if (ma0cTopic.startsWith("*")) {
            ma0cTopic = "/" + ma0cTopic;
        }
        int startAt = 0;
        while ((newStartAt = ma0cTopic.indexOf("*", startAt)) != -1) {
            char afterChar;
            char prevChar;
            boolean isInvalid = false;
            if (newStartAt > 0 && (prevChar = ma0cTopic.charAt(newStartAt - 1)) != '/') {
                isInvalid = true;
                if (TraceComponent.isAnyTracingEnabled() && tcInt.isDebugEnabled()) {
                    SibTr.debug(this, tcInt, "Invalid MA0C topic - * is not preceeded by /");
                }
            }
            if (newStartAt < ma0cTopic.length() - 1 && (afterChar = ma0cTopic.charAt(newStartAt + 1)) != '/') {
                isInvalid = true;
                if (TraceComponent.isAnyTracingEnabled() && tcInt.isDebugEnabled()) {
                    SibTr.debug(this, tcInt, "Invalid MA0C topic - * is not followed by /");
                }
            }
            if (isInvalid) {
                throw new ParseException(nls.getFormattedMessage("INVALID_ASTERIX_WILDCARD_CWSIU0012", new Object[]{ma0cTopic}, null), 0);
            }
            ma0cTopic = ma0cTopic.substring(0, newStartAt) + "/" + ma0cTopic.substring(newStartAt, ma0cTopic.length());
            startAt = newStartAt + 2;
        }
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.exit(this, tcInt, "convertMA0CToSIB", ma0cTopic);
        }
        return ma0cTopic;
    }

    @Override
    public boolean isValidSIBTopic(String sibTopic) {
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.entry(this, tcInt, "isValidSIBTopic", sibTopic);
        }
        boolean ret = false;
        if (sibTopic == null || "".equals(sibTopic)) {
            ret = true;
        } else {
            Matcher m = this.sibPattern.matcher(sibTopic);
            ret = m.matches();
        }
        if (TraceComponent.isAnyTracingEnabled() && tcInt.isEntryEnabled()) {
            SibTr.exit(tcInt, "isValidSIBTopic", ret);
        }
        return ret;
    }
}

