/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;

public final class HexString {
    private static final TraceComponent tc = SibTr.register(HexString.class, "SIBUtils", "com.ibm.ws.sib.utils.CWSIUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.utils.CWSIUMessages");

    public static void binToHex(byte[] bin, int start, int length, StringBuffer hex) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(tc, "binToHex", new Object[]{bin, start, length, hex});
        }
        char[] BIN2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        for (int i = start; i < start + length; ++i) {
            int binByte = bin[i];
            if (binByte < 0) {
                binByte += 256;
            }
            hex.append(BIN2HEX[binByte / 16]);
            hex.append(BIN2HEX[binByte % 16]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(tc, "binToHex", hex);
        }
    }

    public static String binToHex(byte[] bin) {
        StringBuffer hex = new StringBuffer();
        HexString.binToHex(bin, 0, bin.length, hex);
        return hex.toString();
    }

    public static byte[] hexToBin(String hex, int start) {
        int length;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry(tc, "hexToBin", new Object[]{hex, start});
        }
        if ((length = hex.length() - start) == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit(tc, "hexToBin");
            }
            return new byte[0];
        }
        if (length < 0 || length % 2 != 0) {
            String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIU0200", new Object[]{hex}, "The hexadecimal string " + hex + " is incorrectly formatted.");
            IllegalArgumentException e = new IllegalArgumentException(nlsMsg);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit(tc, "hexToBin", e);
            }
            throw e;
        }
        byte[] retval = new byte[length /= 2];
        for (int i = 0; i < length; ++i) {
            int digit1 = Character.digit(hex.charAt(2 * i + start), 16) << 4;
            int digit2 = Character.digit(hex.charAt(2 * i + start + 1), 16);
            if (digit1 < 0 || digit2 < 0) {
                String nlsMsg = nls.getFormattedMessage("BAD_HEX_STRING_CWSIF0200", new Object[]{hex}, "The hexadecimal string " + hex + " is incorrectly formatted.");
                IllegalArgumentException e = new IllegalArgumentException(nlsMsg);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit(tc, "hexToBin", e);
                }
                throw e;
            }
            retval[i] = (byte)(digit1 + digit2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit(tc, "hexToBin");
        }
        return retval;
    }
}

