/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.utils;

public final class CryptoHash {
    public static long hash(byte[] data) {
        int[] code = CryptoHash.calculate(data);
        return (long)code[0] << 32 | (long)code[1] & 0xFFFFFFFFL;
    }

    public static void hash(byte[] data, byte[] output) {
        int len = output.length;
        if (len == 0) {
            return;
        }
        int[] code = CryptoHash.calculate(data);
        int outIndex = 0;
        int codeIndex = 0;
        int shift = 24;
        while (outIndex < len && codeIndex < 5) {
            output[outIndex] = (byte)(code[codeIndex] >>> shift);
            if (shift == 0) {
                shift = 32;
                ++codeIndex;
            }
            ++outIndex;
            shift -= 8;
        }
    }

    private static int[] calculate(byte[] data) {
        int A = 1732584193;
        int B = -271733879;
        int C = -1732584194;
        int D = 271733878;
        int E = -1009589776;
        int[] W = new int[80];
        int len = data.length;
        int off = 0;
        int n = len / 4;
        boolean done = false;
        boolean padded = false;
        while (!done) {
            int X;
            int i = 0;
            while (i < 16 && n > 0) {
                W[i++] = data[off + 3] & 0xFF | (data[off + 2] & 0xFF) << 8 | (data[off + 1] & 0xFF) << 16 | (data[off] & 0xFF) << 24;
                --n;
                off += 4;
            }
            if (i < 16) {
                if (!padded) {
                    X = len % 4;
                    int pad1 = 0;
                    for (int j = 0; j < X; ++j) {
                        pad1 |= (data[off + j] & 0xFF) << 24 - 8 * j;
                    }
                    W[i++] = pad1 | 1 << 31 - X * 8;
                    if (i == 15) {
                        W[15] = 0;
                    }
                    padded = true;
                }
                if (i <= 14) {
                    while (i < 14) {
                        W[i++] = 0;
                    }
                    W[14] = len >>> 29;
                    W[15] = len << 3;
                    done = true;
                }
                i = 16;
            }
            do {
                X = W[i - 3] ^ W[i - 8] ^ W[i - 14] ^ W[i - 16];
                W[i] = X << 1 | X >>> 31;
            } while (++i < 80);
            int A0 = A;
            int B0 = B;
            int C0 = C;
            int D0 = D;
            int E0 = E;
            i = 0;
            do {
                X = (A << 5 | A >>> 27) + (B & C | ~B & D) + E + W[i] + 1518500249;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 20);
            do {
                X = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W[i] + 1859775393;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 40);
            do {
                X = (A << 5 | A >>> 27) + (B & C | B & D | C & D) + E + W[i] + -1894007588;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 60);
            do {
                X = (A << 5 | A >>> 27) + (B ^ C ^ D) + E + W[i] + -899497514;
                E = D;
                D = C;
                C = B << 30 | B >>> 2;
                B = A;
                A = X;
            } while (++i < 80);
            A += A0;
            B += B0;
            C += C0;
            D += D0;
            E += E0;
        }
        int[] result = new int[]{A, B, C, D, E};
        return result;
    }
}

