/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.metadata.MetaDataSlotService;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.feature.LibertyFeature;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.telemetry.internal.common.info.DisabledOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfoInternal;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryLifecycleManager;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryPropertiesReader;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.commons.lang3.function.FailableSupplier;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ApplicationStateListener.class, OpenTelemetryLifecycleManager.class}, property={"service.vendor=IBM", "service.ranking:Integer=1500"})
public class OpenTelemtryLifecycleManagerImpl
implements ApplicationStateListener,
OpenTelemetryLifecycleManager {
    private static final TraceComponent tc = Tr.register(OpenTelemtryLifecycleManagerImpl.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private final MetaDataSlot slotForOpenTelemetryInfoHolder;
    private final OpenTelemetryInfoFactory openTelemetryInfoFactory;
    private final Set<String> warningsEmittedForInternalApps = ConcurrentHashMap.newKeySet();
    boolean telemetry2OrLater;
    private volatile boolean waitingForCheckpointRestore = true;
    private volatile boolean isRuntimeEnabled = false;
    private volatile LazyInitializer<OpenTelemetryInfoInternal> runtimeInstance = null;
    static final long serialVersionUID = -3811838213982902528L;

    @Activate
    public OpenTelemtryLifecycleManagerImpl(@Reference MetaDataSlotService slotService, @Reference OpenTelemetryInfoFactory openTelemetryInfoFactory, @Reference(service=LibertyFeature.class, target="(ibm.featureName=mpTelemetry-*)") ServiceReference<LibertyFeature> featureRef) {
        this.openTelemetryInfoFactory = openTelemetryInfoFactory;
        this.slotForOpenTelemetryInfoHolder = slotService.reserveMetaDataSlot(ApplicationMetaData.class);
        String shortName = (String)featureRef.getProperty("ibm.featureName");
        this.telemetry2OrLater = !shortName.startsWith("mpTelemetry-1");
        this.checkThenSetRuntimeFields();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkThenSetRuntimeFields() {
        if (this.waitingForCheckpointRestore) {
            OpenTelemtryLifecycleManagerImpl openTelemtryLifecycleManagerImpl = this;
            synchronized (openTelemtryLifecycleManagerImpl) {
                if (this.waitingForCheckpointRestore && CheckpointPhase.getPhase().restored()) {
                    HashMap<String, String> propreties = OpenTelemetryPropertiesReader.getRuntimeInstanceTelemetryProperties();
                    boolean bl = this.isRuntimeEnabled = this.telemetry2OrLater && OpenTelemetryPropertiesReader.isEnabled(propreties);
                    if (this.isRuntimeEnabled) {
                        this.runtimeInstance = ((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(this.curryInfoFactory(this.isRuntimeEnabled))).get();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Configured runtime mode as ", (Object[])new Object[]{this.isRuntimeEnabled});
                    }
                    this.waitingForCheckpointRestore = false;
                }
            }
        }
    }

    private FailableSupplier<OpenTelemetryInfoInternal, ? extends Exception> curryInfoFactory(boolean runtimeEnabled) {
        return () -> this.openTelemetryInfoFactory.createOpenTelemetryInfo(runtimeEnabled);
    }

    public void applicationStarting(ApplicationInfo appInfo) throws StateChangeException {
        this.checkThenSetRuntimeFields();
        if (this.isRuntimeEnabled) {
            HashMap<String, String> propreties = OpenTelemetryPropertiesReader.getTelemetryProperties();
            if (OpenTelemetryPropertiesReader.checkExplicitlyDisabled(propreties)) {
                String appName = appInfo.getName();
                Tr.warning((TraceComponent)tc, (String)"CWMOT5006.tel.enabled.conflict", (Object[])new Object[]{appName});
            }
            return;
        }
        ExtendedApplicationInfo extAppInfo = (ExtendedApplicationInfo)appInfo;
        OpenTelemetryInfoReference oTelRef = (OpenTelemetryInfoReference)extAppInfo.getMetaData().getMetaData(this.slotForOpenTelemetryInfoHolder);
        LazyInitializer newSupplier = ((LazyInitializer.Builder)((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(this.curryInfoFactory(this.isRuntimeEnabled))).setCloser(info -> info.dispose())).get();
        if (oTelRef == null) {
            oTelRef = new OpenTelemetryInfoReference();
        }
        oTelRef.set(newSupplier);
        extAppInfo.getMetaData().setMetaData(this.slotForOpenTelemetryInfoHolder, (Object)oTelRef);
    }

    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        this.checkThenSetRuntimeFields();
        if (this.isRuntimeEnabled) {
            return;
        }
        ExtendedApplicationInfo extAppInfo = (ExtendedApplicationInfo)appInfo;
        OpenTelemetryInfoReference oTelRef = (OpenTelemetryInfoReference)extAppInfo.getMetaData().getMetaData(this.slotForOpenTelemetryInfoHolder);
        LazyInitializer newSupplier = ((LazyInitializer.Builder)((LazyInitializer.Builder)LazyInitializer.builder().setInitializer(this.openTelemetryInfoFactory::createDisposedOpenTelemetryInfo)).setCloser(info -> info.dispose())).get();
        LazyInitializer oldSupplier = oTelRef.getAndSet(newSupplier);
        try {
            oldSupplier.close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl", (String)"167", (Object)this, (Object[])new Object[]{appInfo});
            Tr.warning((TraceComponent)tc, (String)"applicationStopped", (Object[])new Object[]{"failed to dispose of OpenTelemetry"});
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfoInternal getOpenTelemetryInfo() {
        try {
            ApplicationMetaData metaData = null;
            ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            if (cmd != null) {
                metaData = cmd.getModuleMetaData().getApplicationMetaData();
            }
            return this.getOpenTelemetryInfo(metaData);
        }
        catch (Exception metaData) {
            void e;
            FFDCFilter.processException((Throwable)metaData, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl", (String)"197", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OpenTelemetryInfoInternal getOpenTelemetryInfo(ApplicationMetaData metaData) {
        this.checkThenSetRuntimeFields();
        if (this.waitingForCheckpointRestore) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a disabled OTEL instance because we are waiting for a checkpoint restore .", (Object[])new Object[0]);
            }
            return this.openTelemetryInfoFactory.createDisabledOpenTelemetryInfo();
        }
        if (this.isRuntimeEnabled) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning {0} OTEL instance.", (Object[])new Object[]{"io.openliberty.microprofile.telemetry.runtime"});
            }
            try {
                return (OpenTelemetryInfoInternal)this.runtimeInstance.get();
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl", (String)"223", (Object)this, (Object[])new Object[]{metaData});
                Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
                return new ErrorOpenTelemetryInfo();
            }
        }
        if (metaData == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning a disabled OTEL instance because metadata was null", (Object[])new Object[0]);
            }
            return new DisabledOpenTelemetryInfo();
        }
        try {
            OpenTelemetryInfoReference atomicRef = (OpenTelemetryInfoReference)metaData.getMetaData(this.slotForOpenTelemetryInfoHolder);
            if (atomicRef == null) {
                String j2EEName = metaData.getJ2EEName().toString();
                if (j2EEName != null && this.warningsEmittedForInternalApps.add(j2EEName)) {
                    Tr.info((TraceComponent)tc, (String)"CWMOT5100.tracing.is.disabled", (Object[])new Object[]{j2EEName});
                }
                return new DisabledOpenTelemetryInfo();
            }
            LazyInitializer supplier = (LazyInitializer)atomicRef.get();
            return (OpenTelemetryInfoInternal)supplier.get();
        }
        catch (Exception atomicRef) {
            void e;
            FFDCFilter.processException((Throwable)atomicRef, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl", (String)"256", (Object)this, (Object[])new Object[]{metaData});
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new ErrorOpenTelemetryInfo();
        }
    }

    @Override
    public boolean isRuntimeEnabled() {
        this.checkThenSetRuntimeFields();
        return this.isRuntimeEnabled;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class OpenTelemetryInfoReference
    extends AtomicReference<LazyInitializer<OpenTelemetryInfoInternal>> {
        private static final long serialVersionUID = -4884222080590544495L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private OpenTelemetryInfoReference() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemtryLifecycleManagerImpl$OpenTelemetryInfoReference", OpenTelemetryInfoReference.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
        }
    }
}

