/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.common.info;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTelemetryPropertiesReader {
    private static final TraceComponent tc = Tr.register(OpenTelemetryPropertiesReader.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    static final long serialVersionUID = -7392611953252349313L;

    /*
     * WARNING - void declaration
     */
    public static HashMap<String, String> getTelemetryProperties() {
        try {
            Config config = ConfigProvider.getConfig();
            HashMap<String, String> telemetryProperties = new HashMap<String, String>();
            for (ConfigSource configSource : config.getConfigSources()) {
                for (Map.Entry entry : configSource.getProperties().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("otel") && !((String)entry.getKey()).startsWith("OTEL")) continue;
                    String normalizedName = ((String)entry.getKey()).toLowerCase().replace('_', '.');
                    config.getOptionalValue(normalizedName, String.class).ifPresent(value -> telemetryProperties.putIfAbsent(normalizedName, (String)value));
                }
            }
            return telemetryProperties;
        }
        catch (Exception config) {
            void e;
            FFDCFilter.processException((Throwable)config, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryPropertiesReader", (String)"61", null, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new HashMap<String, String>();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static HashMap<String, String> getRuntimeInstanceTelemetryProperties() {
        try {
            final HashMap<String, String> telemetryProperties = new HashMap<String, String>();
            AccessController.doPrivileged(new PrivilegedAction<String>(){
                static final long serialVersionUID = 8863389319420255062L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public String run() {
                    String propertyValue;
                    String normalizedName;
                    Map<String, String> envProperties = System.getenv();
                    Properties systemProperties = System.getProperties();
                    for (String propertyName : envProperties.keySet()) {
                        if (!propertyName.startsWith("otel") && !propertyName.startsWith("OTEL")) continue;
                        normalizedName = propertyName.toLowerCase().replace('_', '.');
                        propertyValue = envProperties.get(propertyName);
                        if (propertyValue == null) continue;
                        telemetryProperties.put(normalizedName, propertyValue);
                    }
                    for (String propertyName : systemProperties.keySet()) {
                        normalizedName = propertyName.toLowerCase().replace('_', '.');
                        if (!normalizedName.startsWith("otel")) continue;
                        propertyValue = (String)systemProperties.get(propertyName);
                        if (telemetryProperties.containsKey(normalizedName)) {
                            telemetryProperties.remove(normalizedName);
                        }
                        if (propertyValue == null) continue;
                        telemetryProperties.put(normalizedName, propertyValue);
                    }
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter", "com.ibm.ws.ras.instrument.internal.bci.FFDCMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryPropertiesReader$1", 1.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
                }
            });
            return telemetryProperties;
        }
        catch (Exception telemetryProperties) {
            void e;
            FFDCFilter.processException((Throwable)telemetryProperties, (String)"io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryPropertiesReader", (String)"116", null, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)Tr.formatMessage((TraceComponent)tc, (String)"CWMOT5002.telemetry.error", (Object[])new Object[]{e}), (Object[])new Object[0]);
            return new HashMap<String, String>();
        }
    }

    public static boolean isEnabled(Map<String, String> oTelConfigs) {
        if (oTelConfigs.get("OTEL_SDK_DISABLED") != null) {
            return Boolean.valueOf(oTelConfigs.get("OTEL_SDK_DISABLED")) == false;
        }
        if (oTelConfigs.get("otel.sdk.disabled") != null) {
            return Boolean.valueOf(oTelConfigs.get("otel.sdk.disabled")) == false;
        }
        return false;
    }

    public static boolean checkExplicitlyDisabled(Map<String, String> oTelConfigs) {
        if (oTelConfigs.get("OTEL_SDK_DISABLED") != null) {
            return Boolean.valueOf(oTelConfigs.get("OTEL_SDK_DISABLED"));
        }
        if (oTelConfigs.get("otel.sdk.disabled") != null) {
            return Boolean.valueOf(oTelConfigs.get("otel.sdk.disabled"));
        }
        return false;
    }
}

