/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class TagHandlerPool {
    private static final int MAX_POOL_SIZE = 5;
    private Tag[] handlers;
    public static String OPTION_TAGPOOL;
    public static String OPTION_MAXSIZE;
    private int current;
    static final long serialVersionUID = 7021765595358911776L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static TagHandlerPool getTagHandlerPool(ServletConfig config) {
        TagHandlerPool result = null;
        String tpClassName = TagHandlerPool.getOption(config, OPTION_TAGPOOL, null);
        if (tpClassName != null) {
            try {
                Class<?> c = Class.forName(tpClassName);
                result = (TagHandlerPool)c.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                result = null;
            }
        }
        if (result == null) {
            result = new TagHandlerPool();
        }
        result.init(config);
        return result;
    }

    protected void init(ServletConfig config) {
        int maxSize = -1;
        String maxSizeS = TagHandlerPool.getOption(config, OPTION_MAXSIZE, null);
        if (maxSizeS != null) {
            try {
                maxSize = Integer.parseInt(maxSizeS);
            }
            catch (Exception ex) {
                maxSize = -1;
            }
        }
        if (maxSize < 0) {
            maxSize = 5;
        }
        this.handlers = new Tag[maxSize];
        this.current = -1;
    }

    public TagHandlerPool() {
    }

    public TagHandlerPool(int capacity) {
        this.handlers = new Tag[capacity];
        this.current = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tag get(Class handlerClass) throws JspException {
        Tag handler = null;
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current >= 0) {
                handler = this.handlers[this.current--];
                return handler;
            }
        }
        try {
            return (Tag)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reuse(Tag handler) {
        TagHandlerPool tagHandlerPool = this;
        synchronized (tagHandlerPool) {
            if (this.current < this.handlers.length - 1) {
                this.handlers[++this.current] = handler;
                return;
            }
        }
        handler.release();
    }

    public synchronized void release() {
        for (int i = this.current; i >= 0; --i) {
            this.handlers[i].release();
        }
    }

    protected static String getOption(ServletConfig config, String name, String defaultV) {
        if (config == null) {
            return defaultV;
        }
        String value = config.getInitParameter(name);
        if (value != null) {
            return value;
        }
        if (config.getServletContext() == null) {
            return defaultV;
        }
        value = config.getServletContext().getInitParameter(name);
        if (value != null) {
            return value;
        }
        return defaultV;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.apache.jasper.runtime.TagHandlerPool", TagHandlerPool.class, null, null);
        OPTION_TAGPOOL = "jasper.tagpoolClassName";
        OPTION_MAXSIZE = "jasper.tagpoolMaxSize";
    }
}

