/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.visitor.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorCollection;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorConfiguration;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorDefinition;
import com.ibm.ws.jsp.translator.visitor.configuration.JspVisitorUsage;
import com.ibm.ws.jsp.translator.visitor.xml.ParserFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class VisitorConfigParser
extends DefaultHandler {
    public static final String DTD_PUBLIC_ID = "http://www.ibm.com/xml/ns/JspVisitorConfiguration.xsd";
    public static final String DTD_RESOURCE_PATH = "/com/ibm/ws/jsp/translator/visitor/configuration/JspVisitorConfiguration.xsd";
    protected SAXParser saxParser = null;
    protected JspVisitorUsage visitorUsage = null;
    protected JspVisitorCollection visitorCollection = null;
    protected JspVisitorDefinition visitorDefinition = null;
    protected JspVisitorConfiguration visitorConfiguration = null;
    protected String className = null;
    protected String resultType = null;
    protected StringBuffer chars = null;
    protected ClassLoader cl = null;
    static final long serialVersionUID = 257082003795451827L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public VisitorConfigParser(ClassLoader cl) throws JspCoreException {
        this.cl = cl;
        try {
            this.saxParser = ParserFactory.newSAXParser(false, true);
        }
        catch (ParserConfigurationException e) {
            throw new JspCoreException(e);
        }
        catch (SAXException e) {
            throw new JspCoreException(e);
        }
    }

    public JspVisitorConfiguration parse(InputStream is) throws JspCoreException {
        this.visitorConfiguration = new JspVisitorConfiguration();
        try {
            ParserFactory.parseDocument(this.saxParser, is, (DefaultHandler)this);
        }
        catch (SAXException e) {
            if (e.getCause() != null) {
                throw new JspCoreException(e.getCause());
            }
            throw new JspCoreException(e);
        }
        catch (IOException e) {
            throw new JspCoreException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return this.visitorConfiguration;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String elementName, Attributes attrs) throws SAXException {
        this.chars = new StringBuffer();
        if (elementName.equals("jsp-visitor-collection")) {
            this.visitorCollection = new JspVisitorCollection();
            this.visitorCollection.setId(attrs.getValue("id"));
        } else if (elementName.equals("jsp-visitor-definition")) {
            this.visitorDefinition = new JspVisitorDefinition();
            this.visitorDefinition.setId(attrs.getValue("id"));
        } else if (elementName.equals("jsp-visitor")) {
            int order = 1;
            int visits = 1;
            try {
                order = Integer.valueOf(attrs.getValue("order"));
                visits = Integer.valueOf(attrs.getValue("visits"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String id = attrs.getValue("id");
            this.visitorUsage = new JspVisitorUsage(order, visits, this.visitorConfiguration.getJspVisitorDefinition(id));
            this.visitorCollection.getJspVisitorUsageList().add(this.visitorUsage);
            this.visitorUsage = null;
        }
    }

    @Override
    @Trivial
    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < length; ++i) {
            if (this.chars == null) continue;
            this.chars.append(ch[start + i]);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String elementName) throws SAXException {
        if (elementName.equals("class-name")) {
            this.className = this.chars.toString().trim();
        } else if (elementName.equals("result-type")) {
            this.resultType = this.chars.toString().trim();
        } else if (elementName.equals("jsp-visitor-collection")) {
            this.visitorConfiguration.addJspVisitorCollection(this.visitorCollection);
            this.visitorCollection = null;
        } else if (elementName.equals("jsp-visitor-definition")) {
            try {
                Class<?> visitorClass = Class.forName(this.className, true, this.cl);
                Class<?> visitorResultClass = Class.forName(this.resultType, true, this.cl);
                this.visitorDefinition.setVisitorClass(visitorClass);
                this.visitorDefinition.setVisitorResultClass(visitorResultClass);
            }
            catch (ClassNotFoundException e) {
                String message = JspCoreException.getMsg("jsp.error.failed.load.jsp-visitor-definition");
                throw new SAXException(message, e);
            }
            this.visitorConfiguration.addJspVisitorDefinition(this.visitorDefinition);
            this.visitorDefinition = null;
            this.className = null;
            this.resultType = null;
        }
        this.chars = null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource isrc = null;
        String resourcePath = null;
        if (publicId.equals(DTD_PUBLIC_ID)) {
            resourcePath = DTD_RESOURCE_PATH;
        }
        if (resourcePath != null) {
            InputStream input = this.getClass().getResourceAsStream(resourcePath);
            if (input == null) {
                throw new SAXException(JspCoreException.getMsg("jsp.error.internal.dtd.not.found"));
            }
            isrc = new InputSource(input);
        }
        return isrc;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jsp.translator.visitor.configuration.VisitorConfigParser", VisitorConfigParser.class, null, null);
    }
}

