/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.taglib;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.configuration.JspConfigurationManager;
import com.ibm.ws.jsp.taglib.GlobalTagLibraryCache;
import com.ibm.ws.jsp.taglib.TagLibraryInfoImpl;
import com.ibm.ws.jsp.taglib.TldParser;
import com.ibm.wsspi.jsp.resource.JspInputSource;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class TagLibraryInfoProxy {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.taglib.TagLibraryInfoProxy";
    private String jarName;
    private String tldPath;
    private TagLibraryInfoImpl tli;
    private GlobalTagLibraryCache globalTagLibraryCache;
    private boolean containsListenerDefs;
    private List eventListenerList;
    static final long serialVersionUID = -8323575570725109565L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TagLibraryInfoProxy(String jarName, String tldPath, boolean containsListenerDefs, GlobalTagLibraryCache globalTagLibraryCache) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{jarName, tldPath, containsListenerDefs, globalTagLibraryCache});
        }
        this.jarName = null;
        this.tldPath = null;
        this.tli = null;
        this.globalTagLibraryCache = null;
        this.containsListenerDefs = false;
        this.eventListenerList = null;
        this.jarName = jarName;
        this.tldPath = tldPath;
        this.globalTagLibraryCache = globalTagLibraryCache;
        this.containsListenerDefs = containsListenerDefs;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized TagLibraryInfoImpl getTagLibraryInfoImpl(String prefix) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getTagLibraryInfoImpl", new Object[]{prefix});
        }
        if (this.tli == null) {
            this.loadTld();
        }
        if (this.tli == null) {
            TagLibraryInfoImpl tagLibraryInfoImpl = this.tli;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                tagLibraryInfoImpl = tagLibraryInfoImpl;
                logger.exiting(CLASS_NAME, "getTagLibraryInfoImpl", (Object)tagLibraryInfoImpl);
            }
            return tagLibraryInfoImpl;
        }
        TagLibraryInfoImpl tagLibraryInfoImpl = this.tli.copy(prefix);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            tagLibraryInfoImpl = tagLibraryInfoImpl;
            logger.exiting(CLASS_NAME, "getTagLibraryInfoImpl", (Object)tagLibraryInfoImpl);
        }
        return tagLibraryInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean containsListenerDefs() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "containsListenerDefs", new Object[0]);
        }
        boolean bl = this.containsListenerDefs;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "containsListenerDefs", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public synchronized List getEventListenerList() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getEventListenerList", new Object[0]);
        }
        if (this.eventListenerList == null) {
            this.loadTld();
        }
        List list = this.eventListenerList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting(CLASS_NAME, "getEventListenerList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void loadTld() {
        block13: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "loadTld", new Object[0]);
            }
            URL jarUrl = this.globalTagLibraryCache.getClassLoader().getResource(this.jarName);
            if (jarUrl != null) {
                JspInputSource tldInputSource = null;
                try {
                    boolean JCDIEnabledForRuntime = false;
                    JspConfigurationManager configManager = new JspConfigurationManager(Collections.EMPTY_LIST, false, true, Collections.EMPTY_LIST, false);
                    TldParser tldParser = new TldParser(this.globalTagLibraryCache, configManager, false);
                    URL url = new URL("jar:" + jarUrl.toString() + "!/");
                    tldInputSource = this.globalTagLibraryCache.getJspInputSourceFactory().createJspInputSource(url, this.tldPath);
                    this.tli = tldParser.parseTLD(tldInputSource, this.jarName);
                    if (this.tli.getReliableURN() != null) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "loadTld", "Global jar tld in proxy loaded for {0}", this.tli.getReliableURN());
                        }
                        this.tli.setURI(this.tli.getReliableURN());
                        if (this.containsListenerDefs) {
                            this.eventListenerList = new ArrayList();
                            this.eventListenerList.addAll(tldParser.getEventListenerList());
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to find a uri tag in [" + tldInputSource.getAbsoluteURL() + "]");
                    }
                }
                catch (JspCoreException e) {
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.WARNING)) {
                        logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                    }
                }
                catch (IOException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.WARNING)) break block13;
                    logger.logp(Level.WARNING, CLASS_NAME, "loadTld", "jsp warning failed to load tld in jar. uri = [" + tldInputSource.getAbsoluteURL() + "]", e);
                }
            }
        }
        if (this.eventListenerList == null) {
            this.eventListenerList = Collections.EMPTY_LIST;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "loadTld");
        }
    }
}

