/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class NoDeleteSynchronizedMap<K, V>
implements Map<K, V> {
    private final Map<K, V> global = Collections.synchronizedMap(new HashMap());
    private final ThreadLocal<Map<K, V>> threadLocal = new ThreadLocal<Map<K, V>>(){

        @Override
        public Map<K, V> initialValue() {
            return new HashMap();
        }
    };

    @Override
    public boolean containsKey(Object key) {
        Map<Object, V> local = this.threadLocal.get();
        if (local.containsKey(key)) {
            return true;
        }
        if (this.global.containsKey(key)) {
            local.put(key, this.global.get(key));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object val) {
        return this.threadLocal.get().containsValue(val) || this.global.containsValue(val);
    }

    @Override
    public V get(Object key) {
        Map<Object, V> local = this.threadLocal.get();
        V val = local.get(key);
        if (val != null || local.containsKey(key)) {
            return val;
        }
        val = this.global.get(key);
        if (val != null) {
            local.put(key, val);
        }
        return val;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.global.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.global.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.global.entrySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V val) {
        Map<K, V> map = this.global;
        synchronized (map) {
            if (this.global.containsKey(key)) {
                throw new IllegalStateException("Cannot overwrite existing entry for " + key);
            }
            return this.global.put(key, val);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> other) {
        Map<K, V> map = this.global;
        synchronized (map) {
            HashMap<K, V> intersection = new HashMap<K, V>(other);
            intersection.keySet().retainAll(this.global.keySet());
            switch (intersection.size()) {
                case 0: {
                    this.global.putAll(other);
                    return;
                }
                case 1: {
                    throw new IllegalStateException("Cannot overwrite existing entry for " + intersection.keySet().iterator().next());
                }
            }
            throw new IllegalStateException("Cannot overwrite existing entries: " + intersection.keySet());
        }
    }

    @Override
    public int size() {
        return this.global.size();
    }

    @Override
    public boolean isEmpty() {
        return this.global.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.global.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other == null || other.equals(this.global);
    }
}

