/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.yoko.rmi.impl.CopyRecursionException;
import org.apache.yoko.rmi.impl.CopyRecursionResolver;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.FieldDescriptor;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.yasf.Yasf;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;

class ValueFieldDescriptor
extends FieldDescriptor {
    ValueFieldDescriptor(Class owner, Class type, String name, Field f, TypeRepository repository) {
        super(owner, type, name, f, repository);
    }

    @Override
    public void read(ObjectReader reader, Object obj) throws IOException {
        try {
            if (Yasf.NON_SERIALIZABLE_FIELD_IS_ABSTRACT_VALUE.isSupported() || this.type.isInterface() || Serializable.class.isAssignableFrom(this.type)) {
                this.field.set(obj, reader.readValueObject(this.getType()));
            } else {
                this.field.set(obj, reader.readAbstractObject());
            }
        }
        catch (IllegalAccessException ex) {
            throw (MARSHAL)new MARSHAL(ex.getMessage()).initCause((Throwable)ex);
        }
    }

    @Override
    public void write(ObjectWriter writer, Object obj) throws IOException {
        block6: {
            try {
                if (Yasf.NON_SERIALIZABLE_FIELD_IS_ABSTRACT_VALUE.isSupported() || this.type.isInterface() || Serializable.class.isAssignableFrom(this.type)) {
                    try {
                        writer.writeValueObject(this.field.get(obj));
                        break block6;
                    }
                    catch (SystemException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw (MARSHAL)Exceptions.as(MARSHAL::new, (Throwable)e, (Object)("Object of class " + obj.getClass().getName() + " is not a valuetype"));
                    }
                }
                writer.writeObject(this.field.get(obj));
            }
            catch (IllegalAccessException ex) {
                throw (IOException)new IOException(ex.getMessage()).initCause(ex);
            }
        }
    }

    @Override
    void copyState(Object orig, final Object copy, CopyState state) {
        try {
            this.field.set(copy, state.copy(this.field.get(orig)));
        }
        catch (CopyRecursionException e) {
            state.registerRecursion(new CopyRecursionResolver(orig){

                @Override
                public void resolve(Object value) {
                    try {
                        ValueFieldDescriptor.this.field.set(copy, value);
                    }
                    catch (IllegalAccessException ex) {
                        throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
                    }
                }
            });
        }
        catch (IllegalAccessException ex) {
            throw (InternalError)new InternalError(ex.getMessage()).initCause(ex);
        }
    }

    @Override
    void readFieldIntoMap(ObjectReader reader, Map map) throws IOException {
        Serializable value = (Serializable)reader.readValueObject();
        map.put(this.java_name, value);
    }

    @Override
    void writeFieldFromMap(ObjectWriter writer, Map map) throws IOException {
        Serializable value = (Serializable)map.get(this.java_name);
        writer.writeValueObject(value);
    }
}

