/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.rmi.CORBA.Tie;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIState;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.UtilImpl;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.ResponseHandler;
import org.omg.CORBA.portable.UnknownException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public class RMIServant
extends Servant
implements Tie,
InvocationHandler {
    RMIState _state;
    RemoteDescriptor _descriptor;
    byte[] _id;
    private InvokeHandler proxyInvokeHandler;
    private Remote _target = null;
    private static final Method INVOKE_HANDLER_METHOD = InvokeHandler.class.getMethods()[0];

    Class getJavaClass() {
        return this._descriptor.type;
    }

    RMIState getRMIState() {
        return this._state;
    }

    public RMIServant(RMIState state) {
        this._state = state;
    }

    public String[] _all_interfaces(POA poa, byte[] objectId) {
        return this._descriptor.all_interfaces();
    }

    static String debug_name(Method m) {
        return m.getDeclaringClass().getName() + "." + m.getName();
    }

    public OutputStream _invoke(String opName, InputStream _input, ResponseHandler response) throws SystemException {
        return this.proxyInvokeHandler._invoke(opName, _input, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OutputStream _invoke0(String opName, InputStream _input, ResponseHandler response) throws SystemException {
        MethodDescriptor method = this._descriptor.getMethod(opName);
        if (method == null) {
            this._descriptor.debugMethodMap();
            throw new BAD_OPERATION(opName);
        }
        Method m = method.getReflectedMethod();
        if (VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINEST)) {
            VerboseLogging.REQ_IN_LOG.finest(RMIServant.debug_name(m) + ": invoking on " + this._id);
        }
        try {
            java.lang.Object[] args = method.readArguments(_input);
            java.lang.Object result = this.invoke_method(m, args);
            OutputStream _out = response.createReply();
            method.writeResult(_out, result);
            if (!VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINEST)) return _out;
            VerboseLogging.REQ_IN_LOG.finest(RMIServant.debug_name(m) + ": returning normally");
            return _out;
        }
        catch (SystemException ex) {
            VerboseLogging.REQ_IN_LOG.throwing(RMIServant.class.getName(), "_invoke", ex);
            VerboseLogging.REQ_IN_LOG.warning(ex.getMessage());
            throw ex;
        }
        catch (UndeclaredThrowableException ex) {
            VerboseLogging.REQ_IN_LOG.throwing(RMIServant.class.getName(), "_invoke", ex.getUndeclaredThrowable());
            throw new UnknownException(ex.getUndeclaredThrowable());
        }
        catch (RuntimeException ex) {
            if (!VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINER)) return method.writeException(response, ex);
            VerboseLogging.REQ_IN_LOG.log(Level.FINER, RMIServant.debug_name(m) + ": RuntimeException " + ex.getMessage(), ex);
            return method.writeException(response, ex);
        }
        catch (RemoteException ex) {
            if (!VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINER)) throw UtilImpl.mapRemoteException(ex);
            VerboseLogging.REQ_IN_LOG.log(Level.FINER, RMIServant.debug_name(m) + ": RemoteException " + ex.getMessage(), ex);
            throw UtilImpl.mapRemoteException(ex);
        }
        catch (Throwable ex) {
            if (!VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINER)) return method.writeException(response, ex);
            VerboseLogging.REQ_IN_LOG.log(Level.FINER, RMIServant.debug_name(m) + ": Throwable " + ex.getMessage(), ex);
            return method.writeException(response, ex);
        }
    }

    java.lang.Object invoke_method(Method m, java.lang.Object[] args) throws Throwable {
        if (this._target != null) {
            try {
                if (VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINE)) {
                    VerboseLogging.REQ_IN_LOG.fine("invoking method " + m + " on target " + this._target);
                }
                if (VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINER)) {
                    VerboseLogging.REQ_IN_LOG.finer(" with args: " + Arrays.asList(args));
                }
                if (VerboseLogging.REQ_IN_LOG.isLoggable(Level.FINEST)) {
                    VerboseLogging.REQ_IN_LOG.finest(" of arg types: " + Stream.of(args).map(o -> o == null ? null : o.getClass()).collect(Collectors.toList()));
                }
                return m.invoke((java.lang.Object)this._target, args);
            }
            catch (InvocationTargetException ex) {
                VerboseLogging.REQ_IN_LOG.log(Level.FINER, "Error invoking local method", ex.getCause());
                throw ex.getTargetException();
            }
        }
        throw new OBJECT_NOT_EXIST();
    }

    public ORB orb() {
        return this._orb();
    }

    public void orb(ORB orb) {
        try {
            POA _poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
            _poa.activate_object((Servant)this);
        }
        catch (InvalidName ex) {
            throw new RuntimeException("ORB must have POA support", ex);
        }
        catch (WrongPolicy ex) {
            throw new RuntimeException("wrong policy: " + ex.getMessage(), ex);
        }
        catch (ServantAlreadyActive ex) {
            throw new RuntimeException("already active: " + ex.getMessage(), ex);
        }
    }

    public void deactivate() {
        if (this._get_delegate() == null) {
            throw new RuntimeException("object not active");
        }
        try {
            POA poa = this._state.getPOA();
            byte[] id = poa.servant_to_id((Servant)this);
            poa.deactivate_object(id);
            this._set_delegate(null);
        }
        catch (Throwable ex) {
            VerboseLogging.REQ_IN_LOG.throwing("", "deactivate", ex);
            throw new RuntimeException("cannot deactivate: " + ex.getMessage(), ex);
        }
    }

    public Remote getTarget() {
        return this._target;
    }

    public synchronized void setTarget(Remote target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this._descriptor = this._state.repo.getRemoteInterface(target.getClass()).getRemoteInterface();
        if (this._descriptor == null) {
            throw new RuntimeException("remote classes not supported");
        }
        this._target = target;
        ClassLoader targetLoader = (ClassLoader)AccessController.doPrivileged(PrivilegedActions.getClassLoader(this._target.getClass()));
        this.proxyInvokeHandler = targetLoader != null && targetLoader != AccessController.doPrivileged(PrivilegedActions.getClassLoader(this.getClass())) ? (InvokeHandler)Proxy.newProxyInstance(targetLoader, new Class[]{InvokeHandler.class}, (InvocationHandler)this) : this::_invoke0;
    }

    Delegate getDelegate() {
        return this._state.createDelegate(this);
    }

    public Object thisObject() {
        return this._this_object();
    }

    @Override
    public java.lang.Object invoke(java.lang.Object proxy, Method method, java.lang.Object[] args) throws Throwable {
        assert (INVOKE_HANDLER_METHOD.equals(method));
        return this._invoke0((String)args[0], (InputStream)args[1], (ResponseHandler)args[2]);
    }
}

