/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.util.cmsf.CmsfThreadLocal;

abstract class ObjectWriter
extends ObjectOutputStream {
    protected final Serializable object;
    private ValueDescriptor _desc;
    private PutFieldImpl _putFields;
    private WriteObjectState state = WriteObjectState.NOT_IN_WRITE_OBJECT;
    final byte cmsf;

    protected void beforeWriteData() throws IOException {
        this.state.beforeWriteData(this);
    }

    ObjectWriter(Serializable obj) throws IOException {
        this.object = obj;
        this.cmsf = CmsfThreadLocal.get();
    }

    abstract ObjectReader getObjectReader(Object var1);

    private void setCurrentValueDescriptor(ValueDescriptor desc) {
        this._desc = desc;
        this._putFields = null;
    }

    @Override
    public final void defaultWriteObject() throws IOException {
        if (this._desc == null) {
            throw new NotActiveException();
        }
        this.state.beforeDefaultWriteObject(this);
        try {
            this._desc.defaultWriteValue(this, this.object);
        }
        finally {
            this.state.afterDefaultWriteObject(this);
        }
    }

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this._desc == null) {
            throw new NotActiveException();
        }
        this._putFields = new PutFieldImpl(this._desc);
        return this._putFields;
    }

    @Override
    public void writeFields() throws IOException {
        if (this._putFields == null) {
            throw new NotActiveException("no current PutFields");
        }
        if (this._putFields.slice != this._desc) {
            throw new NotActiveException("PutField cannot survive writeObject invocation");
        }
        this.state.beforeDefaultWriteObject(this);
        try {
            this._putFields.write(this);
        }
        finally {
            this.state.afterDefaultWriteObject(this);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public abstract void writeValueObject(Object var1) throws IOException;

    public abstract void writeRemoteObject(Object var1) throws IOException;

    public abstract void writeCorbaObject(Object var1) throws IOException;

    public abstract void writeAny(Object var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeWriteObject(ValueDescriptor descriptor, Serializable val, Method _write_object_method) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, IOException {
        ValueDescriptor desc = this._desc;
        WriteObjectState old_state = this.state;
        this.state = WriteObjectState.NOT_IN_WRITE_OBJECT;
        try {
            this.setCurrentValueDescriptor(descriptor);
            this.writeByte(this.cmsf);
            this.state.beforeWriteObject(this);
            _write_object_method.invoke((Object)val, this);
            this.state.afterWriteObject(this);
        }
        finally {
            this.state = old_state;
            this.setCurrentValueDescriptor(desc);
        }
    }

    protected abstract void _startValue(String var1) throws IOException;

    protected abstract void _endValue() throws IOException;

    protected abstract void _nullValue() throws IOException;

    void invokeWriteExternal(Externalizable externalizable) throws IOException {
        this.writeByte(this.cmsf);
        externalizable.writeExternal(this);
    }

    private static enum WriteObjectState {
        NOT_IN_WRITE_OBJECT{

            @Override
            void beforeWriteObject(ObjectWriter writer) {
                writer.state = 1.IN_WRITE_OBJECT;
            }
        }
        ,
        IN_WRITE_OBJECT{

            @Override
            void afterWriteObject(ObjectWriter writer) throws IOException {
                writer.state = 2.NOT_IN_WRITE_OBJECT;
                writer.writeBoolean(false);
                if (writer.cmsf == 2) {
                    writer._nullValue();
                }
            }

            @Override
            void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
                writer.state = 2.IN_DEFAULT_WRITE_OBJECT;
                writer.writeBoolean(true);
            }

            @Override
            void beforeWriteData(ObjectWriter writer) throws IOException {
                writer.state = 2.WROTE_CUSTOM_DATA;
                writer.writeBoolean(false);
                if (writer.cmsf == 2) {
                    writer._startValue(writer._desc.getCustomRepositoryID());
                }
            }
        }
        ,
        IN_DEFAULT_WRITE_OBJECT{

            @Override
            void afterDefaultWriteObject(ObjectWriter writer) {
                writer.state = 3.WROTE_DEFAULT_DATA;
            }
        }
        ,
        WROTE_DEFAULT_DATA{

            @Override
            void afterWriteObject(ObjectWriter writer) throws IOException {
                writer.state = 4.NOT_IN_WRITE_OBJECT;
                if (writer.cmsf == 2) {
                    writer._nullValue();
                }
            }

            @Override
            void beforeWriteData(ObjectWriter writer) throws IOException {
                writer.state = 4.WROTE_CUSTOM_DATA;
                if (writer.cmsf == 2) {
                    writer._startValue(writer._desc.getCustomRepositoryID());
                }
            }
        }
        ,
        WROTE_CUSTOM_DATA{

            @Override
            void afterWriteObject(ObjectWriter writer) throws IOException {
                if (writer.cmsf == 2) {
                    writer._endValue();
                }
                writer.state = 5.NOT_IN_WRITE_OBJECT;
            }
        };


        void beforeWriteObject(ObjectWriter writer) {
            throw new IllegalStateException();
        }

        void afterWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException();
        }

        void beforeDefaultWriteObject(ObjectWriter writer) throws IOException {
            throw new IllegalStateException();
        }

        void afterDefaultWriteObject(ObjectWriter writer) {
            throw new IllegalStateException();
        }

        void beforeWriteData(ObjectWriter writer) throws IOException {
        }
    }

    static class PutFieldImpl
    extends ObjectOutputStream.PutField {
        final ValueDescriptor slice;
        final Map<String, Object> valueMap = new HashMap<String, Object>();

        PutFieldImpl(ValueDescriptor slice) {
            this.slice = slice;
        }

        @Override
        public void put(String name, boolean val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, byte val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, char val) {
            this.valueMap.put(name, Character.valueOf(val));
        }

        @Override
        public void put(String name, double val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, float val) {
            this.valueMap.put(name, Float.valueOf(val));
        }

        @Override
        public void put(String name, int val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, long val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, Object val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void put(String name, short val) {
            this.valueMap.put(name, val);
        }

        @Override
        public void write(ObjectOutput out) throws IOException {
            this.slice.writeFields((ObjectWriter)out, this.valueMap);
        }
    }
}

