/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.security.SecurityRoles;
import com.ibm.ws.javaee.dd.appbnd.SecurityRole;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class SecurityRolesImpl
implements SecurityRoles {
    private static final TraceComponent tc = Tr.register(SecurityRolesImpl.class, (String)"Security", null);
    private List<SecurityRole> securityRolesList = null;
    static final long serialVersionUID = -285394430468270370L;

    public SecurityRolesImpl(List<SecurityRole> allSecurityRoles) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The security roles from the application bind file and server.xml are: " + allSecurityRoles), (Object[])new Object[0]);
        }
        HashMap<String, SecurityRole> mergedRoles = new HashMap<String, SecurityRole>();
        for (SecurityRole role : allSecurityRoles) {
            SecurityRole previous = mergedRoles.put(role.getName(), role);
            if (previous == null || !TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Overriding security role with name " + previous.getName() + "old: " + previous + "new: " + role), (Object[])new Object[0]);
        }
        this.securityRolesList = new ArrayList(mergedRoles.values());
    }

    @Override
    public List<SecurityRole> getSecurityRoles() {
        return this.securityRolesList;
    }
}

