/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.container.service.annocache.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.annocache.ModuleAnnotations;
import com.ibm.ws.container.service.annocache.internal.AnnotationsAdapterImpl;
import com.ibm.ws.container.service.annocache.internal.AnnotationsImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoForContainer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.annocache.classsource.ClassSource_Factory;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleAnnotationsImpl
extends AnnotationsImpl
implements ModuleAnnotations {
    private static final String CLASS_NAME;
    protected final ModuleInfo moduleInfo;
    private final ApplicationInfo appInfo;
    private boolean isSetAppCache;
    private NonPersistentCache appCache;
    private Set<EnterpriseApplicationLibraryType> appScanOptions;
    public static final String ALL_LIBS_KEYWORD = "all";
    public static final String EAR_LIB_KEYWORD = "earLibraries";
    public static final String MANIFEST_KEYWORD = "manifestClassPath";
    static final long serialVersionUID = 7967524631301041426L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static String getAppName(ModuleInfo moduleInfo) {
        String methodName = "getAppName";
        ApplicationInfo appInfo = moduleInfo.getApplicationInfo();
        String appName = appInfo.getName();
        String appDepName = appInfo.getDeploymentName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(methodName + ": AppName [ " + appName + " ] AppDepName [ " + appDepName + " ] (using AppDepName)"), (Object[])new Object[0]);
        }
        return appDepName;
    }

    public ModuleAnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootArtifactContainer, Container rootAdaptableContainer, ModuleInfo moduleInfo) throws UnableToAdaptException {
        this(annotationsAdapter, rootContainer, rootOverlayContainer, rootArtifactContainer, rootAdaptableContainer, moduleInfo, ClassSource_Factory.UNSET_CATEGORY_NAME);
    }

    public ModuleAnnotationsImpl(AnnotationsAdapterImpl annotationsAdapter, Container rootContainer, OverlayContainer rootOverlayContainer, ArtifactContainer rootArtifactContainer, Container rootAdaptableContainer, ModuleInfo moduleInfo, String modCatName) throws UnableToAdaptException {
        super(annotationsAdapter, rootContainer, rootOverlayContainer, rootArtifactContainer, rootAdaptableContainer, ModuleAnnotationsImpl.getAppName(moduleInfo), false, moduleInfo.getName(), modCatName);
        this.moduleInfo = moduleInfo;
        this.classLoader = moduleInfo.getClassLoader();
        this.appInfo = moduleInfo.getApplicationInfo();
    }

    @Override
    public ModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    @Override
    @Deprecated
    public void addAppClassLoader(ClassLoader appClassLoader) {
        this.setClassLoader(appClassLoader);
    }

    @Override
    public ApplicationInfo getAppInfo() {
        return this.appInfo;
    }

    @Override
    public Container getAppContainer() {
        return this.getAppInfo().getContainer();
    }

    protected NonPersistentCache getAppCache() {
        if (!this.isSetAppCache) {
            NonPersistentCache useAppCache;
            try {
                useAppCache = (NonPersistentCache)this.getAppContainer().adapt(NonPersistentCache.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.ModuleAnnotationsImpl", (String)"242", (Object)this, (Object[])new Object[0]);
                useAppCache = null;
            }
            this.appCache = useAppCache;
            this.isSetAppCache = true;
        }
        return this.appCache;
    }

    protected <T> T appCacheGet(Class<T> targetClass) {
        return (T)this.getAppCache().getFromCache(targetClass);
    }

    protected Set<EnterpriseApplicationLibraryType> getAppScanOptions() {
        if (this.appScanOptions == null) {
            this.appScanOptions = this.computeAppScanOptions();
        }
        return this.appScanOptions;
    }

    private Set<EnterpriseApplicationLibraryType> computeAppScanOptions() {
        ApplicationInfoForContainer appInformation = this.appCacheGet(ApplicationInfoForContainer.class);
        if (appInformation == null) {
            return Collections.emptySet();
        }
        HashSet<EnterpriseApplicationLibraryType> libraryTypes = new HashSet<EnterpriseApplicationLibraryType>(3);
        String rawLibraryTypes = appInformation.getAnnotationScanLibrary();
        for (String rawLibraryType : rawLibraryTypes.split(",")) {
            if ((rawLibraryType = rawLibraryType.trim().toLowerCase()).equals(ALL_LIBS_KEYWORD.toLowerCase())) {
                libraryTypes.add(EnterpriseApplicationLibraryType.EAR_LIB);
                libraryTypes.add(EnterpriseApplicationLibraryType.MANIFEST_LIB);
                break;
            }
            if (rawLibraryType.equals(EnterpriseApplicationLibraryType.EAR_LIB.getKeyWord().toLowerCase())) {
                libraryTypes.add(EnterpriseApplicationLibraryType.EAR_LIB);
                continue;
            }
            if (!rawLibraryType.equals(EnterpriseApplicationLibraryType.MANIFEST_LIB.getKeyWord().toLowerCase())) continue;
            libraryTypes.add(EnterpriseApplicationLibraryType.MANIFEST_LIB);
        }
        return libraryTypes;
    }

    protected ApplicationClassesContainerInfo getAppClassesContainerInfo() {
        return this.appCacheGet(ApplicationClassesContainerInfo.class);
    }

    @Override
    public boolean getUseJandex() {
        return this.getAppInfo().getUseJandex();
    }

    private ModuleClassesContainerInfo getModuleClassesContainerInfo() {
        NonPersistentCache cache;
        Container container = this.getContainer();
        try {
            cache = (NonPersistentCache)this.getAppContainer().adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.container.service.annocache.internal.ModuleAnnotationsImpl", (String)"343", (Object)this, (Object[])new Object[0]);
            return null;
        }
        ApplicationClassesContainerInfo appClassesInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
        for (ModuleClassesContainerInfo moduleClassesInfo : appClassesInfo.getModuleClassesContainerInfo()) {
            for (ContainerInfo containerInfo : moduleClassesInfo.getClassesContainerInfo()) {
                if (containerInfo.getType() == ContainerInfo.Type.MANIFEST_CLASSPATH || !containerInfo.getContainer().equals(container)) continue;
                return moduleClassesInfo;
            }
        }
        return null;
    }

    @Override
    protected void addInternalToClassSource() {
        if (this.rootClassSource == null) {
            return;
        }
        ClassSource_Factory classSourceFactory = this.getClassSourceFactory();
        if (classSourceFactory == null) {
            return;
        }
        Container moduleContainer = this.getContainer();
        Tr.debug((TraceComponent)tc, (String)(CLASS_NAME + ": Module [ " + this.getAppName() + ":" + this.getModName() + " ][ " + moduleContainer + " ]: Building internal class sources"), (Object[])new Object[0]);
        ModuleClassesContainerInfo moduleClassesContainerInfo = this.getModuleClassesContainerInfo();
        if (moduleClassesContainerInfo == null) {
            String containerPath = this.getContainerPath(moduleContainer);
            if (containerPath == null) {
                return;
            }
            if (!this.addContainerClassSource(containerPath, moduleContainer)) {
                return;
            }
        } else {
            for (ContainerInfo nextInfo : moduleClassesContainerInfo.getClassesContainerInfo()) {
                String nextPrefix;
                Container nextContainer = nextInfo.getContainer();
                ContainerInfo.Type nextType = nextInfo.getType();
                if (nextType == ContainerInfo.Type.MANIFEST_CLASSPATH || nextType == ContainerInfo.Type.EAR_LIB || nextType == ContainerInfo.Type.SHARED_LIB) {
                    Tr.debug((TraceComponent)tc, (String)("Ignoring container [ " + nextContainer + " ] [ " + (Object)((Object)nextType) + " ]"), (Object[])new Object[0]);
                    continue;
                }
                if (nextType == ContainerInfo.Type.WEB_MODULE) {
                    Tr.warning((TraceComponent)tc, (String)("Ignoring container [ " + nextContainer + " ] [ " + (Object)((Object)nextType) + " ]: Web modules should use WEB_INF_CLASSES"), (Object[])new Object[0]);
                    continue;
                }
                if (nextType == ContainerInfo.Type.WEB_INF_CLASSES) {
                    nextContainer = nextContainer.getEnclosingContainer().getEnclosingContainer();
                    nextPrefix = "WEB-INF/classes/";
                    Tr.debug((TraceComponent)tc, (String)(CLASS_NAME + ": Handling type [ " + (Object)((Object)nextType) + " ] with prefix [ " + nextPrefix + " ]"), (Object[])new Object[0]);
                } else if (nextType == ContainerInfo.Type.WEB_INF_LIB || nextType == ContainerInfo.Type.EJB_MODULE || nextType == ContainerInfo.Type.CLIENT_MODULE || nextType == ContainerInfo.Type.RAR_MODULE || nextType == ContainerInfo.Type.JAR_MODULE) {
                    nextPrefix = ClassSource_Factory.UNUSED_ENTRY_PREFIX;
                    Tr.debug((TraceComponent)tc, (String)(CLASS_NAME + ": Handling type [ " + (Object)((Object)nextType) + " ]"), (Object[])new Object[0]);
                } else {
                    Tr.warning((TraceComponent)tc, (String)("Ignoring container [ " + nextContainer + " ] [ " + (Object)((Object)nextType) + " ]: unknown type"), (Object[])new Object[0]);
                    return;
                }
                String nextPath = this.getContainerPath(nextContainer);
                if (nextPath == null) {
                    return;
                }
                if (this.addContainerClassSource(nextPath, nextContainer, nextPrefix)) continue;
                return;
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.container.service.annocache.internal.ModuleAnnotationsImpl", ModuleAnnotationsImpl.class, (String)"container.service", (String)"com.ibm.ws.container.service.resources.Messages");
        CLASS_NAME = ModuleAnnotationsImpl.class.getSimpleName();
    }

    public static enum EnterpriseApplicationLibraryType {
        EAR_LIB("earLibraries"),
        MANIFEST_LIB("manifestClassPath");

        private final String keyWord;

        private EnterpriseApplicationLibraryType(String keyWord) {
            this.keyWord = keyWord;
        }

        public String getKeyWord() {
            return this.keyWord;
        }
    }
}

