/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.util.WIMSortCompare;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.SortControl;
import com.ibm.wsspi.security.wim.model.SortKeyType;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SortHandler {
    private SortControl sortControl = null;
    static final long serialVersionUID = -4762384732041344874L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public SortHandler() {
    }

    @Trivial
    public SortHandler(SortControl sortControl) {
        this.sortControl = sortControl;
    }

    public int compareEntitysWithRespectToProperties(Entity entity1, Entity entity2) {
        List sortKeys = this.sortControl.getSortKeys();
        int temp = 0;
        for (int i = 0; i < sortKeys.size() && temp == 0; ++i) {
            SortKeyType sortKey = (SortKeyType)sortKeys.get(i);
            String propName = sortKey.getPropertyName();
            boolean ascendingSorting = sortKey.isAscendingOrder();
            Object propValue1 = this.getPropertyValue(entity1, propName, ascendingSorting);
            Object propValue2 = this.getPropertyValue(entity2, propName, ascendingSorting);
            temp = this.compareProperties(propValue1, propValue2);
            if (ascendingSorting) continue;
            temp = 0 - temp;
        }
        return temp;
    }

    @Trivial
    public void setSortControl(SortControl sortControl) {
        this.sortControl = sortControl;
    }

    @Trivial
    public SortControl getSortControl() {
        return this.sortControl;
    }

    public List<Entity> sortEntities(List<Entity> entities) {
        if (entities != null && entities.size() > 0) {
            Entity[] ents = entities.toArray(new Entity[entities.size()]);
            WIMSortCompare wimSortComparator = new WIMSortCompare(this.sortControl);
            Arrays.sort(ents, wimSortComparator);
            entities.clear();
            for (int i = 0; i < ents.length; ++i) {
                entities.add(ents[i]);
            }
        }
        return entities;
    }

    private Object getPropertyValue(Entity entity, String propName, boolean ascending) {
        List props;
        Object value = null;
        Object propValue = null;
        try {
            propValue = entity.get(propName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.security.wim.util.SortHandler", (String)"123", (Object)this, (Object[])new Object[]{entity, propName, ascending});
            value = null;
        }
        if (propValue != null && !(propValue instanceof List)) {
            value = propValue;
        } else if (propValue != null && (props = (List)propValue).size() > 0) {
            value = props.get(0);
            for (int i = 1; i < props.size(); ++i) {
                int temp = this.compareProperties(value, props.get(i));
                if (temp <= 0 || !ascending) continue;
                value = props.get(i);
            }
        }
        return value;
    }

    private int compareProperties(Object prop1, Object prop2) {
        Collator localeCollator = null;
        int returnCode = 0;
        if (this.sortControl != null) {
            String localeStr = this.sortControl.getLocale();
            Locale locale = Locale.getDefault();
            if (localeStr != null) {
                int index = localeStr.indexOf("-");
                if (index != -1) {
                    String lang = localeStr.substring(0, index);
                    String country = localeStr.substring(index + 1);
                    locale = new Locale(lang, country);
                } else {
                    locale = new Locale(localeStr);
                }
            }
            if (locale != null) {
                localeCollator = Collator.getInstance(locale);
                localeCollator.setStrength(3);
            }
            returnCode = prop1 == null && prop2 == null ? 0 : (prop1 == null ? -1 : (prop2 == null ? 1 : (prop1 instanceof String ? localeCollator.compare(prop1, prop2) : (prop1 instanceof Integer ? ((Integer)prop1).compareTo((Integer)prop2) : (prop1 instanceof Long ? ((Long)prop1).compareTo((Long)prop2) : (prop1 instanceof Double ? ((Double)prop1).compareTo((Double)prop2) : localeCollator.compare(prop1.toString(), prop2.toString())))))));
        }
        return returnCode;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.wim.util.SortHandler", SortHandler.class, (String)"wimUtil", (String)"com.ibm.ws.security.wim.util.resources.WimUtilMessages");
    }
}

