/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.hpel.impl;

import com.ibm.ejs.ras.hpel.HpelHelper;
import com.ibm.websphere.logging.hpel.writer.LogEventNotifier;
import com.ibm.ws.logging.hpel.LogRecordSerializer;
import com.ibm.ws.logging.hpel.LogRepositoryBase;
import com.ibm.ws.logging.hpel.impl.AccessHelper;
import com.ibm.ws.logging.hpel.impl.BinaryLogRecordSerializerImpl;
import com.ibm.ws.logging.hpel.impl.BinaryLogRecordSerializerVersion2Impl;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public abstract class LogRepositoryBaseImpl
implements LogRepositoryBase {
    public static final LogRecordSerializer[] KNOWN_FORMATTERS = new LogRecordSerializer[]{new BinaryLogRecordSerializerVersion2Impl(), new BinaryLogRecordSerializerImpl()};
    public static final String DEFAULT_LOCATION = "logdata";
    public static final String TRACE_LOCATION = "tracedata";
    protected final File repositoryLocation;
    protected String managedType;
    protected LogEventNotifier logEventNotifier;
    private static final String LOCK_EXT = ".lock";
    public static final String EXTENSION = ".wbl";
    public static final String TRACETYPE = "trace";
    public static final String LOGTYPE = "log";
    public static final String TEXTLOGTYPE = "textlog";
    protected final FileFilter filter = new LogRepositoryFilesFilter();
    private static String thisClass = LogRepositoryBaseImpl.class.getName();
    private static final int ONE_MEG = 0x100000;
    private static Logger debugLogger = Logger.getLogger("com.ibm.hpel.debug");
    private static final boolean debugAllowed = "true".equalsIgnoreCase(LogRepositoryBaseImpl.getSystemProperty("com.ibm.ws.logging.hpel.debug"));
    private static final int debugReposSz = Integer.getInteger("com.ibm.ws.logging.hpel.internaltracesize", 20) * 0x100000;
    private static final String debugLocation = LogRepositoryBaseImpl.getSystemProperty("com.ibm.ws.logging.hpel.internaltracelocation");
    private static Boolean debugEnabled = null;
    protected static final FileFilter LOCKFILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return AccessHelper.isFile(pathname) && pathname.getName().endsWith(LogRepositoryBaseImpl.LOCK_EXT) && LogRepositoryBaseImpl.parseTimeStamp(pathname.getName()) >= 0L;
        }
    };
    protected final FileFilter instanceFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return LogRepositoryBaseImpl.this.isDirectory(pathname) && LogRepositoryBaseImpl.parseTimeStamp(pathname.getName()) > 0L;
        }
    };
    protected final FileFilter subprocFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return LogRepositoryBaseImpl.this.isDirectory(pathname) && LogRepositoryBaseImpl.parseTimeStamp(pathname.getName()) < 0L;
        }
    };
    protected final FileFilter dirFilter = new LogRepositoryDirFilter();
    protected final Comparator<File> fileComparator = new LogRepositoryFilesComparator();
    public static final char TIMESEPARATOR = '_';
    public static final char LABELSEPARATOR = '-';

    protected LogRepositoryBaseImpl(File repositoryLocation) {
        if (repositoryLocation == null) {
            throw new IllegalArgumentException("Specified repository location can't be null.");
        }
        this.repositoryLocation = repositoryLocation;
    }

    private static String getSystemProperty(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    public File getLocation() {
        return this.repositoryLocation;
    }

    protected void createLockFile(String pid, String label) throws IOException {
        if (!AccessHelper.isDirectory(this.repositoryLocation)) {
            AccessHelper.makeDirectories(this.repositoryLocation);
        }
        for (File lock : this.listFiles(LOCKFILE_FILTER)) {
            AccessHelper.deleteFile(lock);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLogDirectoryName(System.currentTimeMillis(), pid, label)).append(LOCK_EXT);
        AccessHelper.createFileOutputStream(new File(this.repositoryLocation, sb.toString()), false).close();
    }

    private File[] listFiles(final FileFilter lockfileFilter) {
        return AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return LogRepositoryBaseImpl.this.repositoryLocation.listFiles(lockfileFilter);
            }
        });
    }

    protected File makeLogDirectory(long timestamp, String pid, boolean flag) {
        File instanceDir = null;
        long maxTimestamp = -1L;
        for (File dir : AccessHelper.listFiles(this.repositoryLocation, new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return AccessHelper.isDirectory(pathname);
            }
        })) {
            long dirTimestamp = LogRepositoryBaseImpl.parseTimeStamp(dir.getName());
            if (maxTimestamp >= dirTimestamp) continue;
            instanceDir = dir;
            maxTimestamp = dirTimestamp;
        }
        if (maxTimestamp >= 0L && pid.equals(LogRepositoryBaseImpl.parseProcessID(instanceDir.getName()))) {
            return instanceDir;
        }
        if (flag) {
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "makingLogDirectory", "no lock files found , creating folder with XXXXXX label");
            }
            instanceDir = new File(this.repositoryLocation, this.getLogDirectoryName(timestamp, pid, "XXXXXXX"));
            AccessHelper.makeDirectories(instanceDir);
            return instanceDir;
        }
        File[] lockFiles = AccessHelper.listFiles(this.repositoryLocation, LOCKFILE_FILTER);
        if (lockFiles.length != 1 || !pid.equals(LogRepositoryBaseImpl.parseProcessID(lockFiles[0].getName()))) {
            if (lockFiles.length < 1) {
                if (LogRepositoryBaseImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "makingLogDirectory", "no lock files found.");
                }
            } else if (lockFiles.length > 1) {
                StringBuilder sb = new StringBuilder();
                for (File lock : lockFiles) {
                    sb.append(lock.getName()).append(" ");
                }
                if (LogRepositoryBaseImpl.isDebugEnabled()) {
                    debugLogger.logp(Level.FINE, thisClass, "makeLogDirectory", "too many lock files found: " + sb.toString());
                }
            } else if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "makeLogDirectory", "found stale lock file " + lockFiles[0].getName() + " but was expecting one generated by process " + pid);
            }
            return null;
        }
        String lockname = lockFiles[0].getName();
        if (!AccessHelper.deleteFile(lockFiles[0])) {
            if (LogRepositoryBaseImpl.isDebugEnabled()) {
                debugLogger.logp(Level.FINE, thisClass, "makeLogDirectory", "failed to delete found lock file " + lockFiles[0].getName() + ". Assume it was deleted already");
            }
            return null;
        }
        String label = LogRepositoryBaseImpl.parseLabel(lockname.substring(0, lockname.length() - LOCK_EXT.length()));
        instanceDir = new File(this.repositoryLocation, this.getLogDirectoryName(timestamp, pid, label));
        AccessHelper.makeDirectories(instanceDir);
        return instanceDir;
    }

    protected File makeLogDirectory(long timestamp, String pid) {
        return this.makeLogDirectory(timestamp, pid, false);
    }

    protected File getLogFile(File parentLocation, long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp cannot be negative");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(timestamp).append(EXTENSION);
        return new File(parentLocation, sb.toString());
    }

    public long getLogFileTimestamp(File file) {
        if (file == null) {
            return -1L;
        }
        String name = file.getName();
        if (name == null || name.length() == 0 || !name.endsWith(EXTENSION)) {
            return -1L;
        }
        try {
            return Long.parseLong(name.substring(0, name.indexOf(EXTENSION)));
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    public String getLogDirectoryName(long timestamp, String pid, String label) {
        if (pid == null || pid.isEmpty()) {
            throw new IllegalArgumentException("pid cannot be empty");
        }
        StringBuilder sb = new StringBuilder();
        if (timestamp > 0L) {
            sb.append(timestamp).append('_');
        }
        sb.append(pid);
        if (label != null && !label.trim().isEmpty()) {
            sb.append('-').append(label);
        }
        return sb.toString();
    }

    protected File[] listRepositoryFiles() {
        File[] directories = this.listRepositoryDirs();
        ArrayList<File> allFilesArray = new ArrayList<File>();
        File[] allFiles = new File[allFilesArray.size()];
        for (int i = 0; i < directories.length; ++i) {
            File[] files = AccessHelper.listFiles(directories[i], this.filter);
            if (files != null && files.length > 0) {
                allFilesArray.addAll(Arrays.asList(files));
            }
            for (File curFile : files = AccessHelper.listFiles(directories[i], this.subprocFilter)) {
                File[] subFiles = AccessHelper.listFiles(curFile, this.filter);
                if (subFiles == null || subFiles.length <= 0) continue;
                allFilesArray.addAll(Arrays.asList(subFiles));
            }
        }
        if (!allFilesArray.isEmpty()) {
            allFiles = allFilesArray.toArray(allFiles);
        }
        return allFiles;
    }

    public static long parseTimeStamp(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return -1L;
        }
        int pidIndex = fileName.indexOf(95);
        int labelIndex = fileName.indexOf(45);
        if (pidIndex < 0 || labelIndex > 0 && labelIndex < pidIndex) {
            return -1L;
        }
        try {
            return Long.parseLong(fileName.substring(0, pidIndex));
        }
        catch (NumberFormatException ex) {
            return -1L;
        }
    }

    private boolean isDirectory(final File fileObject) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return fileObject.isDirectory();
            }
        });
    }

    private boolean isFile(final File fileObject) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return fileObject.isFile();
            }
        });
    }

    public boolean fileExists(final File fileObject) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return fileObject.exists();
            }
        });
    }

    public static String parseProcessID(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        int pidIndex = fileName.indexOf(95);
        int labelIndex = fileName.indexOf(45);
        if (pidIndex < 0 && labelIndex < 0) {
            return fileName;
        }
        if (labelIndex < 0) {
            return fileName.substring(pidIndex + 1);
        }
        if (pidIndex < 0 || labelIndex < pidIndex) {
            return fileName.substring(0, labelIndex);
        }
        return fileName.substring(pidIndex + 1, labelIndex);
    }

    public static String parseLabel(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        int labelIndex = fileName.indexOf(45);
        return labelIndex < 0 ? null : fileName.substring(labelIndex + 1);
    }

    public static String parsePIDandLabel(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        int pidIndex = fileName.indexOf(95);
        int labelIndex = fileName.indexOf(45);
        if (pidIndex < 0 || labelIndex > 0 && labelIndex < pidIndex) {
            return fileName;
        }
        return fileName.substring(pidIndex + 1);
    }

    protected File[] listRepositoryDirs() {
        return AccessHelper.listFiles(this.repositoryLocation, this.dirFilter);
    }

    public void setManagedType(String managedType) {
        this.managedType = managedType;
    }

    public String getManagedType() {
        return this.managedType;
    }

    public void setLogEventNotifier(LogEventNotifier logEventNotifier) {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "setLogEventNotifier", "LEN: " + logEventNotifier);
        }
        this.logEventNotifier = logEventNotifier;
    }

    public LogEventNotifier getLogEventNotifier() {
        if (LogRepositoryBaseImpl.isDebugEnabled()) {
            debugLogger.logp(Level.FINE, thisClass, "getLogEventNotifier", "getLEN: " + this.logEventNotifier);
        }
        return this.logEventNotifier;
    }

    public static boolean isDebugEnabled() {
        FileHandler fHandler;
        int debugFileSz;
        int numDebugFiles;
        if (debugEnabled != null) {
            return debugEnabled;
        }
        debugEnabled = false;
        if (!debugAllowed) {
            return false;
        }
        if (debugReposSz < 0x400000) {
            numDebugFiles = 2;
            debugFileSz = debugReposSz / 2;
        } else {
            numDebugFiles = 10;
            debugFileSz = debugReposSz / 10;
        }
        System.out.println("HPEL Debugging in use. Internal repository sz: " + debugReposSz + ". Num Files: " + numDebugFiles + " FileSz: " + debugFileSz + " Location (null means system temp directory): " + debugLocation);
        String pid = HpelHelper.getProcessId();
        int index = pid.indexOf("/");
        if (index > -1) {
            pid = pid.substring(0, index);
        }
        if (!pid.equals("")) {
            pid = pid + ".";
        }
        try {
            File thisLog;
            if (debugLocation == null) {
                thisLog = File.createTempFile("hpelDebugLogger." + pid, ".log");
            } else {
                File debugLoc = new File(debugLocation);
                AccessHelper.makeDirectories(debugLoc);
                thisLog = File.createTempFile("hpelDebugLogger." + pid, ".log", debugLoc);
            }
            fHandler = new FileHandler(thisLog.getPath(), debugFileSz, numDebugFiles);
        }
        catch (Exception e) {
            System.out.println("Exception creating fileHandler for separate LogRepositoryManager logging. Turning off special logging: " + e);
            debugLogger.setUseParentHandlers(false);
            return false;
        }
        fHandler.setFormatter(new SimpleFormatter());
        debugLogger.addHandler(fHandler);
        debugLogger.setUseParentHandlers(false);
        debugLogger.setLevel(Level.FINE);
        debugEnabled = true;
        return true;
    }

    public static Logger getLogger() {
        return debugLogger;
    }

    public void notifyOfFileAction(String eventType) {
    }

    private class LogRepositoryFilesFilter
    implements FileFilter {
        private LogRepositoryFilesFilter() {
        }

        @Override
        public boolean accept(File fileObject) {
            if (LogRepositoryBaseImpl.this.fileExists(fileObject) && LogRepositoryBaseImpl.this.isFile(fileObject)) {
                return LogRepositoryBaseImpl.this.getLogFileTimestamp(fileObject) >= 0L;
            }
            return false;
        }
    }

    protected class LogRepositoryDirFilter
    implements FileFilter {
        protected LogRepositoryDirFilter() {
        }

        @Override
        public boolean accept(File fileObject) {
            if (LogRepositoryBaseImpl.this.fileExists(fileObject) && LogRepositoryBaseImpl.this.isDirectory(fileObject)) {
                return LogRepositoryBaseImpl.parseTimeStamp(fileObject.getName()) >= 0L;
            }
            return false;
        }
    }

    private class LogRepositoryFilesComparator
    implements Comparator<File> {
        private LogRepositoryFilesComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            long t2;
            long t1 = LogRepositoryBaseImpl.this.getLogFileTimestamp(f1);
            return t1 < (t2 = LogRepositoryBaseImpl.this.getLogFileTimestamp(f2)) ? -1 : (t1 > t2 ? 1 : 0);
        }
    }
}

