/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.annotations.SchemaValidation;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.AbstractWrapperHelper;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.WrapperCapableDatabinding;
import org.apache.cxf.databinding.WrapperHelper;
import org.apache.cxf.helpers.ServiceUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class WrapperClassOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getLogger(WrapperClassOutInterceptor.class);
    static final long serialVersionUID = 3449154869394832880L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WrapperClassOutInterceptor() {
        super("pre-logical");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        Exchange ex = message.getExchange();
        BindingOperationInfo bop = ex.getBindingOperationInfo();
        MessageInfo messageInfo = (MessageInfo)message.get(MessageInfo.class);
        if (messageInfo == null || bop == null || !bop.isUnwrapped()) {
            if (isFinestEnabled) {
                LOG.finest("MessageInfo(messageInfo):" + messageInfo + " or BindingOperationInfo(bop):" + bop + " is null or BindingOperationInfo(bop) is wrapped: " + !bop.isUnwrapped() + ". Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "handleMessage");
            }
            return;
        }
        BindingOperationInfo newbop = bop.getWrappedOperation();
        MessageInfo wrappedMsgInfo = this.isRequestor(message) ? newbop.getInput().getMessageInfo() : newbop.getOutput().getMessageInfo();
        Class wrapped = null;
        if (wrappedMsgInfo.getMessagePartsNumber() > 0) {
            wrapped = wrappedMsgInfo.getFirstMessagePart().getTypeClass();
        }
        if (isFinestEnabled) {
            LOG.finest("Type class of first mesage part: " + wrapped);
        }
        if (wrapped != null) {
            MessagePartInfo firstMessagePart = wrappedMsgInfo.getFirstMessagePart();
            MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
            WrapperHelper helper = (WrapperHelper)firstMessagePart.getProperty("WRAPPER_CLASS", WrapperHelper.class);
            if (isFinestEnabled) {
                LOG.finest("WrapperHelper(helper) that is obtained from first MessagePartInfo WRAPPER_CLASS property: " + helper);
            }
            if (helper == null) {
                helper = this.getWrapperHelper(message, messageInfo, wrappedMsgInfo, wrapped, firstMessagePart);
                if (isFinestEnabled) {
                    LOG.finest("WrapperHelper(helper) was null. It is obtained from getWrapperHelper method: " + helper);
                }
            }
            if (helper == null) {
                if (isFinestEnabled) {
                    LOG.finest("WrapperHelper(helper) is still null. Returning.");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "handleMessage");
                }
                return;
            }
            try {
                MessageContentsList newObjs = new MessageContentsList();
                if (ServiceUtils.isSchemaValidationEnabled((SchemaValidation.SchemaValidationType)SchemaValidation.SchemaValidationType.OUT, (Message)message) && helper instanceof AbstractWrapperHelper) {
                    ((AbstractWrapperHelper)helper).setValidate(true);
                    if (isFinestEnabled) {
                        LOG.finest("Validation is set to true for AbstractWrapperHelper.");
                    }
                }
                Object o2 = helper.createWrapperObject((List)objs);
                newObjs.put(firstMessagePart, o2);
                for (MessagePartInfo p : messageInfo.getMessageParts()) {
                    if (!Boolean.TRUE.equals(p.getProperty("messagepart.isheader"))) continue;
                    MessagePartInfo mpi = wrappedMsgInfo.getMessagePart(p.getName());
                    if (!objs.hasValue(p)) continue;
                    newObjs.put(mpi, objs.get(p));
                }
                message.setContent(List.class, (Object)newObjs);
                if (isFinestEnabled) {
                    LOG.finest("New MessageContentsList is set into Message: " + newObjs);
                }
            }
            catch (Fault f) {
                throw f;
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
            ex.put(BindingOperationInfo.class, (Object)newbop);
            if (isFinestEnabled) {
                LOG.finest("New BindingOperationInfo is set into Exchange: " + newbop);
            }
            if (messageInfo == bop.getOperationInfo().getInput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getInput());
                message.put(BindingMessageInfo.class, (Object)newbop.getInput());
            } else if (messageInfo == bop.getOperationInfo().getOutput()) {
                message.put(MessageInfo.class, (Object)newbop.getOperationInfo().getOutput());
                message.put(BindingMessageInfo.class, (Object)newbop.getOutput());
            }
            if (isFinestEnabled) {
                LOG.finest("MessageInfo that is put into message: " + message.get(MessageInfo.class));
                LOG.finest("BindingMessageInfo that is put into message: " + message.get(BindingMessageInfo.class));
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "handleMessage");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private synchronized WrapperHelper getWrapperHelper(Message message, MessageInfo messageInfo, MessageInfo wrappedMessageInfo, Class<?> wrapClass, MessagePartInfo messagePartInfo) {
        Service service;
        DataBinding dataBinding;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "getWrapperHelper", new Object[]{message, messageInfo, wrappedMessageInfo, wrapClass, messagePartInfo});
        }
        WrapperHelper helper = (WrapperHelper)messagePartInfo.getProperty("WRAPPER_CLASS", WrapperHelper.class);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("WrapperHelper that is obtained from first MessagePartInfo WRAPPER_CLASS property: " + helper);
        }
        if (helper == null && (dataBinding = (service = ServiceModelUtil.getService((Exchange)message.getExchange())).getDataBinding()) instanceof WrapperCapableDatabinding) {
            helper = this.createWrapperHelper((WrapperCapableDatabinding)dataBinding, messageInfo, wrappedMessageInfo, wrapClass);
            messagePartInfo.setProperty("WRAPPER_CLASS", (Object)helper);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("WrapperHelper was null. It is obtained from getWrapperHelper method: " + helper + " and it's set in WRAPPER_CLASS property of messagePartInfo");
            }
        }
        WrapperHelper wrapperHelper = helper;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "getWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void ensureSize(List<?> lst, int idx) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "ensureSize", new Object[]{lst, idx});
        }
        while (idx >= lst.size()) {
            lst.add(null);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "ensureSize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private WrapperHelper createWrapperHelper(WrapperCapableDatabinding dataBinding, MessageInfo messageInfo, MessageInfo wrappedMessageInfo, Class<?> wrapperClass) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "createWrapperHelper", new Object[]{dataBinding, messageInfo, wrappedMessageInfo, wrapperClass});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        ArrayList<String> partNames = new ArrayList<String>();
        ArrayList<String> elTypeNames = new ArrayList<String>();
        ArrayList<Class> partClasses = new ArrayList<Class>();
        QName wrapperName = null;
        for (MessagePartInfo p : wrappedMessageInfo.getMessageParts()) {
            if (p.getTypeClass() != wrapperClass) continue;
            wrapperName = p.getElementQName();
            if (!isFinestEnabled) break;
            LOG.finest("MessagePartInfo(p) class matches wrapper class name that is obtained from parameter value. Corresponding element QName: " + wrapperName);
            break;
        }
        for (MessagePartInfo p : messageInfo.getMessageParts()) {
            if (p.getTypeClass() == null) continue;
            this.ensureSize(partNames, p.getIndex());
            this.ensureSize(elTypeNames, p.getIndex());
            this.ensureSize(partClasses, p.getIndex());
            partNames.set(p.getIndex(), p.getName().getLocalPart());
            if (isFinestEnabled) {
                LOG.finest("Added messagePartInfo local part: " + (String)partNames.get(p.getIndex()) + " is added to part names");
            }
            String elementType = p.getTypeQName() == null ? null : p.getTypeQName().getLocalPart();
            elTypeNames.set(p.getIndex(), elementType);
            partClasses.set(p.getIndex(), p.getTypeClass());
        }
        if (isFinestEnabled) {
            LOG.finest("Added part names: " + partNames);
            LOG.finest("Added element type names: " + elTypeNames);
            LOG.finest("Added type classes: " + elTypeNames);
        }
        WrapperHelper wrapperHelper = dataBinding.createWrapperHelper(wrapperClass, wrapperName, partNames, elTypeNames, partClasses);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            wrapperHelper = wrapperHelper;
            LOG.exiting("org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor", "createWrapperHelper", wrapperHelper);
        }
        return wrapperHelper;
    }
}

