/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import jakarta.jws.WebService;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.ws.Dispatch;
import jakarta.xml.ws.EndpointReference;
import jakarta.xml.ws.Service;
import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.WebServiceFeature;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.HandlerResolver;
import jakarta.xml.ws.handler.PortInfo;
import jakarta.xml.ws.spi.ServiceDelegate;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapAddress;
import org.apache.cxf.binding.soap.wsdl.extensions.SoapBinding;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.ServiceContractResolverRegistry;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.CXFService;
import org.apache.cxf.jaxws.DispatchImpl;
import org.apache.cxf.jaxws.JaxWsClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.binding.soap.JaxWsSoapBindingConfiguration;
import org.apache.cxf.jaxws.handler.HandlerResolverImpl;
import org.apache.cxf.jaxws.handler.PortInfoImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.jaxws.support.BindingID;
import org.apache.cxf.jaxws.support.DummyImpl;
import org.apache.cxf.jaxws.support.JaxWsClientEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.apache.cxf.jaxws.support.JaxWsServiceFactoryBean;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.wsdl.WSDLManager;
import org.apache.cxf.wsdl.http.AddressType;
import org.apache.cxf.wsdl11.WSDLServiceFactory;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ServiceImpl
extends ServiceDelegate {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceImpl.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    private Bus bus;
    private String wsdlURL;
    private HandlerResolver handlerResolver;
    private Executor executor;
    private QName serviceName;
    private Class<?> clazz;
    private Map<QName, PortInfoImpl> portInfos;
    private WebServiceFeature[] serviceFeatures;
    static final long serialVersionUID = -5092523262480429061L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ServiceImpl(Bus b, URL url, QName name, Class<?> cls, WebServiceFeature ... f) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "<init>", new Object[]{b, url, name, cls, f});
        }
        this.portInfos = new HashMap<QName, PortInfoImpl>();
        this.clazz = cls;
        this.serviceName = name;
        if (cls == null || !CXFService.class.isAssignableFrom(cls)) {
            this.initialize(b, url, f);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    final void initialize(Bus b, URL url, WebServiceFeature ... f) {
        URI uri;
        ServiceContractResolverRegistry registry;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "initialize", new Object[]{b, url, f});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (b == null) {
            b = BusFactory.getThreadDefaultBus((boolean)true);
        }
        this.serviceFeatures = f;
        this.bus = b;
        this.handlerResolver = new HandlerResolverImpl(this.bus, this.serviceName, this.clazz);
        if (null == url && null != this.bus && null != (registry = (ServiceContractResolverRegistry)this.bus.getExtension(ServiceContractResolverRegistry.class)) && null != (uri = registry.getContractLocation(this.serviceName))) {
            try {
                url = uri.toURL();
            }
            catch (MalformedURLException e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("resolve qname failed: " + this.serviceName);
                }
                throw new WebServiceException((Throwable)e);
            }
        }
        String string = this.wsdlURL = url == null ? null : url.toString();
        if (url != null) {
            try {
                this.initializePorts();
            }
            catch (ServiceConstructionException e) {
                throw new WebServiceException((Throwable)e);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "initialize");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initializePorts() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "initializePorts", new Object[0]);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        try {
            Definition def = ((WSDLManager)this.bus.getExtension(WSDLManager.class)).getDefinition(this.wsdlURL);
            javax.wsdl.Service serv = def.getService(this.serviceName);
            if (serv == null) {
                throw new WebServiceException("Could not find service named " + this.serviceName + " in wsdl " + this.wsdlURL);
            }
            Map wsdlports = CastUtils.cast((Map)serv.getPorts());
            if (isFinestEnabled) {
                if (wsdlports != null) {
                    LOG.finest("WSDL ports size: " + wsdlports.size());
                } else {
                    LOG.finest("wsdlPorts is null, falling back to add ports via the EndpointInfo");
                }
            }
            for (Port port : wsdlports.values()) {
                ExtensibilityElement e;
                QName name = new QName(this.serviceName.getNamespaceURI(), port.getName());
                String address = null;
                String bindingID = null;
                List extensions = CastUtils.cast((List)port.getBinding().getExtensibilityElements());
                if (!extensions.isEmpty()) {
                    e = (ExtensibilityElement)extensions.get(0);
                    if (e instanceof SoapBinding) {
                        bindingID = "http://schemas.xmlsoap.org/wsdl/soap/http";
                    } else if (e instanceof SOAP12Binding) {
                        bindingID = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
                    } else if (e instanceof SOAPBinding) {
                        bindingID = "http://schemas.xmlsoap.org/wsdl/soap/http";
                    }
                }
                if (isFinestEnabled) {
                    LOG.finest("Binding id: " + bindingID);
                }
                if (!(extensions = CastUtils.cast((List)port.getExtensibilityElements())).isEmpty()) {
                    e = (ExtensibilityElement)extensions.get(0);
                    if (e instanceof SoapAddress) {
                        address = ((SoapAddress)e).getLocationURI();
                    } else if (e instanceof AddressType) {
                        address = ((AddressType)e).getLocation();
                    } else if (e instanceof SOAP12Address) {
                        address = ((SOAP12Address)e).getLocationURI();
                    } else if (e instanceof SOAPAddress) {
                        address = ((SOAPAddress)e).getLocationURI();
                    } else if (e instanceof HTTPAddress) {
                        address = ((HTTPAddress)e).getLocationURI();
                    }
                }
                this.addPort(name, bindingID, address);
            }
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Throwable e) {
            if (e instanceof UncheckedException && LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            WSDLServiceFactory sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            Service service = sf.create();
            for (ServiceInfo si : service.getServiceInfos()) {
                for (EndpointInfo ei : si.getEndpoints()) {
                    String bindingID = BindingID.getJaxwsBindingID(ei.getTransportId());
                    this.addPort(ei.getName(), bindingID, ei.getAddress());
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "initializePorts");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public final void addPort(QName portName, String bindingId, String address) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "addPort", new Object[]{portName, bindingId, address});
        }
        PortInfoImpl portInfo = new PortInfoImpl(bindingId, portName, this.serviceName);
        portInfo.setAddress(address);
        this.portInfos.put(portName, portInfo);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "addPort");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<WebServiceFeature> getAllFeatures(WebServiceFeature[] features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getAllFeatures", new Object[]{features});
        }
        ArrayList<WebServiceFeature> f = new ArrayList<WebServiceFeature>();
        if (features != null) {
            Collections.addAll(f, features);
        }
        if (this.serviceFeatures != null) {
            Collections.addAll(f, this.serviceFeatures);
        }
        ArrayList<WebServiceFeature> arrayList = f;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getAllFeatures", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private JaxWsClientEndpointImpl getJaxwsEndpoint(QName portName, AbstractServiceFactoryBean sf, WebServiceFeature ... features) {
        JaxWsClientEndpointImpl jaxWsClientEndpointImpl;
        block16: {
            PortInfoImpl portInfo;
            EndpointInfo ei;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getJaxwsEndpoint", new Object[]{portName, sf, features});
            }
            boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
            Service service = sf.getService();
            if (portName == null) {
                ei = (EndpointInfo)((ServiceInfo)service.getServiceInfos().get(0)).getEndpoints().iterator().next();
                if (isFinestEnabled) {
                    LOG.finest("EndpointInfo obtained from ServiceInfo because portname is null: " + ei);
                }
            } else {
                ei = service.getEndpointInfo(portName);
                if (isFinestEnabled) {
                    LOG.finest("EndpointInfo obtained from Service using portname: " + ei);
                }
                if (ei == null) {
                    portInfo = this.getPortInfo(portName);
                    if (isFinestEnabled) {
                        LOG.finest("PortInfoImpl that is obtained from ServiceInpl.portInfos with key portname: " + portInfo);
                    }
                    if (null != portInfo) {
                        try {
                            ei = this.createEndpointInfo(sf, portName, portInfo);
                        }
                        catch (BusException e) {
                            throw new WebServiceException((Throwable)e);
                        }
                        if (isFinestEnabled) {
                            LOG.finest("Endpoint was null, it's created using endpoint info: " + ei);
                        }
                    }
                }
            }
            if (ei == null) {
                Message msg = new Message("INVALID_PORT", BUNDLE, new Object[]{portName});
                throw new WebServiceException(msg.toString());
            }
            portInfo = this.getPortInfo(portName);
            if (portInfo != null && portInfo.getAddress() != null && !portInfo.getAddress().equals(ei.getAddress())) {
                ei.setAddress(portInfo.getAddress());
                if (isFinestEnabled) {
                    LOG.finest("Setting EndpointInfo, " + ei + ", with Address: " + portInfo.getAddress());
                }
            }
            try {
                jaxWsClientEndpointImpl = new JaxWsClientEndpointImpl(this.bus, service, ei, this, this.getAllFeatures(features));
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block16;
            }
            catch (EndpointException e) {
                throw new WebServiceException((Throwable)e);
            }
            jaxWsClientEndpointImpl = jaxWsClientEndpointImpl;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getJaxwsEndpoint", (Object)jaxWsClientEndpointImpl);
        }
        return jaxWsClientEndpointImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private AbstractServiceFactoryBean createDispatchService(DataBinding db) {
        JaxWsServiceFactoryBean serviceFactory;
        Service dispatchService;
        JaxWsServiceFactoryBean sf;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatchService", new Object[]{db});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (null != this.wsdlURL) {
            sf = new WSDLServiceFactory(this.bus, this.wsdlURL, this.serviceName);
            dispatchService = sf.create();
            dispatchService.setDataBinding(db);
            serviceFactory = sf;
            if (isFinestEnabled) {
                LOG.finest("ServiceFactory is created using WSDL URL with WSDLServiceFactory: " + (Object)((Object)sf));
            }
        } else {
            sf = new JaxWsServiceFactoryBean();
            sf.setBus(this.bus);
            sf.setServiceName(this.serviceName);
            sf.setServiceClass(DummyImpl.class);
            sf.setDataBinding(db);
            dispatchService = sf.create();
            serviceFactory = sf;
            if (isFinestEnabled) {
                LOG.finest("ServiceFactory is created trough ReflectionServiceFactoryBean: " + (Object)((Object)sf));
            }
        }
        this.configureObject(dispatchService);
        for (ServiceInfo si : dispatchService.getServiceInfos()) {
            si.setProperty("soap.force.doclit.bare", (Object)Boolean.TRUE);
            if (null == this.wsdlURL) {
                for (EndpointInfo ei : si.getEndpoints()) {
                    ei.setProperty("soap.no.validate.parts", (Object)Boolean.TRUE);
                }
            }
            for (BindingInfo bind : si.getBindings()) {
                for (BindingOperationInfo bop : bind.getOperations()) {
                    if (!bop.isUnwrappedCapable()) continue;
                    bop.getOperationInfo().setUnwrappedOperation(null);
                    bop.setUnwrappedOperation(null);
                }
            }
        }
        JaxWsServiceFactoryBean jaxWsServiceFactoryBean = serviceFactory;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jaxWsServiceFactoryBean = jaxWsServiceFactoryBean;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatchService", (Object)jaxWsServiceFactoryBean);
        }
        return jaxWsServiceFactoryBean;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Executor getExecutor() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getExecutor", new Object[0]);
        }
        Executor executor = this.executor;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            executor = executor;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getExecutor", executor);
        }
        return executor;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HandlerResolver getHandlerResolver() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getHandlerResolver", new Object[0]);
        }
        HandlerResolver handlerResolver = this.handlerResolver;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            handlerResolver = handlerResolver;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getHandlerResolver", handlerResolver);
        }
        return handlerResolver;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(Class<T> serviceEndpointInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{serviceEndpointInterface});
        }
        T t = this.getPort(serviceEndpointInterface, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        T t;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{serviceEndpointInterface, features});
            }
            try {
                t = this.createPort(null, null, serviceEndpointInterface, features);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (ServiceConstructionException e) {
                throw new WebServiceException((Throwable)e);
            }
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{portName, serviceEndpointInterface});
        }
        T t = this.getPort(portName, serviceEndpointInterface, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(QName portName, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        T t;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{portName, serviceEndpointInterface, features});
            }
            if (portName == null) {
                throw new WebServiceException(BUNDLE.getString("PORT_NAME_NULL_EXC"));
            }
            try {
                t = this.createPort(portName, null, serviceEndpointInterface, features);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (ServiceConstructionException e) {
                throw new WebServiceException((Throwable)e);
            }
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(EndpointReferenceType endpointReference, Class<T> type) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{endpointReference, type});
        }
        T t = this.getPort(endpointReference, type, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(EndpointReferenceType endpointReference, Class<T> type, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{endpointReference, type, features});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        endpointReference = EndpointReferenceUtils.resolve((EndpointReferenceType)endpointReference, (Bus)this.bus);
        QName serviceQName = EndpointReferenceUtils.getServiceName((EndpointReferenceType)endpointReference, (Bus)this.bus);
        String portName = EndpointReferenceUtils.getPortName((EndpointReferenceType)endpointReference);
        if (isFinestEnabled) {
            LOG.finest("Service QName: " + serviceQName);
            LOG.finest("Port Name: " + portName);
        }
        QName portQName = null;
        if (portName != null && serviceQName != null) {
            String ns = serviceQName.getNamespaceURI();
            if (StringUtils.isEmpty((String)ns)) {
                for (QName qn : this.portInfos.keySet()) {
                    if (!portName.equals(qn.getLocalPart())) continue;
                    ns = qn.getNamespaceURI();
                }
            }
            if (StringUtils.isEmpty((String)ns) && this.serviceName != null) {
                ns = this.serviceName.getNamespaceURI();
            }
            portQName = new QName(ns, portName);
        }
        T t = this.createPort(portQName, endpointReference, type, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Iterator<QName> getPorts() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPorts", new Object[0]);
        }
        Iterator<QName> iterator = this.portInfos.keySet().iterator();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            iterator = iterator;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPorts", iterator);
        }
        return iterator;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public QName getServiceName() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getServiceName", new Object[0]);
        }
        QName qName = this.serviceName;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getServiceName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public URL getWSDLDocumentLocation() {
        URL uRL;
        block3: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getWSDLDocumentLocation", new Object[0]);
            }
            try {
                uRL = new URL(this.wsdlURL);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block3;
            }
            catch (MalformedURLException e) {
                throw new WebServiceException((Throwable)e);
            }
            uRL = uRL;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getWSDLDocumentLocation", uRL);
        }
        return uRL;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setExecutor(Executor e) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "setExecutor", new Object[]{e});
        }
        this.executor = e;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "setExecutor");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setHandlerResolver(HandlerResolver hr) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "setHandlerResolver", new Object[]{hr});
        }
        this.handlerResolver = hr;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "setHandlerResolver");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Bus getBus() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getBus", new Object[0]);
        }
        Bus bus = this.bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bus = bus;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getBus", bus);
        }
        return bus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createPort", new Object[]{portName, epr, serviceEndpointInterface});
        }
        T t = this.createPort(portName, epr, serviceEndpointInterface, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected <T> T createPort(QName portName, EndpointReferenceType epr, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        PortInfoImpl portInfo;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createPort", new Object[]{portName, epr, serviceEndpointInterface, features});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("creating port for portName" + portName);
            LOG.fine("endpoint reference:" + epr);
            LOG.fine("endpoint interface:" + serviceEndpointInterface);
        }
        final JaxWsProxyFactoryBean proxyFac = new JaxWsProxyFactoryBean();
        JaxWsClientFactoryBean clientFac = (JaxWsClientFactoryBean)proxyFac.getClientFactoryBean();
        JaxWsServiceFactoryBean serviceFactory = (JaxWsServiceFactoryBean)proxyFac.getServiceFactory();
        List<WebServiceFeature> f = this.getAllFeatures(features);
        proxyFac.initFeatures();
        if (f != null) {
            serviceFactory.setWsFeatures(f);
        }
        proxyFac.setBus(this.bus);
        proxyFac.setServiceClass(serviceEndpointInterface);
        proxyFac.setServiceName(this.serviceName);
        if (epr != null && epr.getAddress() != null && epr.getAddress().getValue() != null) {
            clientFac.setAddress(epr.getAddress().getValue());
            if (isFinestEnabled) {
                LOG.finest("Address is set to JaxWsClientFactoryBean with the address that is obtained from EndpointReferenceType: " + clientFac.getAddress());
            }
        }
        if (this.wsdlURL != null) {
            proxyFac.setWsdlURL(this.wsdlURL);
            if (isFinestEnabled) {
                LOG.finest("WSDL URL(wsdlURL) is set to JaxWsProxyFactoryBean with the value that is obtained from ServivceImpl: " + this.wsdlURL);
            }
        }
        this.configureObject((Object)proxyFac);
        this.configureObject((Object)clientFac);
        if (portName == null) {
            EndpointInfo ei;
            QName portTypeName = this.getPortTypeName(serviceEndpointInterface);
            Service service = serviceFactory.getService();
            if (service == null) {
                serviceFactory.setServiceClass(serviceEndpointInterface);
                serviceFactory.setBus(this.getBus());
                service = serviceFactory.create();
                if (isFinestEnabled) {
                    LOG.finest("Service object was null. It's created from JaxWsServiceFactoryBean: " + service);
                }
            }
            portName = (ei = ServiceModelUtil.findBestEndpointInfo((QName)portTypeName, (List)service.getServiceInfos())) != null ? ei.getName() : serviceFactory.getEndpointName();
        }
        serviceFactory.setEndpointName(portName);
        if (epr != null) {
            clientFac.setEndpointReference(epr);
        }
        if ((portInfo = this.portInfos.get(portName)) != null) {
            clientFac.setBindingId(portInfo.getBindingID());
            clientFac.setAddress(portInfo.getAddress());
            if (isFinestEnabled) {
                LOG.finest("Binding id is set into JaxWsClientFactoryBean(clientFac): " + clientFac.getBindingId());
                LOG.finest("Address is  set into JaxWsClientFactoryBean(clientFac): " + clientFac.getAddress());
            }
        }
        if (this.clazz != ServiceImpl.class) {
            proxyFac.setLoadHandlers(false);
        }
        Object obj = AccessController.doPrivileged(new PrivilegedAction<Object>(){
            static final long serialVersionUID = 2045037895224825284L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Object run() {
                return proxyFac.create();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxws.ServiceImpl$1", 1.class, null, null);
            }
        });
        proxyFac.create();
        Service service = serviceFactory.getService();
        this.configureObject(service);
        Client client = ClientProxy.getClient((Object)obj);
        client.getEndpoint().setExecutor(this.executor);
        client.setExecutor(this.executor);
        JaxWsEndpointImpl jaxwsEndpoint = (JaxWsEndpointImpl)client.getEndpoint();
        this.configureObject((Object)jaxwsEndpoint);
        List hc = jaxwsEndpoint.getJaxwsBinding().getHandlerChain();
        hc.addAll(this.handlerResolver.getHandlerChain((PortInfo)this.portInfos.get(portName)));
        jaxwsEndpoint.getJaxwsBinding().setHandlerChain(hc);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "created proxy", obj);
        }
        if (portInfo == null) {
            this.addPort(portName, clientFac.getBindingId(), clientFac.getAddress());
            if (isFinestEnabled) {
                LOG.finest("PortInfoImpl was null. A port is added with name: " + portName + ", binding id: " + clientFac.getBindingId() + ", address: " + clientFac.getAddress());
            }
        }
        T t = serviceEndpointInterface.cast(obj);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private EndpointInfo createEndpointInfo(AbstractServiceFactoryBean serviceFactory, QName portName, PortInfoImpl portInfo) throws BusException {
        String transportId;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createEndpointInfo", new Object[]{serviceFactory, portName, portInfo});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        String address = portInfo.getAddress();
        String bindingID = BindingID.getBindingID(portInfo.getBindingID());
        DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
        try {
            dfm.getDestinationFactory(bindingID);
        }
        catch (BusException busException) {
            // empty catch block
        }
        DestinationFactory df = dfm.getDestinationFactoryForUri(address);
        if (isFinestEnabled) {
            LOG.finest("DestinationFactory that is obtained from DestinationFactoryManager: " + df != null ? df.getClass().getName() : ", with address: " + address);
        }
        if (df != null && df.getTransportIds() != null && !df.getTransportIds().isEmpty()) {
            transportId = (String)df.getTransportIds().get(0);
            if (isFinestEnabled) {
                LOG.finest("transportId that is obtained from DestinationFactoryManager: " + transportId);
            }
        } else {
            transportId = bindingID;
            if (isFinestEnabled) {
                LOG.finest("bindingID that is assigned to transportId : " + transportId);
            }
        }
        JaxWsSoapBindingConfiguration config = null;
        if (serviceFactory instanceof JaxWsServiceFactoryBean) {
            config = new JaxWsSoapBindingConfiguration((JaxWsServiceFactoryBean)serviceFactory);
        }
        BindingInfo bindingInfo = ((BindingFactoryManager)this.bus.getExtension(BindingFactoryManager.class)).getBindingFactory(bindingID).createBindingInfo(serviceFactory.getService(), bindingID, (Object)config);
        if (isFinestEnabled) {
            LOG.finest("BindingInfo that is created from BindingFactory: " + bindingInfo + ", with service: " + serviceFactory.getService() + ", BindingID: " + bindingID + " and config: " + (Object)((Object)config));
        }
        Service service = serviceFactory.getService();
        ((ServiceInfo)service.getServiceInfos().get(0)).addBinding(bindingInfo);
        EndpointInfo ei = new EndpointInfo((ServiceInfo)service.getServiceInfos().get(0), transportId);
        ei.setName(portName);
        ei.setAddress(address);
        ei.setBinding(bindingInfo);
        if (isFinestEnabled) {
            LOG.finest("Newly instantiated EndpointInfo : " + ei + ", with service info: " + service.getServiceInfos().get(0) + " and with transport id: " + transportId);
        }
        ((ServiceInfo)service.getServiceInfos().get(0)).addEndpoint(ei);
        EndpointInfo endpointInfo = ei;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            endpointInfo = endpointInfo;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createEndpointInfo", endpointInfo);
        }
        return endpointInfo;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void configureObject(Object instance) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "configureObject", new Object[]{instance});
        }
        this.configureObject(null, instance);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "configureObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void configureObject(String name, Object instance) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "configureObject", new Object[]{name, instance});
        }
        Configurer configurer = (Configurer)this.bus.getExtension(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(name, instance);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "configureObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private PortInfoImpl getPortInfo(QName portName) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPortInfo", new Object[]{portName});
        }
        if (portName == null) {
            PortInfoImpl portInfoImpl = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                portInfoImpl = portInfoImpl;
                LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPortInfo", portInfoImpl);
            }
            return portInfoImpl;
        }
        PortInfoImpl portInfoImpl = this.portInfos.get(portName);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            portInfoImpl = portInfoImpl;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPortInfo", portInfoImpl);
        }
        return portInfoImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private QName getPortTypeName(Class<?> serviceEndpointInterface) {
        String tns;
        String name;
        WebService webService;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPortTypeName", new Object[]{serviceEndpointInterface});
        }
        Class<?> seiClass = serviceEndpointInterface;
        if (!serviceEndpointInterface.isAnnotationPresent(WebService.class)) {
            Message msg = new Message("SEI_NO_WEBSERVICE_ANNOTATION", BUNDLE, new Object[]{serviceEndpointInterface.getCanonicalName()});
            throw new WebServiceException(msg.toString());
        }
        if (!serviceEndpointInterface.isInterface()) {
            webService = serviceEndpointInterface.getAnnotation(WebService.class);
            String epi = webService.endpointInterface();
            if (epi.length() > 0) {
                try {
                    seiClass = Thread.currentThread().getContextClassLoader().loadClass(epi);
                }
                catch (ClassNotFoundException e) {
                    Message msg = new Message("COULD_NOT_LOAD_CLASS", BUNDLE, new Object[]{epi});
                    throw new WebServiceException(msg.toString());
                }
                if (!seiClass.isAnnotationPresent(WebService.class)) {
                    Message msg = new Message("SEI_NO_WEBSERVICE_ANNOTATION", BUNDLE, new Object[]{seiClass.getCanonicalName()});
                    throw new WebServiceException(msg.toString());
                }
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Fully qualified name of WebService Endpoint Interface(epi) is empty.");
            }
        }
        if ((name = (webService = seiClass.getAnnotation(WebService.class)).name()).length() == 0) {
            name = seiClass.getSimpleName();
        }
        if ((tns = webService.targetNamespace()).isEmpty()) {
            tns = PackageUtils.getNamespace((String)PackageUtils.getPackageName(seiClass));
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Target namespace is not defined in WebService annotation. It will be obtained from SEI class package name.");
            }
        }
        QName qName = new QName(tns, name);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            qName = qName;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPortTypeName", qName);
        }
        return qName;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{portName, type, mode});
        }
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{portName, type, mode, features});
        }
        Dispatch<T> dispatch = this.createDispatch(portName, type, null, mode, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> Dispatch<T> createDispatch(QName portName, Class<T> type, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        AbstractServiceFactoryBean sf;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{portName, type, context, mode, features});
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        JaxWsProxyFactoryBean clientFac = new JaxWsProxyFactoryBean();
        this.configureObject(portName.toString() + ".jaxws-client.proxyFactory", (Object)clientFac);
        try {
            Object db = context != null ? new JAXBDataBinding(context) : new SourceDataBinding(type);
            sf = this.createDispatchService((DataBinding)db);
        }
        catch (ServiceConstructionException e) {
            throw new WebServiceException((Throwable)e);
        }
        JaxWsClientEndpointImpl endpoint = this.getJaxwsEndpoint(portName, sf, features);
        if (clientFac.getProperties() != null) {
            endpoint.putAll(clientFac.getProperties());
        }
        endpoint.getFeatures().addAll(clientFac.getFeatures());
        Bus clientBus = this.getBus();
        if (clientFac.getBus() != BusFactory.getThreadDefaultBus((boolean)false) && clientFac.getBus() != null) {
            clientBus = clientFac.getBus();
        }
        List<Handler> hc = clientFac.getHandlers();
        hc.addAll(this.handlerResolver.getHandlerChain((PortInfo)this.portInfos.get(portName)));
        endpoint.getJaxwsBinding().setHandlerChain(hc);
        ClientImpl client = new ClientImpl(clientBus, (Endpoint)endpoint, clientFac.getConduitSelector());
        for (Feature af : endpoint.getFeatures()) {
            af.initialize((Client)client, clientBus);
            if (!isFinestEnabled) continue;
            LOG.finest("Initialized feature that is obtained from JaxWsEndpointImpl(endpoint): " + af);
        }
        this.initIntercepors((Client)client, (AbstractBasicInterceptorProvider)clientFac);
        if (this.executor != null) {
            client.getEndpoint().setExecutor(this.executor);
        }
        if (!StringUtils.isEmpty((String)clientFac.getAddress())) {
            client.getEndpoint().getEndpointInfo().setAddress(clientFac.getAddress());
        } else {
            PortInfoImpl portInfo = this.portInfos.get(portName);
            if (portInfo != null && !StringUtils.isEmpty((String)portInfo.getAddress())) {
                client.getEndpoint().getEndpointInfo().setAddress(portInfo.getAddress());
            }
        }
        DispatchImpl<T> disp = new DispatchImpl<T>((Client)client, mode, context, type);
        this.configureObject(disp);
        DispatchImpl<T> dispatchImpl = disp;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatchImpl = dispatchImpl;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatchImpl);
        }
        return dispatchImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> Dispatch<T> createDispatch(EndpointReference endpointReference, Class<T> type, Service.Mode mode, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{endpointReference, type, mode, features});
        }
        EndpointReferenceType ref = ProviderImpl.convertToInternal(endpointReference);
        QName portName = EndpointReferenceUtils.getPortQName((EndpointReferenceType)ref, (Bus)this.bus);
        this.updatePortInfoAddress(portName, EndpointReferenceUtils.getAddress((EndpointReferenceType)ref));
        Dispatch<T> dispatch = this.createDispatch(portName, type, mode, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{portName, context, mode});
        }
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode, new WebServiceFeature[0]);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Dispatch<Object> createDispatch(QName portName, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{portName, context, mode, features});
        }
        Dispatch<Object> dispatch = this.createDispatch(portName, Object.class, context, mode, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Dispatch<Object> createDispatch(EndpointReference endpointReference, JAXBContext context, Service.Mode mode, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", new Object[]{endpointReference, context, mode, features});
        }
        EndpointReferenceType ref = ProviderImpl.convertToInternal(endpointReference);
        QName portName = EndpointReferenceUtils.getPortQName((EndpointReferenceType)ref, (Bus)this.bus);
        this.updatePortInfoAddress(portName, EndpointReferenceUtils.getAddress((EndpointReferenceType)ref));
        Dispatch<Object> dispatch = this.createDispatch(portName, context, mode, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            dispatch = dispatch;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "createDispatch", dispatch);
        }
        return dispatch;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public <T> T getPort(EndpointReference endpointReference, Class<T> serviceEndpointInterface, WebServiceFeature ... features) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "getPort", new Object[]{endpointReference, serviceEndpointInterface, features});
        }
        T t = this.getPort(ProviderImpl.convertToInternal(endpointReference), serviceEndpointInterface, features);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            t = t;
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "getPort", t);
        }
        return t;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void initIntercepors(Client client, AbstractBasicInterceptorProvider clientFact) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "initIntercepors", new Object[]{client, clientFact});
        }
        client.getInInterceptors().addAll(clientFact.getInInterceptors());
        client.getOutInterceptors().addAll(clientFact.getOutInterceptors());
        client.getInFaultInterceptors().addAll(clientFact.getInFaultInterceptors());
        client.getOutFaultInterceptors().addAll(clientFact.getOutFaultInterceptors());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "initIntercepors");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void updatePortInfoAddress(QName portName, String eprAddress) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.ServiceImpl", "updatePortInfoAddress", new Object[]{portName, eprAddress});
        }
        PortInfoImpl portInfo = this.portInfos.get(portName);
        if (!StringUtils.isEmpty((String)eprAddress) && portInfo != null) {
            portInfo.setAddress(eprAddress);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.ServiceImpl", "updatePortInfoAddress");
        }
    }
}

