/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ServerInfo;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.OpenApiSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUtils {
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    static final long serialVersionUID = -783195989399858018L;

    @Trivial
    @FFDCIgnore(value={IOException.class})
    public static String getOpenAPIDocument(OpenAPI openAPIModel, Format format) {
        String oasResult;
        block3: {
            oasResult = null;
            if (openAPIModel != null) {
                try {
                    oasResult = OpenApiSerializer.serialize((OpenAPI)openAPIModel, (Format)format);
                }
                catch (IOException e) {
                    if (!LoggingUtils.isEventEnabled(tc)) break block3;
                    Tr.event((TraceComponent)tc, (String)("Failed to serialize OpenAPI document: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return oasResult;
    }

    @Trivial
    public static boolean containsServersDefinition(OpenAPI openAPIModel) {
        boolean containsServers = false;
        if (openAPIModel != null && openAPIModel.getServers() != null && openAPIModel.getServers().size() > 0) {
            containsServers = true;
        }
        return containsServers;
    }

    public static List<Server> getOpenAPIModelServers(ServerInfo serverInfo, String applicationPath) {
        String port;
        ArrayList<Server> servers = new ArrayList<Server>();
        int httpPort = serverInfo.getHttpPort();
        int httpsPort = serverInfo.getHttpsPort();
        String host = serverInfo.getHost();
        if (httpPort > 0) {
            port = httpPort == 80 ? "" : ":" + httpPort;
            String url = "http://" + host + port;
            if (applicationPath != null) {
                url = url + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + url), (Object[])new Object[0]);
            }
            Server server = OASFactory.createServer();
            server.setUrl(url);
            servers.add(server);
        }
        if (httpsPort > 0) {
            port = httpsPort == 443 ? "" : ":" + httpsPort;
            String secureUrl = "https://" + host + port;
            if (applicationPath != null) {
                secureUrl = secureUrl + applicationPath;
            }
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Adding OpenAPI model server: " + secureUrl), (Object[])new Object[0]);
            }
            Server secureServer = OASFactory.createServer();
            secureServer.setUrl(secureUrl);
            servers.add(secureServer);
        }
        return servers;
    }

    private OpenAPIUtils() {
    }

    public static <T> boolean allEqual(Collection<? extends T> collection, BiPredicate<? super T, ? super T> comparator) {
        Iterator<T> i = collection.iterator();
        if (!i.hasNext()) {
            return true;
        }
        T first = i.next();
        while (i.hasNext()) {
            T next = i.next();
            if (OpenAPIUtils.equals(first, next, comparator)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equals(T a, T b, BiPredicate<? super T, ? super T> comparator) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : comparator.test(a, b);
    }

    @Trivial
    public static <K, V> Map<K, V> notNull(Map<K, V> in) {
        if (in == null) {
            return Collections.emptyMap();
        }
        return in;
    }

    @Trivial
    public static <V> List<V> notNull(List<V> in) {
        if (in == null) {
            return Collections.emptyList();
        }
        return in;
    }
}

