/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.OpenAPIVersion;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIVersionConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIVersionConfigImpl
implements OpenAPIVersionConfig {
    private static final TraceComponent tc = Tr.register(OpenAPIVersionConfigImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String VERSION_KEY = "openAPIVersion";
    protected static final OpenAPIVersion VERSION_30 = new OpenAPIVersion(3, 0, -1);
    protected static final OpenAPIVersion VERSION_303 = new OpenAPIVersion(3, 0, 3);
    protected volatile OpenAPIVersion configuredVersion = this.defaultVersion();
    protected String configuredVersionString = null;
    static final long serialVersionUID = -5045301151564772777L;

    @Activate
    @Modified
    protected void activate(Map<?, ?> properties) {
        String versionString = (String)properties.get(VERSION_KEY);
        if (Objects.equals(versionString, this.configuredVersionString)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"Config unchanged", (Object[])new Object[]{versionString});
            }
            return;
        }
        this.configuredVersionString = versionString;
        if (versionString == null) {
            this.configuredVersion = this.defaultVersion();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"No OpenAPI version set, default version used", (Object[])new Object[]{this.configuredVersion});
            }
            return;
        }
        Optional<OpenAPIVersion> version = OpenAPIVersion.parse(versionString);
        if (!version.isPresent()) {
            this.configuredVersion = this.defaultVersion();
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_VERSION_INVALID_CWWK06181W", (Object[])new Object[]{versionString, this.getSupportedVersions(), this.configuredVersion});
            return;
        }
        if (!this.isSupported(version.get())) {
            this.configuredVersion = this.defaultVersion();
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_VERSION_NOT_SUPPORTED_CWWK06182W", (Object[])new Object[]{version.get(), this.getSupportedVersions(), this.configuredVersion});
            return;
        }
        this.configuredVersion = version.get();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"OpenAPI version set", (Object[])new Object[]{this.configuredVersion});
        }
    }

    @Override
    public void applyConfig(OpenAPI model) {
        Optional<OpenAPIVersion> modelVersion = OpenAPIVersion.parse(model.getOpenapi());
        boolean replace = modelVersion.map(this::requiresReplacement).orElse(true);
        if (replace) {
            model.setOpenapi(this.getReplacementVersion().toString());
        }
    }

    @Override
    public OpenAPIVersion getVersion() {
        return this.getReplacementVersion();
    }

    protected OpenAPIVersion defaultVersion() {
        return VERSION_30;
    }

    protected boolean isSupported(OpenAPIVersion version) {
        return version.getMajor() == 3 && version.getMinor() == 0;
    }

    protected String getSupportedVersions() {
        return "3.0, 3.0.x";
    }

    protected boolean requiresReplacement(OpenAPIVersion modelVersion) {
        if (modelVersion.getPatch() < 0) {
            return true;
        }
        if (modelVersion.getMajor() != this.configuredVersion.getMajor() || modelVersion.getMinor() != this.configuredVersion.getMinor()) {
            return true;
        }
        return this.configuredVersion.getPatch() != -1 && modelVersion.getPatch() != this.configuredVersion.getPatch();
    }

    protected OpenAPIVersion getReplacementVersion() {
        if (this.configuredVersion.getPatch() >= 0) {
            return this.configuredVersion;
        }
        return VERSION_303;
    }
}

