/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIAppConfigProvider;
import io.openliberty.microprofile.openapi.internal.common.services.OpenAPIServerXMLConfig;
import io.openliberty.microprofile.openapi20.internal.services.ModuleSelectionConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleSelectionConfigImpl
implements ModuleSelectionConfig,
OpenAPIAppConfigProvider.OpenAPIAppConfigListener {
    private static final TraceComponent tc = Tr.register(ModuleSelectionConfigImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private volatile ConfigValues configValues = null;
    @Reference
    protected OpenAPIAppConfigProvider configFromServerXMLProvider;
    private static final Pattern CONFIG_VALUE_NAME_REFERENCE = Pattern.compile("([^/]+?)(/(.+))?");
    static final long serialVersionUID = 3909265276472420103L;

    @Activate
    public void activate() {
        this.configFromServerXMLProvider.registerAppConfigListener((OpenAPIAppConfigProvider.OpenAPIAppConfigListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.configFromServerXMLProvider.unregisterAppConfigListener((OpenAPIAppConfigProvider.OpenAPIAppConfigListener)this);
    }

    @Override
    public String toString() {
        ConfigValues config = this.configValues;
        if (config == null) {
            return "Unconfigured Module Selection Config";
        }
        StringBuilder sb = new StringBuilder("Module Selection Config[");
        if (config.inclusionMode == InclusionMode.FIRST) {
            sb.append("useFirstModuleOnly");
        } else {
            if (config.inclusionMode == InclusionMode.ALL) {
                sb.append("include = all");
            } else {
                sb.append("include = ").append(config.included);
            }
            sb.append(", ");
            sb.append("exclude = ").append(config.excluded);
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean useFirstModuleOnly() {
        return this.getConfigValues().inclusionMode == InclusionMode.FIRST;
    }

    @Override
    public boolean isIncluded(ModuleInfo module) {
        ConfigValues config = this.getConfigValues();
        if (config.inclusionMode == InclusionMode.FIRST) {
            return true;
        }
        boolean result = false;
        if (config.inclusionMode == InclusionMode.ALL) {
            result = true;
        } else {
            for (ModuleName name : config.included) {
                if (!this.matches(name, module, config)) continue;
                result = true;
                break;
            }
        }
        if (result) {
            for (ModuleName name : config.excluded) {
                if (!this.matches(name, module, config)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    @Override
    public void sendWarningsForAppsAndModulesNotMatchingAnything(Collection<? extends ModuleInfo> moduleInfos) {
        ConfigValues config = this.getConfigValues();
        if (config.inclusionMode != InclusionMode.NORMAL) {
            return;
        }
        ArrayList<ModuleName> includedNotYetSeen = new ArrayList<ModuleName>(config.included);
        Iterator iterator = includedNotYetSeen.iterator();
        block0: while (iterator.hasNext()) {
            ModuleName moduleName = (ModuleName)iterator.next();
            for (ModuleInfo moduleInfo : moduleInfos) {
                if (!this.matches(moduleName, moduleInfo, config)) continue;
                iterator.remove();
                continue block0;
            }
        }
        HashMap<ModuleName, String> includedNotYetSeenButSeenUnderOldNaming = new HashMap<ModuleName, String>();
        if (config.serverxmlmode) {
            Iterator<Object> iterator2 = includedNotYetSeen.iterator();
            block2: while (iterator2.hasNext()) {
                ModuleName moduleName = (ModuleName)iterator2.next();
                for (ModuleInfo moduleInfo : moduleInfos) {
                    if (!ModuleSelectionConfigImpl.matches(moduleName, moduleInfo, MatchingMode.DEPLOYMENT_DESCRIPTOR_NAME)) continue;
                    includedNotYetSeenButSeenUnderOldNaming.put(moduleName, moduleInfo.getApplicationInfo().getDeploymentName());
                    iterator2.remove();
                    continue block2;
                }
            }
            for (ModuleName unmatchedInclude : includedNotYetSeenButSeenUnderOldNaming.keySet()) {
                String string = unmatchedInclude.moduleName != null ? "includeModule" : "includeApplication";
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_USING_WRONG_NAME_SOURCE_CWWKO1680W", (Object[])new Object[]{string, unmatchedInclude.appName, includedNotYetSeenButSeenUnderOldNaming.get(unmatchedInclude)});
            }
        }
        for (ModuleName unmatchedInclude : includedNotYetSeen) {
            if (config.serverxmlmode) {
                String string = unmatchedInclude.moduleName == null ? "includeApplication" : "includeModule";
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_UNUSED_INCLUDE_SERVERXML_CWWKO1684W", (Object[])new Object[]{string, unmatchedInclude});
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_UNUSED_INCLUDE_CWWKO1667W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.include", unmatchedInclude});
        }
        ArrayList<ModuleName> excludedNotYetSeen = new ArrayList<ModuleName>(config.excluded);
        Iterator iterator3 = excludedNotYetSeen.iterator();
        block6: while (iterator3.hasNext()) {
            ModuleName moduleName = (ModuleName)iterator3.next();
            for (ModuleInfo moduleInfo : moduleInfos) {
                if (!this.matches(moduleName, moduleInfo, config)) continue;
                iterator3.remove();
                continue block6;
            }
        }
        HashMap<ModuleName, String> excludedNotYetSeenButSeenUnderOldNaming = new HashMap<ModuleName, String>();
        if (config.serverxmlmode) {
            Iterator iterator2 = excludedNotYetSeen.iterator();
            block8: while (iterator2.hasNext()) {
                ModuleName moduleName = (ModuleName)iterator2.next();
                for (ModuleInfo moduleInfo : moduleInfos) {
                    if (!ModuleSelectionConfigImpl.matches(moduleName, moduleInfo, MatchingMode.DEPLOYMENT_DESCRIPTOR_NAME)) continue;
                    excludedNotYetSeenButSeenUnderOldNaming.put(moduleName, moduleInfo.getApplicationInfo().getDeploymentName());
                    iterator2.remove();
                    continue block8;
                }
            }
            for (ModuleName moduleName : excludedNotYetSeenButSeenUnderOldNaming.keySet()) {
                String string = moduleName.moduleName != null ? "excludeModule" : "excludeApplication";
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_USING_WRONG_NAME_SOURCE_CWWKO1680W", (Object[])new Object[]{string, moduleName.appName, excludedNotYetSeenButSeenUnderOldNaming.get(moduleName)});
            }
        }
    }

    protected InclusionMode getDefaultInclusion() {
        return InclusionMode.FIRST;
    }

    private boolean matches(ModuleName name, ModuleInfo module, ConfigValues config) {
        return ModuleSelectionConfigImpl.matches(name, module, config.serverxmlmode ? MatchingMode.SERVER_XML_NAME : MatchingMode.DEPLOYMENT_DESCRIPTOR_NAME);
    }

    private static boolean matches(ModuleName name, ModuleInfo module, MatchingMode matchingMode) {
        if (name.moduleName != null && !name.moduleName.equals(module.getName())) {
            return false;
        }
        return !(matchingMode == MatchingMode.SERVER_XML_NAME ? !name.appName.equals(module.getApplicationInfo().getDeploymentName()) : !name.appName.equals(module.getApplicationInfo().getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processConfigUpdate() {
        ModuleSelectionConfigImpl moduleSelectionConfigImpl = this;
        synchronized (moduleSelectionConfigImpl) {
            this.configValues = null;
        }
    }

    private static List<ModuleName> parseModuleNames(String nameList, String configKey, WarningMode warningMode) {
        ArrayList<ModuleName> result = new ArrayList<ModuleName>();
        for (String configValuePart : nameList.split(",")) {
            Optional<ModuleName> processedName = ModuleSelectionConfigImpl.parseModuleName(configValuePart, configKey, warningMode);
            processedName.ifPresent(result::add);
        }
        return result;
    }

    private static Optional<ModuleName> parseModuleName(String name, String configKey, WarningMode warningMode) {
        Matcher m = CONFIG_VALUE_NAME_REFERENCE.matcher(name);
        if (!m.matches()) {
            if (warningMode == WarningMode.LOG_WARNINGS) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INVALID_NAME_CWWKO1666W", (Object[])new Object[]{configKey, name});
            }
            return Optional.empty();
        }
        String appName = m.group(1).trim();
        String moduleName = m.group(3);
        if (moduleName != null) {
            moduleName = moduleName.trim();
        }
        return Optional.of(new ModuleName(appName, moduleName));
    }

    public int getConfigListenerPriority() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigValues getConfigValues() {
        ModuleSelectionConfigImpl moduleSelectionConfigImpl = this;
        synchronized (moduleSelectionConfigImpl) {
            if (this.configValues == null) {
                this.configValues = this.readConfigValues();
            }
            return this.configValues;
        }
    }

    private ConfigValues readConfigValues() {
        Optional<ConfigValues> fromMpConfig;
        Config mpConfig = ConfigProvider.getConfig((ClassLoader)ModuleSelectionConfigImpl.class.getClassLoader());
        Optional<ConfigValues> fromServerXml = this.readFromServerXml();
        if (fromServerXml.isPresent() && (fromMpConfig = this.readFromMpConfig(mpConfig, WarningMode.SUPPRESS_WARNINGS)).isPresent()) {
            this.warnMpConfigIgnored(fromServerXml.get(), fromMpConfig.get(), mpConfig);
        }
        return fromServerXml.orElseGet(() -> this.readFromMpConfig(mpConfig, WarningMode.LOG_WARNINGS).orElse(this.getDefaultConfig()));
    }

    private ConfigValues getDefaultConfig() {
        return new ConfigValues(this.getDefaultInclusion(), false, Collections.emptyList(), Collections.emptyList());
    }

    private void warnMpConfigIgnored(ConfigValues fromServerXml, ConfigValues fromMpConfig, Config mpConfig) {
        Stream<String> propertiesInUse = Stream.of("mp.openapi.extensions.liberty.merged.include", "mp.openapi.extensions.liberty.merged.exclude").filter(prop -> mpConfig.getOptionalValue(prop, String.class).isPresent());
        if (fromServerXml.equivalentTo(fromMpConfig)) {
            propertiesInUse.forEach(prop -> Tr.info((TraceComponent)tc, (String)"OPENAPI_MP_CONFIG_REDUNDANT_CWWKO1685I", (Object[])new Object[]{prop}));
        } else {
            propertiesInUse.forEach(prop -> Tr.warning((TraceComponent)tc, (String)"OPENAPI_MP_CONFIG_CONFLICTS_CWWKO1686W", (Object[])new Object[]{prop}));
        }
    }

    private Optional<ConfigValues> readFromServerXml() {
        OpenAPIServerXMLConfig configFromServerXML = this.configFromServerXMLProvider.getConfiguration();
        if (!configFromServerXML.wasAnyConfigFound()) {
            return Optional.empty();
        }
        InclusionMode inclusionMode = configFromServerXML.getConfigMode().map(configMode -> {
            if (configMode == OpenAPIServerXMLConfig.ConfigMode.All) {
                return InclusionMode.ALL;
            }
            if (configMode == OpenAPIServerXMLConfig.ConfigMode.First) {
                return InclusionMode.FIRST;
            }
            if (configMode == OpenAPIServerXMLConfig.ConfigMode.None) {
                return InclusionMode.NONE;
            }
            throw new IllegalArgumentException("configMode");
        }).orElseGet(() -> configFromServerXML.getIncludedAppsAndModules().isPresent() ? InclusionMode.NORMAL : this.getDefaultInclusion());
        List<ModuleName> included = inclusionMode == InclusionMode.NORMAL ? configFromServerXML.getIncludedAppsAndModules().map(rawNames -> rawNames.stream().map(rawName -> ModuleSelectionConfigImpl.parseModuleName(rawName, "mp.openapi.extensions.liberty.merged.include", WarningMode.LOG_WARNINGS)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList()) : Collections.emptyList();
        List<ModuleName> excluded = configFromServerXML.getExcludedAppsAndModules().map(rawNames -> rawNames.stream().map(rawName -> ModuleSelectionConfigImpl.parseModuleName(rawName, "mp.openapi.extensions.liberty.merged.include", WarningMode.LOG_WARNINGS)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(Collections.emptyList());
        return Optional.of(new ConfigValues(inclusionMode, true, included, excluded));
    }

    private Optional<ConfigValues> readFromMpConfig(Config configFromMPConfig, WarningMode warningMode) {
        Optional inclusionProperty = configFromMPConfig.getOptionalValue("mp.openapi.extensions.liberty.merged.include", String.class);
        Optional exclusionProperty = configFromMPConfig.getOptionalValue("mp.openapi.extensions.liberty.merged.exclude", String.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Inclusion read from config: " + inclusionProperty), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Exclusion read from config: " + exclusionProperty), (Object[])new Object[0]);
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Names in config: " + configFromMPConfig.getPropertyNames()), (Object[])new Object[0]);
        }
        if (!inclusionProperty.isPresent() && !exclusionProperty.isPresent()) {
            return Optional.empty();
        }
        InclusionMode inclusionMode = inclusionProperty.map(inclusion -> {
            if (inclusion.equals("none")) {
                return InclusionMode.NONE;
            }
            if (inclusion.equals("all")) {
                return InclusionMode.ALL;
            }
            if (inclusion.equals("first")) {
                return InclusionMode.FIRST;
            }
            return InclusionMode.NORMAL;
        }).orElseGet(this::getDefaultInclusion);
        List<ModuleName> included = inclusionMode == InclusionMode.NORMAL ? ModuleSelectionConfigImpl.parseModuleNames(inclusionProperty.orElse(""), "mp.openapi.extensions.liberty.merged.include", warningMode) : Collections.emptyList();
        String exclusion = exclusionProperty.orElse("none").trim();
        List<Object> excluded = exclusion.equals("none") ? Collections.emptyList() : ModuleSelectionConfigImpl.parseModuleNames(exclusion, "mp.openapi.extensions.liberty.merged.exclude", warningMode);
        return Optional.of(new ConfigValues(inclusionMode, false, included, excluded));
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConfigValues {
        protected final InclusionMode inclusionMode;
        protected final boolean serverxmlmode;
        protected final List<ModuleName> included;
        protected final List<ModuleName> excluded;
        static final long serialVersionUID = -3325660062724137621L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConfigValues(InclusionMode inclusionMode, boolean serverxmlmode, List<ModuleName> included, List<ModuleName> excluded) {
            if (inclusionMode != InclusionMode.NORMAL && !included.isEmpty()) {
                throw new IllegalStateException("InclusionMode = " + (Object)((Object)inclusionMode) + ", included = " + included);
            }
            this.inclusionMode = inclusionMode;
            this.serverxmlmode = serverxmlmode;
            this.included = included;
            this.excluded = excluded;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ConfigValues [inclusionMode=");
            builder.append((Object)this.inclusionMode);
            builder.append(", serverxmlmode=");
            builder.append(this.serverxmlmode);
            builder.append(", included=");
            builder.append(this.included);
            builder.append(", excluded=");
            builder.append(this.excluded);
            builder.append("]");
            return builder.toString();
        }

        public boolean equivalentTo(ConfigValues other) {
            return Objects.equals(new HashSet<ModuleName>(this.excluded), new HashSet<ModuleName>(other.excluded)) && Objects.equals(new HashSet<ModuleName>(this.included), new HashSet<ModuleName>(other.included)) && ConfigValues.equivalent(this.inclusionMode, other.inclusionMode);
        }

        private static boolean equivalent(InclusionMode a, InclusionMode b) {
            InclusionMode aNormal = a == InclusionMode.NONE ? InclusionMode.NORMAL : a;
            InclusionMode bNormal = b == InclusionMode.NONE ? InclusionMode.NORMAL : b;
            return aNormal == bNormal;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.ModuleSelectionConfigImpl$ConfigValues", ConfigValues.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }

    protected static enum InclusionMode {
        ALL,
        FIRST,
        NONE,
        NORMAL;

    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ModuleName {
        private final String appName;
        private final String moduleName;
        static final long serialVersionUID = 2781297176937083229L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModuleName(String appName, String moduleName) {
            this.appName = appName;
            this.moduleName = moduleName;
        }

        public String toString() {
            if (this.moduleName == null) {
                return this.appName;
            }
            return this.appName + "/" + this.moduleName;
        }

        public int hashCode() {
            return Objects.hash(this.appName, this.moduleName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModuleName other = (ModuleName)obj;
            return Objects.equals(this.appName, other.appName) && Objects.equals(this.moduleName, other.moduleName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.ModuleSelectionConfigImpl$ModuleName", ModuleName.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }

    private static enum MatchingMode {
        SERVER_XML_NAME,
        DEPLOYMENT_DESCRIPTOR_NAME;

    }

    private static enum WarningMode {
        LOG_WARNINGS,
        SUPPRESS_WARNINGS;

    }
}

