/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.services.ConfigField;
import io.openliberty.microprofile.openapi20.internal.services.ConfigFieldProvider;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.OpenApiConfigImpl;
import java.io.Closeable;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigProcessor
implements Closeable {
    private static final TraceComponent tc = Tr.register(ConfigProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final String VALIDATION = "mp.openapi.extensions.liberty.validation";
    private static final boolean VALIDATION_DEFAULT_VALUE = true;
    private boolean validation = true;
    private static final String FILE_POLLING_INTERVAL = "mp.openapi.extensions.liberty.file.polling.interval";
    private static final int FILE_POLLING_INTERVAL_DEFAULT_VALUE = 2;
    private int pollingInterval = 2;
    private Config oaConfig;
    private final OpenApiConfigImpl smallryeConfig;
    private final ConfigFieldProvider configFieldProvider;
    static final long serialVersionUID = 366600383490274520L;

    public ConfigProcessor(ClassLoader appClassloader, ConfigFieldProvider configFieldProvider) {
        this.oaConfig = ConfigProvider.getConfig((ClassLoader)appClassloader);
        this.smallryeConfig = new OpenApiConfigImpl(this.oaConfig);
        this.configFieldProvider = configFieldProvider;
        this.validation = this.oaConfig.getOptionalValue(VALIDATION, Boolean.class).orElse(true);
        this.pollingInterval = this.oaConfig.getOptionalValue(FILE_POLLING_INTERVAL, Integer.class).filter(v -> v >= 0).orElse(2);
    }

    public OpenApiConfig getOpenAPIConfig() {
        return this.smallryeConfig;
    }

    public boolean isValidating() {
        return this.validation;
    }

    public int getFilePollingInterval() {
        return this.pollingInterval;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block3: {
            try {
                if (Closeable.class.isAssignableFrom(this.oaConfig.getClass())) {
                    ((Closeable)this.oaConfig).close();
                    this.oaConfig = null;
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.microprofile.openapi20.internal.ConfigProcessor", (String)"91", (Object)this, (Object[])new Object[0]);
                if (!LoggingUtils.isEventEnabled(tc)) break block3;
                Tr.event((TraceComponent)tc, (String)("Failed to close config: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ConfigProcessor : {\n");
        for (ConfigField field : this.configFieldProvider.getConfigFields()) {
            builder.append(field.getProperty()).append("=").append(field.getValue((OpenApiConfig)this.smallryeConfig)).append("\n");
        }
        builder.append(VALIDATION).append("=").append(this.validation).append("\n");
        builder.append(FILE_POLLING_INTERVAL).append("=").append(this.pollingInterval).append("\n");
        builder.append("}\n");
        return builder.toString();
    }
}

