/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.transactions.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.ProtocolException;
import com.ibm.ws.sib.msgstore.RollbackException;
import com.ibm.ws.sib.msgstore.SeverePersistenceException;
import com.ibm.ws.sib.msgstore.TransactionException;
import com.ibm.ws.sib.msgstore.XidAlreadyKnownException;
import com.ibm.ws.sib.msgstore.XidStillAssociatedException;
import com.ibm.ws.sib.msgstore.XidUnknownException;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.transactions.ExternalXAResource;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistenceManager;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionParticipant;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkItem;
import com.ibm.ws.sib.msgstore.transactions.impl.WorkList;
import com.ibm.ws.sib.msgstore.transactions.impl.XidManager;
import com.ibm.ws.sib.msgstore.transactions.impl.XidParticipant;
import com.ibm.ws.sib.transactions.PersistentTranId;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MSDelegatingXAResource
implements ExternalXAResource,
PersistentTransaction {
    private static TraceComponent tc = SibTr.register(MSDelegatingXAResource.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private MessageStoreImpl _ms;
    private JsMessagingEngine _me;
    private PersistenceManager _persistence;
    private PersistentTranId _currentPtid;
    private TransactionParticipant _currentTran;
    private XidManager _manager;
    private int _maxSize;
    private BatchingContext _bc;

    public MSDelegatingXAResource(MessageStoreImpl ms, PersistenceManager persistence, int maxSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"MSDelegatingXAResource", (Object)("MessageStore=" + (Object)((Object)ms) + ", Persistence=" + persistence + ", MaxSize=" + maxSize));
        }
        this._ms = ms;
        this._manager = ms.getXidManager();
        this._persistence = persistence;
        this._maxSize = maxSize;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"MSDelegatingXAResource");
        }
    }

    @Override
    public synchronized void addWork(WorkItem item) throws ProtocolException, TransactionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addWork", (Object)("WorkItem=" + item));
        }
        if (this._currentTran == null) {
            ProtocolException pe = new ProtocolException("TRAN_PROTOCOL_ERROR_SIMS1001");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"No Xid currently associated with this XAResource!", (Object)pe);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
            }
            throw pe;
        }
        this._currentTran.addWork(item);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addWork");
        }
    }

    @Override
    public WorkList getWorkList() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWorkList");
        }
        WorkList workList = null;
        if (this._currentTran != null) {
            workList = this._currentTran.getWorkList();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getWorkList", (Object)("return=" + workList));
        }
        return workList;
    }

    public void registerCallback(TransactionCallback callback) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"registerCallback", (Object)("Callback=" + callback));
        }
        if (this._currentTran != null) {
            this._currentTran.registerCallback(callback);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"No Xid currently associated with this XAResource!");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"registerCallback");
        }
    }

    public final boolean isAutoCommit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAutoCommit");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAutoCommit", (Object)"return=false");
        }
        return false;
    }

    public boolean hasSubordinates() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasSubordinates");
        }
        boolean retval = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasSubordinates", (Object)("return=" + retval));
        }
        return retval;
    }

    public PersistentTranId getPersistentTranId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistentTranId");
        }
        PersistentTranId ptid = null;
        if (this._currentTran != null) {
            ptid = this._currentTran.getPersistentTranId();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistentTranId", (Object)("return=" + ptid));
        }
        return ptid;
    }

    public void incrementCurrentSize() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementCurrentSize");
        }
        if (this._currentTran != null) {
            this._currentTran.incrementCurrentSize();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementCurrentSize");
        }
    }

    public boolean isAlive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isAlive");
        }
        boolean retval = false;
        if (this._currentTran != null) {
            retval = this._currentTran.isAlive();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isAlive", (Object)("return=" + retval));
        }
        return retval;
    }

    public void start(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object)new Object[]{"XID=" + xid, this._manager.xaFlagsToString(flags)});
        }
        if (this._currentTran != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot associate with XAResource. It is already associated with an Xid!", (Object)("CurrentXID=" + this._currentPtid));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            throw new XAException(-6);
        }
        try {
            this._currentPtid = new PersistentTranId(xid);
            if (flags == 0) {
                this._currentTran = new XidParticipant(this._ms, this._currentPtid, this._persistence, this._maxSize);
                this._manager.start(this._currentPtid, this._currentTran);
            } else {
                this._currentTran = this._manager.start(this._currentPtid, flags);
            }
        }
        catch (XidUnknownException xue) {
            FFDCFilter.processException((Throwable)xue, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.start", (String)"1:316:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot TMJOIN with this Xid. It is not known!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(xue);
            throw xaException;
        }
        catch (XidAlreadyKnownException xake) {
            FFDCFilter.processException((Throwable)xake, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.start", (String)"1:325:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot start new association with this Xid. It is already known!", (Object)((Object)xake));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            XAException xaException = new XAException(-8);
            xaException.initCause(xake);
            throw xaException;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.start", (String)"1:334:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected exception caught during transaction association!", (Object)e);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
            }
            XAException xaException = new XAException(-3);
            xaException.initCause(e);
            throw xaException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object)new Object[]{"XID=" + xid, this._manager.xaFlagsToString(flags)});
        }
        try {
            this._manager.end(new PersistentTranId(xid), flags);
            this._currentTran = null;
            this._currentPtid = null;
        }
        catch (XidUnknownException xue) {
            FFDCFilter.processException((Throwable)xue, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.end", (String)"1:375:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot dis-associate from this Xid. It is unknown!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
            }
            XAException xaException = new XAException(-4);
            xaException.initCause(xue);
            throw xaException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object)("XID=" + xid));
        }
        int retval = 0;
        try {
            retval = this._manager.prepare(new PersistentTranId(xid));
        }
        catch (XidStillAssociatedException xsae) {
            FFDCFilter.processException((Throwable)xsae, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:421:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot prepare transaction branch, resources are still associated with this Xid!", (Object)((Object)xsae));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(xsae);
            throw xaException;
        }
        catch (XidUnknownException xue) {
            FFDCFilter.processException((Throwable)xue, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:430:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot prepare transaction branch, Xid is unknown!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(-4);
            xaException.initCause(xue);
            throw xaException;
        }
        catch (ProtocolException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:439:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"A Transaction protocol error occurred during prepare of transaction branch!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(pe);
            throw xaException;
        }
        catch (RollbackException rbe) {
            FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:448:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"RollbackException caught during prepare of transaction branch!", (Object)((Object)rbe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(100);
            xaException.initCause(rbe);
            throw xaException;
        }
        catch (SeverePersistenceException spe) {
            FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:463:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)spe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(spe);
            throw xaException;
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)te, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.prepare", (String)"1:472:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"TransactionException occurred whilst preparing transaction work!", (Object)((Object)te));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(te);
            throw xaException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String retstr;
            switch (retval) {
                case 0: {
                    retstr = "return=XA_OK";
                    break;
                }
                case 3: {
                    retstr = "return=XA_RDONLY";
                    break;
                }
                default: {
                    retstr = "return=XA_UNKNOWN";
                }
            }
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"prepare", (Object)retstr);
        }
        return retval;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object)("XID=" + xid + ", OnePhase=" + onePhase));
        }
        try {
            this._manager.commit(new PersistentTranId(xid), onePhase);
        }
        catch (XidUnknownException xue) {
            FFDCFilter.processException((Throwable)xue, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:536:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot commit transaction branch, Xid is unknown!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(-4);
            xaException.initCause(xue);
            throw xaException;
        }
        catch (XidStillAssociatedException xsae) {
            FFDCFilter.processException((Throwable)xsae, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:545:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot commit transaction branch, resources are still associated with this Xid!", (Object)((Object)xsae));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(xsae);
            throw xaException;
        }
        catch (ProtocolException tpe) {
            FFDCFilter.processException((Throwable)tpe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:554:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"A Transaction protocol error occurred during prepare of transaction branch!", (Object)((Object)tpe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(tpe);
            throw xaException;
        }
        catch (RollbackException rbe) {
            FFDCFilter.processException((Throwable)rbe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:563:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"RollbackException caught during commit of transaction branch!", (Object)((Object)rbe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(100);
            xaException.initCause(rbe);
            throw xaException;
        }
        catch (SeverePersistenceException spe) {
            FFDCFilter.processException((Throwable)spe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:582:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred during commit of transaction branch!", (Object)((Object)spe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(spe);
            throw xaException;
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:591:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(4);
            xaException.initCause(pe);
            throw xaException;
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)te, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.commit", (String)"1:600:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred during commit of transaction branch!", (Object)((Object)te));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(te);
            throw xaException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object)("XID=" + xid));
        }
        try {
            this._manager.rollback(new PersistentTranId(xid));
        }
        catch (XidUnknownException xue) {
            FFDCFilter.processException((Throwable)xue, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"1:640:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot rollback transaction branch, Xid is unknown!", (Object)((Object)xue));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            XAException xaException = new XAException(-4);
            xaException.initCause(xue);
            throw xaException;
        }
        catch (XidStillAssociatedException xsae) {
            FFDCFilter.processException((Throwable)xsae, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"1:649:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Cannot rollback transaction branch, resources are still associated with this Xid!", (Object)((Object)xsae));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(xsae);
            throw xaException;
        }
        catch (ProtocolException tpe) {
            FFDCFilter.processException((Throwable)tpe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"1:658:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"A Transaction protocol error occurred during rollback of transaction branch!", (Object)((Object)tpe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            XAException xaException = new XAException(-6);
            xaException.initCause(tpe);
            throw xaException;
        }
        catch (TransactionException te) {
            FFDCFilter.processException((Throwable)te, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"1:667:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred during rollback of transaction branch!", (Object)((Object)te));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(te);
            throw xaException;
        }
        catch (PersistenceException pe) {
            FFDCFilter.processException((Throwable)pe, (String)"com.ibm.ws.sib.msgstore.transactions.MSDelegatingXAResource.rollback", (String)"1:676:1.51.1.7", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((Object)this, (TraceComponent)tc, (String)"Unexpected error occurred whilst persisting transaction work!", (Object)((Object)pe));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(pe);
            throw xaException;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }

    public Xid[] recover(int recoveryId) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object)("Recovery ID=" + recoveryId));
        }
        Object[] list = this._manager.recover();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"recover", (Object)("return=" + Arrays.toString(list)));
        }
        return list;
    }

    public void forget(Xid xid) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object)("XID=" + xid));
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object)"return=0");
        }
        return 0;
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)("Timeout=" + timeout));
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object)"return=false");
        }
        return false;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)("Resource=" + resource));
        }
        boolean retval = false;
        if (resource != null && resource instanceof MSDelegatingXAResource) {
            MSDelegatingXAResource msResource = (MSDelegatingXAResource)((Object)resource);
            if (this._me == null) {
                this._me = this._ms._getMessagingEngine();
            }
            JsMessagingEngine ME = msResource._ms._getMessagingEngine();
            if (this._me != null && ME != null) {
                if (this._me.getUuid().equals(ME.getUuid())) {
                    retval = true;
                }
            } else {
                retval = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"MessagingEngine reference is null so using weaker isSameRM test!");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object)("return=" + retval));
        }
        return retval;
    }

    @Override
    public final int getTransactionType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionType");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionType", (Object)"return=TX_GLOBAL");
        }
        return 2;
    }

    @Override
    public void setTransactionState(TransactionState state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionState", (Object)("State=" + state));
        }
        if (this._currentTran != null) {
            this._currentTran.setTransactionState(state);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionState");
        }
    }

    @Override
    public TransactionState getTransactionState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionState");
        }
        TransactionState retval = this._currentTran != null ? this._currentTran.getTransactionState() : TransactionState.STATE_NONE;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionState", (Object)("return=" + retval));
        }
        return retval;
    }

    @Override
    public BatchingContext getBatchingContext() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatchingContext");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatchingContext", (Object)("return=" + this._bc));
        }
        return this._bc;
    }

    @Override
    public void setBatchingContext(BatchingContext bc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setBatchingContext", (Object)("BatchingContext=" + bc));
        }
        this._bc = bc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setBatchingContext");
        }
    }

    @Override
    public MessageStore getOwningMessageStore() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getOwningMessageStore", (Object)("return=" + (Object)((Object)this._ms)));
        }
        return this._ms;
    }

    public boolean isEnlisted() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEnlisted");
        }
        boolean retval = false;
        if (this._currentTran != null) {
            retval = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEnlisted", (Object)("return=" + retval));
        }
        return retval;
    }

    public int hashCode() {
        int hash = 0;
        hash = this._currentTran != null ? this._currentTran.hashCode() : super.hashCode();
        return hash;
    }
}

