/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.task;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.LinkOwner;
import com.ibm.ws.sib.msgstore.persistence.BatchingContext;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.task.Task;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.msgstore.transactions.impl.TransactionState;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class AbstractRemoveTask
extends Task {
    private static TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.msgstore.CWSISMessages");
    private static TraceComponent tc = SibTr.register(AbstractRemoveTask.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    public AbstractRemoveTask(AbstractItemLink link) throws SevereMessageStoreException {
        super(link);
    }

    @Override
    public final void abort(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abort", (Object)transaction);
        }
        this.getLink().abortRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abort");
        }
    }

    @Override
    public final void commitExternal(PersistentTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitExternal", (Object)transaction);
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitExternal");
        }
    }

    @Override
    public final void commitInternal(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"commitInternal", (Object)transaction);
        }
        this.getLink().commitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"commitInternal");
        }
    }

    @Override
    public final int getPersistableInMemorySizeApproximation(TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)tranState);
        }
        if (tranState != TransactionState.STATE_COMMITTED && tranState != TransactionState.STATE_COMMITTING_1PC && tranState != TransactionState.STATE_COMMITTING_2PC && tranState != TransactionState.STATE_PREPARED && tranState != TransactionState.STATE_PREPARING && tranState != TransactionState.STATE_ROLLEDBACK && tranState != TransactionState.STATE_ROLLINGBACK) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        int size = 500 + this.getPersistable().getInMemoryByteSize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getPersistableInMemorySizeApproximation", (Object)size);
        }
        return size;
    }

    @Override
    public Task.Type getTaskType() {
        return Task.Type.REMOVE;
    }

    @Override
    public boolean isDeleteOfPersistentRepresentation() {
        return true;
    }

    @Override
    public final boolean isRemoveFromList(LinkOwner list) {
        LinkOwner myList;
        boolean is;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isRemoveFromList");
        }
        boolean bl = is = (myList = this.getLink().getOwningStreamLink()) == list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isRemoveFromList", (Object)is);
        }
        return is;
    }

    @Override
    public final void persist(BatchingContext batchingContext, TransactionState tranState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"persist", (Object)new Object[]{batchingContext, tranState});
        }
        if (tranState == TransactionState.STATE_COMMITTED || tranState == TransactionState.STATE_COMMITTING_1PC || tranState == TransactionState.STATE_COMMITTING_2PC) {
            batchingContext.delete(this.getPersistable());
        } else if (tranState == TransactionState.STATE_PREPARED || tranState == TransactionState.STATE_PREPARING) {
            Persistable tuple = this.getPersistable();
            tuple.setLogicallyDeleted(true);
            batchingContext.updateLogicalDeleteAndXID(tuple);
        } else if (tranState == TransactionState.STATE_ROLLEDBACK || tranState == TransactionState.STATE_ROLLINGBACK) {
            Persistable tuple = this.getPersistable();
            tuple.setLogicallyDeleted(false);
            batchingContext.updateLogicalDeleteAndXID(tuple);
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INVALID_TASK_OPERATION_SIMS1520", new Object[]{tranState}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"persist");
        }
    }

    @Override
    public final void postAbort(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postAbort", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostRollbackRemove((Transaction)transaction);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postAbort");
        }
    }

    @Override
    public final void postCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        AbstractItem item;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"postCommit", (Object)transaction);
        }
        if (null == (item = this.getItem())) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"null item");
            }
        } else {
            item.eventPostCommitRemove((Transaction)transaction);
        }
        this.getLink().postCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"postCommit");
        }
    }

    @Override
    public final void preCommit(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"preCommit", (Object)transaction);
        }
        this.getItem();
        this.getLink().preCommitRemove(transaction);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"preCommit");
        }
    }
}

