/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.impl;

import com.ibm.ws.sib.msgstore.XmlConstants;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.impl.Map;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class MultiHashMap
implements Map,
XmlConstants {
    private final int _subMapCount;
    private final SubMap[] _subMaps;

    public MultiHashMap(int subMapCount) {
        this._subMapCount = subMapCount;
        this._subMaps = new SubMap[this._subMapCount];
        for (int i = 0; i < this._subMaps.length; ++i) {
            this._subMaps[i] = new SubMap();
        }
    }

    private final SubMap _subMap(long key) {
        return this._subMaps[(int)Math.abs(key) % this._subMapCount];
    }

    @Override
    public final AbstractItemLink get(long key) {
        return (AbstractItemLink)this._subMap(key).get(key);
    }

    @Override
    public final void put(long key, AbstractItemLink value) {
        this._subMap(key).put(key, value);
    }

    @Override
    public final AbstractItemLink remove(long key) {
        return (AbstractItemLink)this._subMap(key).remove(key);
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this._subMaps.length; ++i) {
            this._subMaps[i].clear();
        }
    }

    @Override
    public void xmlWriteOn(FormattedWriter writer) throws IOException {
        writer.newLine();
        writer.startTag("itemMap");
        writer.indent();
        for (int i = 0; i < this._subMaps.length; ++i) {
            Iterator iterator = this._subMaps[i].values().iterator();
            while (iterator.hasNext()) {
                writer.newLine();
                AbstractItemLink ail = (AbstractItemLink)iterator.next();
                ail.xmlShortWriteOn(writer);
            }
        }
        writer.outdent();
        writer.newLine();
        writer.endTag("itemMap");
    }

    private static final class SubMap
    extends HashMap {
        private static final long serialVersionUID = -4648138397952456765L;

        private SubMap() {
        }

        private final synchronized Object get(long key) {
            return this.get((Object)key);
        }

        @Override
        private final synchronized Object put(long key, Object value) {
            return this.put(Long.valueOf(key), value);
        }

        private final synchronized Object remove(long key) {
            return this.remove((Object)key);
        }
    }
}

