/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.DummyManagedObject;
import com.ibm.ws.objectManager.InternalTransaction;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.LogicalUnitOfWork;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.IOException;

class TransactionDeleteLogRecord
extends LogRecord {
    private static final Class cclass = TransactionDeleteLogRecord.class;
    private static Trace trace = ObjectManager.traceFactory.getTrace(cclass, "ObjectManagerTransactions");
    private static final long serialVersionUID = 7265650043809552318L;
    private LogicalUnitOfWork logicalUnitOfWork;
    private int transactionState;
    private Token token;

    protected TransactionDeleteLogRecord(InternalTransaction internalTransaction, Token token) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{internalTransaction, token});
        }
        this.logicalUnitOfWork = internalTransaction.getLogicalUnitOfWork();
        this.transactionState = internalTransaction.getState();
        this.token = token;
        this.buffers = this.getBuffers(internalTransaction.logRecordByteArrayOutputStream);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected TransactionDeleteLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            this.logicalUnitOfWork = new LogicalUnitOfWork(dataInputStream);
            this.transactionState = dataInputStream.readInt();
            this.token = Token.restore(dataInputStream, objectManagerState);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:100:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "<init>", exception);
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    private ObjectManagerByteArrayOutputStream[] getBuffers(ObjectManagerByteArrayOutputStream byteArrayOutputStream) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getBuffers", new Object[]{byteArrayOutputStream});
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[1];
        byteArrayOutputStream.reset();
        buffers[0] = byteArrayOutputStream;
        buffers[0].writeInt(4);
        this.logicalUnitOfWork.writeSerializedBytes(buffers[0]);
        buffers[0].writeInt(this.transactionState);
        this.token.writeSerializedBytes(buffers[0]);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", new Object[]{objectManagerState, this.logicalUnitOfWork, new Integer(this.transactionState), this.token});
        }
        Transaction transactionForRecovery = objectManagerState.getTransaction(this.logicalUnitOfWork);
        ManagedObject existingManagedObject = this.token.getManagedObject();
        if (existingManagedObject == null) {
            DummyManagedObject dummyManagedObject = new DummyManagedObject("Created by TransactionDeleteLogRecord.performRecovery()");
            existingManagedObject = this.token.setManagedObject(dummyManagedObject);
            existingManagedObject.state = 8;
        }
        transactionForRecovery.delete(existingManagedObject);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }

    protected static long maximumSerializedSize() {
        return 4L + LogicalUnitOfWork.maximumSerializedSize() + 4L + Token.maximumSerializedSize();
    }
}

