/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.ManagedObject;
import com.ibm.ws.objectManager.ObjectManager;
import com.ibm.ws.objectManager.ObjectManagerByteArrayOutputStream;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.PermanentIOException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.DataInputStream;
import java.io.IOException;

class CheckpointStartLogRecord
extends LogRecord {
    private static final Class cclass = CheckpointStartLogRecord.class;
    private static final long serialVersionUID = 971589238651066798L;
    private static Trace trace = ObjectManager.traceFactory.getTrace(CheckpointStartLogRecord.class, "ObjectManagerTransactions");
    protected Token objectManagerStateToken;
    protected byte[] objectManagerStateBytes;
    ObjectManagerByteArrayOutputStream serializedBytes;

    protected CheckpointStartLogRecord(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{objectManagerState});
        }
        this.objectManagerStateToken = objectManagerState.getToken();
        this.serializedBytes = objectManagerState.getSerializedBytes();
        this.buffers = this.getBuffers();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    protected CheckpointStartLogRecord(DataInputStream dataInputStream, ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{dataInputStream, objectManagerState});
        }
        try {
            this.objectManagerStateToken = Token.restore(dataInputStream, objectManagerState);
            long objectManagerStateBytesLength = dataInputStream.readLong();
            this.objectManagerStateBytes = new byte[(int)objectManagerStateBytesLength];
            dataInputStream.read(this.objectManagerStateBytes);
        }
        catch (IOException exception) {
            ObjectManager.ffdc.processException(this, cclass, "<init>", exception, "1:104:1.8");
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit(this, cclass, "<init> via PermanentIOExceptionexception=" + exception + "(java.io.IOException)");
            }
            throw new PermanentIOException((Object)this, exception);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    @Override
    public ObjectManagerByteArrayOutputStream[] getBuffers() throws ObjectManagerException {
        String methodName = "getBuffers";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getBuffers");
        }
        ObjectManagerByteArrayOutputStream[] buffers = new ObjectManagerByteArrayOutputStream[2];
        buffers[0] = new ObjectManagerByteArrayOutputStream((int)(4L + Token.maximumSerializedSize() + 8L));
        buffers[0].writeInt(8);
        this.objectManagerStateToken.writeSerializedBytes(buffers[0]);
        buffers[0].writeLong(this.serializedBytes.getCount());
        buffers[1] = this.objectManagerStateToken.getManagedObject().getSerializedBytes();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getBuffers", new Object[]{buffers});
        }
        return buffers;
    }

    @Override
    public void performRecovery(ObjectManagerState objectManagerState) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "performRecovery", objectManagerState);
        }
        ObjectManagerState recoveredObjectManagerState = (ObjectManagerState)ManagedObject.restoreFromSerializedBytes(this.objectManagerStateBytes, objectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            trace.debug(this, cclass, "recoveredObjectManagerState=" + recoveredObjectManagerState + "(ObjectManagerState)");
        }
        this.objectManagerStateToken.setManagedObject(recoveredObjectManagerState);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "performRecovery");
        }
    }
}

