/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.PeerLeaseData;
import java.util.ArrayList;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PeerLeaseTable {
    private static final TraceComponent tc = Tr.register(PeerLeaseTable.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected final ArrayList<PeerLeaseData> _peerLeaseTable = new ArrayList();
    private static HashMap<String, Integer> _expiryCounts = new HashMap();
    static final long serialVersionUID = 8555422199438478969L;

    public void addPeerEntry(PeerLeaseData leaseData) {
        this._peerLeaseTable.add(leaseData);
    }

    @ManualTrace
    public ArrayList<String> getExpiredPeers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getExpiredPeers", (Object[])new Object[0]);
        }
        ArrayList<String> expiredPeers = new ArrayList<String>();
        for (PeerLeaseData p : this._peerLeaseTable) {
            if (!p.isExpired()) continue;
            expiredPeers.add(p.getRecoveryIdentity());
        }
        _expiryCounts.keySet().retainAll(expiredPeers);
        int expiryThreshold = ConfigurationProviderManager.getConfigurationProvider().getLeaseExpiryThreshold();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Expiry threshold: {0}, {1}", (Object[])new Object[]{expiryThreshold, _expiryCounts});
        }
        if (expiryThreshold > 1) {
            ArrayList<String> peersToRecover = new ArrayList<String>();
            for (String recoveryId : expiredPeers) {
                _expiryCounts.compute(recoveryId, (k, v) -> v == null ? 1 : v + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Expiry counts: {0}", (Object[])new Object[]{_expiryCounts});
                }
                if (_expiryCounts.get(recoveryId) < expiryThreshold) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Number of times {0} has been seen expired: {1}", (Object[])new Object[]{recoveryId, _expiryCounts.get(recoveryId)});
                }
                peersToRecover.add(recoveryId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getExpiredPeers", peersToRecover);
            }
            return peersToRecover;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getExpiredPeers", expiredPeers);
        }
        return expiredPeers;
    }

    @Trivial
    public int size() {
        return this._peerLeaseTable.size();
    }

    public void clear() {
        this._peerLeaseTable.clear();
    }
}

