/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.tx.util.Utils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import java.time.Instant;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PeerLeaseData {
    private static final TraceComponent tc = Tr.register(PeerLeaseData.class, (String)"Transaction", (String)"com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final String _recoveryIdentity;
    private final FileTime _leaseTime;
    private final Duration _leaseTimeout;
    static final long serialVersionUID = -564608023818162928L;

    @ManualTrace
    public PeerLeaseData(String recoveryIdentity, FileTime newleaseTime, int leaseTimeout) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"PeerLeaseData", (Object[])new Object[]{recoveryIdentity, Utils.traceTime((FileTime)newleaseTime), leaseTimeout});
        }
        this._recoveryIdentity = recoveryIdentity;
        this._leaseTime = newleaseTime;
        this._leaseTimeout = Duration.ofSeconds(leaseTimeout);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"PeerLeaseData");
        }
    }

    @Trivial
    public String getRecoveryIdentity() {
        return this._recoveryIdentity;
    }

    @Trivial
    public FileTime getLeaseTime() {
        return this._leaseTime;
    }

    @Trivial
    public boolean isExpired() {
        Instant now = Instant.now();
        if (now.isAfter(this._leaseTime.toInstant().plus(this._leaseTimeout))) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Lease for " + this._recoveryIdentity + " expired at " + Utils.traceTime((long)(this._leaseTime.toMillis() + this._leaseTimeout.toMillis()))), (Object[])new Object[0]);
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            long secondsLeft = now.plus(this._leaseTimeout).minusMillis(this._leaseTime.toMillis()).getEpochSecond();
            Tr.debug((TraceComponent)tc, (String)("Lease for " + this._recoveryIdentity + " has not expired. " + secondsLeft + " second" + (secondsLeft != 1L ? "s" : "") + " left."), (Object[])new Object[0]);
        }
        return false;
    }
}

