/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.runtime.DeliveryStreamType;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.processor.runtime.IndoubtAction;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPtoPOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.impl.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.HealthStateTree;
import com.ibm.ws.sib.processor.runtime.impl.QueuedMessage;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamControl;
import com.ibm.ws.sib.processor.runtime.impl.SourceStreamControllableIterator;
import com.ibm.ws.sib.processor.runtime.impl.TransmitMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;

public class SourceStreamSetControl
extends AbstractControlAdapter
implements SIMPPtoPOutboundTransmitControllable {
    private static final TraceComponent tc = SibTr.register(SourceStreamSetControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected StreamSet _streamSet;
    private SIBUuid12 _streamID;
    protected SourceStreamManager _sourceStreamManager;
    protected HealthState _healthState;

    public SourceStreamSetControl(SIBUuid8 remoteMEUuid, StreamSet streamSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStreamSetControl", (Object)new Object[]{remoteMEUuid, streamSet});
        }
        this._streamSet = streamSet;
        this._streamID = streamSet.getStreamID();
        this._sourceStreamManager = null;
        this._healthState = new HealthStateTree();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStreamSetControl", (Object)this);
        }
    }

    public void setSourceStreamManager(SourceStreamManager sourceStreamManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSourceStreamManager");
        }
        this._sourceStreamManager = sourceStreamManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setSourceStreamManager");
        }
    }

    public SIMPIterator getTransmitMessagesIterator(int maxMsgs) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessagesIterator");
        }
        this.assertValidControllable();
        SourceStreamSetXmitMessageIterator msgItr = null;
        try {
            msgItr = new SourceStreamSetXmitMessageIterator(maxMsgs);
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getTransmitMessagesIterator", (String)"1:283:1.39", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"SourceStreamSetControl.getTransmitMessagesIterator", "1:291:1.39", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)msgItr);
        }
        return msgItr;
    }

    public boolean containsGuesses() throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsGuesses");
        }
        this.assertValidControllable();
        boolean guess = false;
        Iterator<Stream> itr = null;
        try {
            itr = this._streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.containsGuesses", (String)"1:328:1.39", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"SourceStreamSetControl.containsGuesses", "1:336:1.39", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"containsGuesses", (Object)((Object)finalE));
            }
            throw finalE;
        }
        while (!guess && itr.hasNext()) {
            SourceStream stream = (SourceStream)itr.next();
            guess = stream.containsGuesses();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsGuesses", (Object)new Boolean(guess));
        }
        return guess;
    }

    public int getCurrentMaxIndoubtMessages(int priority, int COS) {
        return 0;
    }

    public void forceFlushAtSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMessagesAtSource(IndoubtAction indoubtAction) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
        this.assertValidControllable();
        StreamSet streamSet = this._streamSet;
        synchronized (streamSet) {
            boolean foundUncommittedMsgs = false;
            boolean reallocateAllMsgs = false;
            if (indoubtAction == IndoubtAction.INDOUBT_REALLOCATE) {
                reallocateAllMsgs = true;
                try {
                    this._sourceStreamManager.reallocate(reallocateAllMsgs);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.clearMessagesAtSource", (String)"1:424:1.39", (Object)this);
                    SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"SourceStreamSetControl.clearMessagesAtSource", "1:432:1.39", e}, null), (Throwable)e);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource", (Object)((Object)finalE));
                    }
                    throw finalE;
                }
            }
            if (indoubtAction != IndoubtAction.INDOUBT_LEAVE) {
                boolean discard = false;
                if (indoubtAction == IndoubtAction.INDOUBT_DELETE) {
                    discard = true;
                }
                SIMPIterator itr = this.getTransmitMessagesIterator(-1);
                TransmitMessage xmitMsg = null;
                String state = null;
                while (itr.hasNext()) {
                    xmitMsg = (TransmitMessage)itr.next();
                    state = xmitMsg.getState();
                    if (state.equals(SIMPTransmitMessageControllable.State.COMMITTING.toString())) {
                        foundUncommittedMsgs = true;
                        continue;
                    }
                    try {
                        SIMPMessage msg = xmitMsg.getSIMPMessage();
                        if (msg == null) continue;
                        this._sourceStreamManager.removeMessage(msg);
                        QueuedMessage queuedMessage = (QueuedMessage)msg.getControlAdapter();
                        if (queuedMessage == null) continue;
                        queuedMessage.moveMessage(discard);
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.clearMessagesAtSource", (String)"1:496:1.39", (Object)this);
                        SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"SourceStreamSetControl.clearMessagesAtSource", "1:504:1.39", e}, null), (Throwable)e);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource", (Object)((Object)finalE));
                        }
                        throw finalE;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearMessagesAtSource");
        }
    }

    public DeliveryStreamType getType() {
        return DeliveryStreamType.ANYCAST_SOURCE;
    }

    public String getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String returnString = this._streamID.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)returnString);
        }
        return returnString;
    }

    public String getName() {
        return null;
    }

    @Override
    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._streamSet == null || this._sourceStreamManager == null) {
            SIMPControllableNotFoundException finalE = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"SourceStreamSetControl.assertValidControllable", "1:603:1.39", this._streamID}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)((Object)finalE));
            }
            throw finalE;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    @Override
    public void dereferenceControllable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._streamSet = null;
        this._sourceStreamManager = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void runtimeEventOccurred(RuntimeEvent event) {
    }

    public SIMPTransmitMessageControllable getTransmitMessageByID(String id) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)id);
        }
        SIMPTransmitMessageControllable msg = null;
        SIMPIterator it = this.getStreams();
        while (it.hasNext() && msg == null) {
            msg = ((SourceStreamControl)it.next()).getTransmitMessageByID(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)msg);
        }
        return msg;
    }

    public long getDepth() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDepth");
        }
        long depth = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            depth += (long)((SourceStreamControl)iterator.next()).getNumberOfActiveMessages();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDepth", (Object)new Long(depth));
        }
        return depth;
    }

    public SIMPIterator getStreams() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreams");
        }
        this.assertValidControllable();
        Iterator<Stream> it = null;
        try {
            it = this._streamSet.iterator();
        }
        catch (SIResourceException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getStreams", (String)"1:713:1.39", (Object)this);
            SIMPRuntimeOperationFailedException finalE = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"SourceStreamSetControl.getStreams", "1:721:1.39", e}, null), (Throwable)e);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
        }
        SourceStreamControllableIterator returnIterator = new SourceStreamControllableIterator(it);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreams", (Object)returnIterator);
        }
        return returnIterator;
    }

    public SIMPIterator getAttatchedRemoteSubscribers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRemoteEngineUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String remoteMEUuid = this._streamSet.getRemoteMEUuid().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)remoteMEUuid);
        }
        return remoteMEUuid;
    }

    public void reallocateAllTransmitMessages() throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateAllTransmitMessages");
        }
        this.clearMessagesAtSource(IndoubtAction.INDOUBT_REALLOCATE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateAllTransmitMessages");
        }
    }

    public long getNumberOfMessagesSent() throws SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesSent");
        }
        long count = 0L;
        SIMPIterator iterator = this.getStreams();
        while (iterator.hasNext()) {
            SourceStreamControl srcStreamControl = (SourceStreamControl)iterator.next();
            count += srcStreamControl.getNumberOfMessagesSent();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesSent", (Object)new Long(count));
        }
        return count;
    }

    public long getNumberOfUnacknowledgedMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfUnacknowledgedMessages");
        }
        long count = 0L;
        try {
            SIMPIterator iterator = this.getTransmitMessagesIterator(-1);
            while (iterator.hasNext()) {
                TransmitMessage msg = (TransmitMessage)iterator.next();
                if (!msg.getState().equals(SIMPTransmitMessageControllable.State.PENDING_ACKNOWLEDGEMENT.toString())) continue;
                ++count;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getNumberOfUnacknowledgedMessages", (String)"1:817:1.39", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getNumberOfUnacknowledgedMessages", "1:822:1.39", SIMPUtils.getStackTrace(e)});
            SibTr.exception((TraceComponent)tc, (Exception)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfUnacknowledgedMessages", (Object)new Long(count));
        }
        return count;
    }

    public void moveMessages(boolean discard) throws SIMPRuntimeOperationFailedException, SIMPControllableNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessages", (Object)new Boolean(discard));
        }
        if (discard) {
            this.clearMessagesAtSource(IndoubtAction.INDOUBT_DELETE);
        } else {
            this.clearMessagesAtSource(IndoubtAction.INDOUBT_EXCEPTION);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessages");
        }
    }

    public HealthStateListener getHealthState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthState");
        }
        SIMPIterator it = null;
        try {
            it = this.getStreams();
        }
        catch (SIMPControllableNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamSetControl.getHealthState", (String)"1:865:1.39", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)((Object)e));
            }
            return null;
        }
        while (it.hasNext()) {
            SIMPDeliveryTransmitControllable control = (SIMPDeliveryTransmitControllable)it.next();
            ((HealthStateTree)this._healthState).addHealthStateNode(control.getHealthState());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthState", (Object)this._healthState);
        }
        return (HealthStateListener)this._healthState;
    }

    protected class SourceStreamSetXmitMessageIterator
    implements SIMPIterator {
        protected Iterator streamSetIterator = null;
        protected SourceStream currentStream = null;
        protected Iterator<SIMPTransmitMessageControllable> currentStreamMsgIterator = null;
        int index;
        int max;
        boolean allMsgs;

        public SourceStreamSetXmitMessageIterator(int maxMsgs) throws SIResourceException {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"SourceStreamSetXmitMessageIterator", (Object)maxMsgs);
            }
            this.index = 0;
            this.max = maxMsgs;
            this.allMsgs = maxMsgs == -1;
            this.streamSetIterator = SourceStreamSetControl.this._streamSet.iterator();
            this.moveToNextStream();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"SourceStreamSetXmitMessageIterator", (Object)this);
            }
        }

        protected void moveToNextStream() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"moveToNextStream");
            }
            boolean keepSearchingStreams = true;
            while (keepSearchingStreams) {
                if (this.streamSetIterator.hasNext()) {
                    this.currentStream = (SourceStream)this.streamSetIterator.next();
                    this.currentStreamMsgIterator = this.currentStream.getControlAdapter().getTransmitMessagesIterator(-1);
                    if (!this.currentStreamMsgIterator.hasNext()) continue;
                    keepSearchingStreams = false;
                    continue;
                }
                keepSearchingStreams = false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"moveToNextStream");
            }
        }

        public Object next() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"next");
            }
            SIMPTransmitMessageControllable returnMessage = null;
            if (this.allMsgs || this.index < this.max) {
                if (!this.currentStreamMsgIterator.hasNext()) {
                    this.moveToNextStream();
                }
                returnMessage = this.currentStreamMsgIterator.next();
                ++this.index;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)returnMessage);
            }
            return returnMessage;
        }

        public boolean hasNext() {
            boolean returnValue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"hasNext");
            }
            if (this.currentStreamMsgIterator == null || !this.currentStreamMsgIterator.hasNext()) {
                this.moveToNextStream();
            }
            boolean bl = returnValue = (this.allMsgs || this.index < this.max) && this.currentStreamMsgIterator != null && this.currentStreamMsgIterator.hasNext();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(returnValue));
            }
            return returnValue;
        }

        public void remove() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"remove");
            }
            InvalidOperationException finalE = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"SourceStreamSetControl.SourceStreamSetXmitMessageIterator.remove", "1:213:1.39", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)((Object)finalE));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)((Object)finalE));
            }
            throw finalE;
        }

        public void finished() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"finished");
            }
            this.streamSetIterator = null;
            this.currentStream = null;
            this.currentStreamMsgIterator = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"finished");
            }
        }
    }
}

