/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.impl.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.impl.MPRuntimeEvent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Hashtable;
import java.util.Properties;

public abstract class BaseMessageItemStream
extends SIMPItemStream
implements ControllableResource {
    private static final TraceComponent tc = SibTr.register(BaseMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected ControlAdapter controlAdapter;
    protected BaseDestinationHandler destinationHandler;
    protected MessageProcessor mp;
    protected boolean _isEventNotificationEnabled = false;
    protected long _destHighMsgs;
    protected long _destLowMsgs;
    protected long _destMsgInterval = 0L;
    protected long _nextUpDepthInterval = Long.MAX_VALUE;
    protected long _nextDownDepthInterval = Long.MIN_VALUE;
    protected long _nextHighWatermark;
    protected long _nextLowWatermark;
    boolean wlmRemoved = false;

    public void initializeNonPersistent(BaseDestinationHandler destinationHandler) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)destinationHandler);
        }
        this.destinationHandler = destinationHandler;
        this.mp = destinationHandler.getMessageProcessor();
        this._isEventNotificationEnabled = this.mp.getMessagingEngine().isEventNotificationEnabled();
        this.createControlAdapter();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public synchronized void setDefaultDestLimits() throws MessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefaultDestLimits");
        }
        long destHighMsgs = this.mp.getHighMessageThreshold();
        this.setDestLimits(destHighMsgs, destHighMsgs * 8L / 10L);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefaultDestLimits");
        }
    }

    public long getDestHighMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestHighMsgs");
            SibTr.exit((TraceComponent)tc, (String)"getDestHighMsgs", (Object)this._destHighMsgs);
        }
        return this._destHighMsgs;
    }

    public long getDestLowMsgs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestLowMsgs");
            SibTr.exit((TraceComponent)tc, (String)"getDestLowMsgs", (Object)this._destLowMsgs);
        }
        return this._destLowMsgs;
    }

    public void setDestHighMsgs(long newDestHighMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs", (Object)newDestHighMsgs);
        }
        this.setDestLimits(newDestHighMsgs, this._destLowMsgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs");
        }
    }

    public void setDestLowMsgs(long newDestLowMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLowMsgs", (Object)newDestLowMsgs);
        }
        this.setDestLimits(this._destHighMsgs, newDestLowMsgs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLowMsgs");
        }
    }

    protected synchronized void setDestLimits(long newDestHighMsgs, long newDestLowMsgs) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLimits", (Object)new Object[]{new Long(newDestHighMsgs), new Long(newDestLowMsgs)});
        }
        this._destHighMsgs = newDestHighMsgs;
        if (newDestLowMsgs >= this._destHighMsgs) {
            long decrease = (long)((double)this._destHighMsgs * this.destinationHandler.getMessageProcessor().getCustomProperties().get_dest_low_unset_percentage_decrease());
            this._destLowMsgs = this._destHighMsgs - decrease;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"setDestLowMsgs", (Object)("Cannot set destLowMsgs to be higher than destHighMsgs. New destLowMsgs=" + this._destLowMsgs));
            }
        } else {
            this._destLowMsgs = newDestLowMsgs;
        }
        if (this.isThresholdNotificationRequired()) {
            this.updateWatermarks(this.getTotalMsgCount());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestLimits");
        }
    }

    protected boolean isThresholdNotificationRequired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isThresholdNotificationRequired");
        }
        boolean result = false;
        if (this._isEventNotificationEnabled || this.mp.getCustomProperties().getOutputLinkThresholdEventsToLog() && this.destinationHandler.isLink() || this.mp.getCustomProperties().getOutputDestinationThresholdEventsToLog() && !this.destinationHandler.isLink()) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isThresholdNotificationRequired", (Object)new Boolean(result));
        }
        return result;
    }

    public synchronized void setDestMsgInterval() {
        Hashtable<String, Long> depthIntervals;
        long newInterval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestMsgInterval");
        }
        if ((newInterval = (long)this.mp.getCustomProperties().getLogAllMessageDepthIntervals()) < 0L) {
            newInterval = 0L;
        }
        String destName = this.destinationHandler.getName();
        if (this.destinationHandler.isLink()) {
            destName = ((LinkHandler)this.destinationHandler).getBusName();
        }
        if ((depthIntervals = this.mp.getCustomProperties().getLogMessageDepthIntervalsTable()).containsKey(destName)) {
            newInterval = depthIntervals.get(destName);
        }
        if (newInterval != this._destMsgInterval) {
            this._destMsgInterval = newInterval;
            if (this._destMsgInterval > 0L) {
                long currentDepth = this.getTotalMsgCount();
                this._nextUpDepthInterval = (currentDepth / this._destMsgInterval + 1L) * this._destMsgInterval;
                this._nextDownDepthInterval = (currentDepth - 1L) / this._destMsgInterval * this._destMsgInterval;
            } else {
                this._nextUpDepthInterval = Long.MAX_VALUE;
                this._nextDownDepthInterval = Long.MIN_VALUE;
            }
            this.updateWatermarks(this.getTotalMsgCount());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestMsgInterval");
        }
    }

    public abstract long getTotalMsgCount();

    public boolean isQHighLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        boolean limited = false;
        if (this._destHighMsgs != -1L) {
            boolean bl = limited = this.getTotalMsgCount() >= this._destHighMsgs;
        }
        if (limited) {
            this.notifyClients();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)limited);
        }
        return limited;
    }

    public boolean isQLowLimit() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQLowLimit");
        }
        boolean isUnderDestinationLowLimit = false;
        if (this._destLowMsgs != -1L) {
            isUnderDestinationLowLimit = this.getTotalMsgCount() <= this._destLowMsgs;
        } else {
            boolean bl = isUnderDestinationLowLimit = !this.isQHighLimit();
        }
        if (isUnderDestinationLowLimit) {
            this.notifyClients();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQLowLimit", (Object)isUnderDestinationLowLimit);
        }
        return isUnderDestinationLowLimit;
    }

    public boolean isQFull() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQFull");
        }
        boolean qFull = false;
        long totalMessages = this.getTotalMsgCount();
        if (this._destHighMsgs != -1L) {
            boolean bl = qFull = totalMessages >= this._destHighMsgs;
            if (!qFull && this._destLowMsgs != -1L && this.wlmRemoved) {
                boolean bl2 = qFull = totalMessages >= this._destLowMsgs;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQFull", (Object)qFull);
        }
        return qFull;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClients() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyClients");
        }
        if (this.isThresholdNotificationRequired()) {
            long totalItems = this.getTotalMsgCount();
            BaseMessageItemStream baseMessageItemStream = this;
            synchronized (baseMessageItemStream) {
                if (this.wlmRemoved && (this._destLowMsgs == -1L || totalItems <= this._destLowMsgs)) {
                    this.wlmRemoved = false;
                    this.fireDepthThresholdReachedEvent(this.getControlAdapter(), false, totalItems, this._destLowMsgs);
                } else if (!this.wlmRemoved && this._destHighMsgs != -1L && this._destLowMsgs != -1L && totalItems >= this._destHighMsgs) {
                    this.wlmRemoved = true;
                    this.fireDepthThresholdReachedEvent(this.getControlAdapter(), true, totalItems, this._destHighMsgs);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyClients");
        }
    }

    public long getByteHighWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getByteHighWaterMark");
            SibTr.exit((TraceComponent)tc, (String)"getByteHighWaterMark");
        }
        return -1L;
    }

    public long getByteLowWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getByteLowWaterMark");
            SibTr.exit((TraceComponent)tc, (String)"getByteLowWaterMark");
        }
        return -1L;
    }

    public long getCountHighWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountHighWaterMark");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountHighWaterMark", (Object)new Long(this._nextHighWatermark));
        }
        return this._nextHighWatermark;
    }

    public long getCountLowWaterMark() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountLowWaterMark");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountLowWaterMark", (Object)new Long(this._nextLowWatermark));
        }
        return this._nextLowWatermark;
    }

    public synchronized void eventWatermarkBreached() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        long currentDepth = this.getTotalMsgCount();
        if (this._destMsgInterval != 0L) {
            if (currentDepth >= this._nextUpDepthInterval) {
                this.issueDepthIntervalMessage(this._nextUpDepthInterval);
                this._nextDownDepthInterval = this._nextUpDepthInterval - this._destMsgInterval;
                this._nextUpDepthInterval += this._destMsgInterval;
            } else if (currentDepth <= this._nextDownDepthInterval) {
                this.issueDepthIntervalMessage(this._nextDownDepthInterval);
                this._nextUpDepthInterval = this._nextDownDepthInterval + this._destMsgInterval;
                this._nextDownDepthInterval -= this._destMsgInterval;
            }
        }
        this.notifyClients();
        this.updateWatermarks(currentDepth);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    protected void issueDepthIntervalMessage(long depth) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"issueDepthIntervalMessage", (Object)new Long(depth));
        }
        SibTr.info((TraceComponent)tc, (String)"DESTINATION_DEPTH_INTERVAL_REACHED_CWSIP0787", (Object)new Object[]{this.destinationHandler.getName(), this.mp.getMessagingEngineName(), new Long(depth)});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"issueDepthIntervalMessage");
        }
    }

    protected void updateWatermarks(long currentDepth) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateWatermarks", (Object)new Long(currentDepth));
        }
        boolean setWatermarks = false;
        this._nextHighWatermark = this._nextUpDepthInterval;
        this._nextLowWatermark = this._nextDownDepthInterval;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("_destMsgInterval: " + this._destMsgInterval + " _destHighMsgs: " + this._destHighMsgs + " _destLowMsgs: " + this._destLowMsgs + " _nextUpDepthInterval: " + this._nextUpDepthInterval + " _nextDownDepthInterval: " + this._nextDownDepthInterval));
        }
        if (this._destMsgInterval > 0L) {
            setWatermarks = true;
        }
        if (this.isThresholdNotificationRequired()) {
            setWatermarks = true;
            if (this._destMsgInterval > 0L) {
                if (this._nextHighWatermark > this._destHighMsgs && currentDepth < this._destHighMsgs) {
                    this._nextHighWatermark = this._destHighMsgs;
                }
                if (this._nextLowWatermark < this._destLowMsgs && currentDepth > this._destLowMsgs) {
                    this._nextLowWatermark = this._destLowMsgs;
                }
            } else {
                this._nextHighWatermark = this._destHighMsgs;
                this._nextLowWatermark = this._destLowMsgs;
            }
        }
        if (setWatermarks) {
            this.setWatermarks(this._nextLowWatermark, this._nextHighWatermark);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateWatermarks", (Object)new Object[]{new Long(this._nextLowWatermark), new Long(this._nextHighWatermark)});
        }
    }

    protected void setWatermarks(long nextLowWatermark, long nextHighWatermark) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWatermarks", (Object)new Object[]{new Long(nextLowWatermark), new Long(nextHighWatermark)});
        }
        try {
            this.setWatermarks(nextLowWatermark, nextHighWatermark, -1L, -1L);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.BaseMessageItemStream.setWatermarks", (String)"1:702:1.24", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWatermarks");
        }
    }

    @Override
    public ControlAdapter getControlAdapter() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    @Override
    public void deregisterControlAdapterMBean() {
    }

    @Override
    public void registerControlAdapterAsMBean() {
    }

    @Override
    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    public void fireDepthThresholdReachedEvent(ControlAdapter cAdapter, boolean reachedHigh, long numMsgs, long msgLimit) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)new Object[]{cAdapter, new Boolean(reachedHigh), new Long(numMsgs)});
        }
        String destinationName = this.destinationHandler.getName();
        String meName = this.mp.getMessagingEngineName();
        if (this.mp.getCustomProperties().getOutputDestinationThresholdEventsToLog()) {
            if (reachedHigh) {
                SibTr.info((TraceComponent)tc, (String)"NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0553", (Object)new Object[]{destinationName, meName, msgLimit});
            } else {
                SibTr.info((TraceComponent)tc, (String)"NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0554", (Object)new Object[]{destinationName, meName, msgLimit});
            }
        }
        if (this._isEventNotificationEnabled) {
            if (cAdapter != null) {
                String message = null;
                message = reachedHigh ? nls.getFormattedMessage("NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0553", new Object[]{destinationName, meName, msgLimit}, null) : nls.getFormattedMessage("NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0554", new Object[]{destinationName, meName, msgLimit}, null);
                Properties props = new Properties();
                props.put("destination.name", destinationName);
                props.put("destination.UUID", this.destinationHandler.getUuid().toString());
                if (reachedHigh) {
                    props.put("depth.threshold.reached", "depth.threshold.reached.high");
                } else {
                    props.put("depth.threshold.reached", "depth.threshold.reached.low");
                }
                props.put("messages", String.valueOf(numMsgs));
                MPRuntimeEvent MPevent = new MPRuntimeEvent("SIB.messagepoint.depth.threshold.reached", message, props);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)("Drive runtimeEventOccurred against Control adapter: " + cAdapter));
                }
                cAdapter.runtimeEventOccurred(MPevent);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)"Control adapter is null, cannot fire event");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent");
        }
    }

    public abstract BaseDestinationHandler getDestinationHandler();
}

