/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.processor.impl.indexes.statemodel.State;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public abstract class AbstractDestinationIndex
extends Index {
    private static final TraceComponent tc = SibTr.register(AbstractDestinationIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public synchronized Index.Entry put(DestinationHandler destinationHandler, AbstractDestinationType type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{destinationHandler, type});
        }
        DestinationEntry entry = new DestinationEntry(destinationHandler, (AbstractDestinationType)type.clone());
        this.add(entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized void remove(DestinationHandler destinationHandler) {
        Object dh;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{destinationHandler});
        }
        if ((dh = this.get(destinationHandler.getUuid())) == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"AbstractDestinationIndex", "1:121:1.14.1.2", destinationHandler.getName()}, null));
        }
        this.remove(destinationHandler.getUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized DestinationHandler findByUuid(SIBUuid12 uuid, IndexFilter filter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByUuid", (Object)new Object[]{uuid, filter});
        }
        DestinationHandler destinationHandler = (DestinationHandler)this.get(uuid, filter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByUuid", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public synchronized AbstractDestinationType getType(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = (AbstractDestinationType)this._getType(destinationHandler).clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)type);
        }
        return type;
    }

    protected synchronized AbstractDestinationType _getType(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"_getType", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = (AbstractDestinationType)this.getType(destinationHandler.getUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_getType", (Object)type);
        }
        return type;
    }

    public synchronized void setType(DestinationHandler destinationHandler, Index.Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setType", (Object)new Object[]{destinationHandler, type});
        }
        this.setType(destinationHandler.getUuid(), type);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setType");
        }
    }

    public synchronized State getState(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        State state = null;
        if (type != null) {
            state = type.state;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)state);
        }
        return state;
    }

    public synchronized void create(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.create();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"create", (Object)type.state);
        }
    }

    public synchronized void cleanup(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanup", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.cleanup();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanup", (Object)type.state);
        }
    }

    public synchronized void delete(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"delete", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.delete();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"delete", (Object)type.state);
        }
    }

    public synchronized void defer(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"defer", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.defer();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"defer", (Object)type.state);
        }
    }

    public synchronized void cleanupComplete(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupComplete", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.cleanupComplete();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupComplete", (Object)type.state);
        }
    }

    public synchronized void putUnreconciled(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putUnreconciled", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.putUnreconciled();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putUnreconciled", (Object)type.state);
        }
    }

    public synchronized void putInDoubt(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"putInDoubt", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.putInDoubt();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"putInDoubt", (Object)type.state);
        }
    }

    public synchronized void corrupt(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"corrupt", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.corrupt();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"corrupt", (Object)type.state);
        }
    }

    public synchronized void reset(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationType type = this._getType(destinationHandler);
        type.state = type.state.reset();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset", (Object)type.state);
        }
    }

    public synchronized void addPseudoUuid(DestinationHandler destinationHandler, SIBUuid12 pseudoUuid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPseudoUuid", (Object)new Object[]{destinationHandler, pseudoUuid});
        }
        Index.Entry entry = (Index.Entry)this.index.get(destinationHandler.getUuid());
        this.index.put(pseudoUuid, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPseudoUuid");
        }
    }

    public synchronized void removePseudoUuid(SIBUuid12 pseudoUuid) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removePseudoUuid", (Object)new Object[]{pseudoUuid});
        }
        this.index.remove(pseudoUuid);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removePseudoUuid");
        }
    }

    public synchronized boolean containsDestination(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsDestination", (Object)new Object[]{destinationHandler});
        }
        boolean result = false;
        if (destinationHandler.getUuid() != null) {
            result = this.containsKey(destinationHandler.getUuid());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsDestination", (Object)result);
        }
        return result;
    }

    protected static class DestinationEntry
    extends Index.Entry {
        DestinationEntry(DestinationHandler destinationHandler, AbstractDestinationType type) {
            super(destinationHandler.getUuid(), destinationHandler, type);
        }

        DestinationHandler getHandler() {
            return (DestinationHandler)this.data;
        }
    }

    public static abstract class AbstractDestinationType
    extends Index.Type {
        public State state = null;
    }
}

