/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.destination;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.mfp.control.ControlCreateStream;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.exceptions.SIMPDestinationLockedException;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubInputHandler;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.destination.AbstractProtoRealization;
import com.ibm.ws.sib.processor.impl.destination.LocalisationManager;
import com.ibm.ws.sib.processor.impl.destination.RemotePubSubSupport;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumableKey;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerKey;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.filters.SubscriptionFilter;
import com.ibm.ws.sib.processor.impl.store.filters.SubscriptionStateFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AOContainerItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.DurableSubscriptionItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProxyReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.runtime.impl.MPRuntimeEvent;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCallback;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionAlreadyExistsException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import com.ibm.wsspi.sib.core.exception.SINonDurableSubscriptionMismatchException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class PubSubRealization
extends AbstractProtoRealization {
    private static final TraceComponent tc = SibTr.register(PubSubRealization.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap<SIBUuid8, PubSubOutputHandler> _pubsubOutputHandlers = null;
    private HashMap<String, Object> _consumerDispatchersDurable = null;
    PubSubMessageItemStream _pubsubMessageItemStream = null;
    private ProxyReferenceStream _proxyReferenceStream;
    private LockManager _pubsubOutputHandlerLockManager = null;
    private SubscriptionIndex _subscriptionIndex = null;
    protected RemotePubSubSupport _pubSubRemoteSupport = null;

    public PubSubRealization(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor, LocalisationManager localisationManager, TransactionCommon transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubRealization", (Object)new Object[]{myBaseDestinationHandler, messageProcessor, localisationManager, transaction});
        }
        this._baseDestinationHandler = myBaseDestinationHandler;
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._localisationManager = localisationManager;
        this._localisationManager.setLocal();
        this._localisationManager.setRemote(false);
        this._remoteSupport = new RemotePubSubSupport(myBaseDestinationHandler, messageProcessor);
        this._pubSubRemoteSupport = (RemotePubSubSupport)this._remoteSupport;
        Transaction msTran = messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
        try {
            this._pubsubMessageItemStream = new PubSubMessageItemStream(myBaseDestinationHandler, msTran);
            this._proxyReferenceStream = new ProxyReferenceStream(this._pubsubMessageItemStream, msTran);
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PubSubRealization", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.PubSubRealization", (String)"1:291:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PubSubRealization", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubRealization", (Object)this);
        }
    }

    public PubSubRealization(BaseDestinationHandler myBaseDestinationHandler, MessageProcessor messageProcessor, LocalisationManager localisationManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PubSubRealization", (Object)new Object[]{myBaseDestinationHandler, messageProcessor, localisationManager});
        }
        this._baseDestinationHandler = myBaseDestinationHandler;
        this._messageProcessor = messageProcessor;
        this._destinationManager = messageProcessor.getDestinationManager();
        this._remoteSupport = new RemotePubSubSupport(myBaseDestinationHandler, messageProcessor);
        this._localisationManager = localisationManager;
        this._localisationManager.setLocal();
        this._localisationManager.setRemote(false);
        this._pubSubRemoteSupport = (RemotePubSubSupport)this._remoteSupport;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PubSubRealization", (Object)this);
        }
    }

    public void initialise(boolean createPubSubInputHandler, HashMap<String, Object> durableSubscriptionsTable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialise", (Object)new Object[]{new Boolean(createPubSubInputHandler), durableSubscriptionsTable});
        }
        this._consumerDispatchersDurable = durableSubscriptionsTable;
        this._pubsubOutputHandlers = new HashMap();
        this._pubsubOutputHandlerLockManager = new LockManager();
        this._subscriptionIndex = new SubscriptionIndex();
        this._pubSubRemoteSupport.initialisePseudoMaps();
        if (createPubSubInputHandler) {
            this.createInputHandlersForPubSub();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialise");
        }
    }

    public void reconstitute(int startMode, HashMap<String, Object> durableSubscriptionsTable) throws SIIncorrectCallException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, MessageStoreException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)new Object[]{new Integer(startMode), durableSubscriptionsTable});
        }
        this.initialise(false, durableSubscriptionsTable);
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(PubSubMessageItemStream.class));
        this._pubsubMessageItemStream = (PubSubMessageItemStream)cursor.next();
        if (this._pubsubMessageItemStream == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0048", new Object[]{this._baseDestinationHandler.getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.reconstitute", (String)"1:458:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
            }
            throw e;
        }
        cursor.finished();
        this._pubsubMessageItemStream.reconstitute(this._baseDestinationHandler);
        this._localisationManager.setLocal();
        cursor = this._pubsubMessageItemStream.newNonLockingReferenceStreamCursor(new ClassEqualsFilter(ProxyReferenceStream.class));
        this._proxyReferenceStream = (ProxyReferenceStream)cursor.next();
        if (this._proxyReferenceStream == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("DESTINATION_HANDLER_RECOVERY_ERROR_CWSIP0048", new Object[]{this._baseDestinationHandler.getName()}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.reconstitute", (String)"1:491:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitute", (Object)((Object)e));
            }
            throw e;
        }
        this._pubsubMessageItemStream.incrementReferenceStreamCount();
        cursor.finished();
        this.createInputHandlersForPubSub();
        this.reconstituteDurableSubscriptions();
        this._pubSubRemoteSupport.reconstituteSourceStreams(startMode, null);
        this._pubSubRemoteSupport.reconstituteRemoteDurable(startMode, this._consumerDispatchersDurable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public void stopDeletingMsgsWihoutReferencesTask(boolean hasToStop) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stopDeletingMsgsWihoutReferencesTask", (Object)hasToStop);
        }
        if (null != this._pubsubMessageItemStream) {
            this._pubsubMessageItemStream.stopDeletingMsgsWihoutReferencesTask(hasToStop);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stopDeletingMsgsWihoutReferencesTask", (Object)hasToStop);
        }
    }

    public void deleteMsgsWithNoReferences() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteMsgsWithNoReferences");
        }
        if (null != this._pubsubMessageItemStream) {
            this._pubsubMessageItemStream.deleteMsgsWithNoReferences();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteMsgsWithNoReferences");
        }
    }

    @Override
    public void reconstituteEnoughForDeletion() throws MessageStoreException, SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteEnoughForDeletion");
        }
        NonLockingCursor cursor = this._baseDestinationHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(PubSubMessageItemStream.class));
        this._pubsubMessageItemStream = (PubSubMessageItemStream)cursor.next();
        if (null != this._pubsubMessageItemStream) {
            this._pubsubMessageItemStream.reconstitute(this._baseDestinationHandler);
        }
        cursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteEnoughForDeletion");
        }
    }

    public ControlHandler getControlHandler(SIBUuid8 sourceMEUuid) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlHandler", (Object)new Object[]{sourceMEUuid});
        }
        ControlHandler msgHandler = this._pubsubOutputHandlers.get(sourceMEUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlHandler", (Object)msgHandler);
        }
        return msgHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerDispatcher getDurableSubscriptionConsumerDispatcher(ConsumerDispatcherState subState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptionConsumerDispatcher", (Object)subState);
        }
        ConsumerDispatcher consumerDispatcher = null;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            consumerDispatcher = (ConsumerDispatcher)this._consumerDispatchersDurable.get(subState.getSubscriberID());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptionConsumerDispatcher", (Object)consumerDispatcher);
        }
        return consumerDispatcher;
    }

    @Override
    public OutputHandler getLocalPostMedPtoPOH(boolean localMessage, boolean forcePut, boolean singleServer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalPostMedPtoPOH", (Object)new Object[]{new Boolean(localMessage), new Boolean(forcePut), new Boolean(singleServer)});
        }
        OutputHandler result = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalPostMedPtoPOH", result);
        }
        return result;
    }

    private ConsumerDispatcher createConsumerDispatcher(ConsumerDispatcherState state, SubscriptionItemStream subscription) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createConsumerDispatcher", (Object)new Object[]{state, subscription});
        }
        ConsumerDispatcher newConsumerDispatcher = new ConsumerDispatcher(this._baseDestinationHandler, subscription, state);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createConsumerDispatcher", (Object)newConsumerDispatcher);
        }
        return newConsumerDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerKey createSubscriptionConsumerDispatcherAndAttachCP(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException, SINonDurableSubscriptionMismatchException, SINotPossibleInCurrentConfigurationException, SIDestinationLockedException, SISessionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcherAndAttachCP", (Object)new Object[]{consumerPoint, subState});
        }
        ConsumerKey consumerKey = null;
        ConsumerDispatcher cd = null;
        if (subState.getSubscriberID() == null) {
            cd = this.createSubscriptionItemStreamAndConsumerDispatcher(subState, false);
            consumerKey = cd.attachConsumerPoint(consumerPoint, null, consumerPoint.getConsumerSession().getConnectionUuid(), consumerPoint.getConsumerSession().getReadAhead(), consumerPoint.getConsumerSession().getForwardScanning(), null);
        } else {
            ConcurrentHashMap<String, Object> concurrentHashMap = this._destinationManager.getNondurableSharedSubscriptions();
            synchronized (concurrentHashMap) {
                cd = (ConsumerDispatcher)this._destinationManager.getNondurableSharedSubscriptions().get(subState.getSubscriberID());
                if (cd == null) {
                    cd = this.createSubscriptionItemStreamAndConsumerDispatcher(subState, true);
                } else if (!cd.getConsumerDispatcherState().equals(subState)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)subState);
                    }
                    throw new SINonDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                consumerKey = cd.attachConsumerPoint(consumerPoint, null, consumerPoint.getConsumerSession().getConnectionUuid(), consumerPoint.getConsumerSession().getReadAhead(), consumerPoint.getConsumerSession().getForwardScanning(), null);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcherAndAttachCP", (Object)consumerKey);
        }
        return consumerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerDispatcher createSubscriptionConsumerDispatcher(ConsumerDispatcherState subState) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINonDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)subState);
        }
        ConsumerDispatcher cd = null;
        boolean isNewCDcreated = false;
        if (subState.getSubscriberID() == null) {
            cd = this.createSubscriptionItemStreamAndConsumerDispatcher(subState, false);
        } else {
            cd = (ConsumerDispatcher)this._destinationManager.getNondurableSharedSubscriptions().get(subState.getSubscriberID());
            if (cd == null) {
                ConcurrentHashMap<String, Object> concurrentHashMap = this._destinationManager.getNondurableSharedSubscriptions();
                synchronized (concurrentHashMap) {
                    cd = (ConsumerDispatcher)this._destinationManager.getNondurableSharedSubscriptions().get(subState.getSubscriberID());
                    if (cd == null) {
                        cd = this.createSubscriptionItemStreamAndConsumerDispatcher(subState, true);
                        isNewCDcreated = true;
                    }
                }
            }
        }
        if (!isNewCDcreated && subState.getSubscriberID() != null && !cd.getConsumerDispatcherState().equals(subState)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)subState);
            }
            throw new SINonDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionConsumerDispatcher", (Object)cd);
        }
        return cd;
    }

    private ConsumerDispatcher createSubscriptionItemStreamAndConsumerDispatcher(ConsumerDispatcherState subState, boolean isShared) throws SIResourceException, SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionItemStreamAndConsumerDispatcher", (Object)new Object[]{subState, isShared});
        }
        SubscriptionItemStream subscription = null;
        ConsumerDispatcher cd = null;
        try {
            subscription = new SubscriptionItemStream(this._pubsubMessageItemStream, this._baseDestinationHandler.getTransactionManager());
        }
        catch (OutOfCacheSpace e) {
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscriptionItemStreamAndConsumerDispatcher", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("SUBSCRIPTION_CREATION_FAILED_CWSIP0034", new Object[]{this._baseDestinationHandler.getName(), e}, null), (Throwable)e);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.createSubscriptionItemStreamAndConsumerDispatcher", (String)"1:763:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"SUBSCRIPTION_CREATION_FAILED_CWSIP0031", (Object)new Object[]{this._baseDestinationHandler.getName(), e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSubscriptionItemStreamAndConsumerDispatcher", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("SUBSCRIPTION_CREATION_FAILED_CWSIP0031", new Object[]{this._baseDestinationHandler.getName(), e}, null), (Throwable)e);
        }
        cd = this.createConsumerDispatcher(subState, subscription);
        this._messageProcessor.getMessageProcessorMatching().addConsumerDispatcherMatchTarget(cd, this._baseDestinationHandler.getUuid(), subState.getSelectionCriteria());
        if (!subState.getSubscriberID().contains("_NON_DURABLE_NON_SHARED")) {
            this._destinationManager.getNondurableSharedSubscriptions().put(subState.getSubscriberID(), cd);
        }
        this._subscriptionIndex.put(cd);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionItemStreamAndConsumerDispatcher", (Object)cd);
        }
        return cd;
    }

    public PubSubOutputHandler getPubSubOutputHandler(SIBUuid8 neighbourUUID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutputHandler", (Object)neighbourUUID);
        }
        PubSubOutputHandler handler = null;
        if (this._pubsubOutputHandlers != null) {
            handler = this._pubsubOutputHandlers.get(neighbourUUID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutputHandler", (Object)handler);
        }
        return handler;
    }

    public synchronized PubSubOutputHandler createPubSubOutputHandler(Neighbour neighbour) {
        PubSubOutputHandler handler;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPubSubOutputHandler", (Object)new Object[]{neighbour});
        }
        if ((handler = this.getPubSubOutputHandler(neighbour.getUUID())) == null) {
            handler = new PubSubOutputHandler(this._messageProcessor, neighbour, this._baseDestinationHandler);
        }
        this._pubsubOutputHandlerLockManager.lockExclusive();
        this._pubsubOutputHandlers.put(neighbour.getUUID(), handler);
        this._pubsubOutputHandlerLockManager.unlockExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPubSubOutputHandler", (Object)handler);
        }
        return handler;
    }

    public HashMap<SIBUuid8, PubSubOutputHandler> getAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllPubSubOutputHandlers");
        }
        this._pubsubOutputHandlerLockManager.lock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAllPubSubOutputHandlers", this._pubsubOutputHandlers);
        }
        return this._pubsubOutputHandlers;
    }

    public HashMap<SIBUuid8, PubSubOutputHandler> cloneAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cloneAllPubSubOutputHandlers");
        }
        HashMap clone = null;
        try {
            this._pubsubOutputHandlerLockManager.lock();
            clone = (HashMap)this._pubsubOutputHandlers.clone();
        }
        finally {
            this._pubsubOutputHandlerLockManager.unlock();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cloneAllPubSubOutputHandlers", (Object)clone);
        }
        return clone;
    }

    public void unlockPubsubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockPubsubOutputHandlers");
        }
        this._pubsubOutputHandlerLockManager.unlock();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockPubsubOutputHandlers");
        }
    }

    public synchronized void deletePubSubOutputHandler(SIBUuid8 neighbourUUID) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deletePubSubOutputHandler", (Object)neighbourUUID);
        }
        if (this._baseDestinationHandler.isToBeDeleted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deletePubSubOutputHandler");
            }
            return;
        }
        this._pubsubOutputHandlerLockManager.lockExclusive();
        this._pubsubOutputHandlers.remove(neighbourUUID);
        this._pubsubOutputHandlerLockManager.unlockExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deletePubSubOutputHandler");
        }
    }

    public synchronized void deleteAllPubSubOutputHandlers() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteAllPubSubOutputHandlers");
        }
        this._pubsubOutputHandlerLockManager.lockExclusive();
        this._pubsubOutputHandlers.clear();
        this._pubsubOutputHandlerLockManager.unlockExclusive();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteAllPubSubOutputHandlers");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLocalDurableSubscription(ConsumerDispatcherState subState, TransactionCommon transaction) throws SIDurableSubscriptionAlreadyExistsException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)new Object[]{subState, transaction});
        }
        ConsumerDispatcher consumerDispatcher = null;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            consumerDispatcher = this.getDurableSubscriptionConsumerDispatcher(subState);
            if (consumerDispatcher != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)("Sub Already Exists - " + subState));
                }
                throw new SIDurableSubscriptionAlreadyExistsException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            boolean tranProvided = true;
            LocalTransaction siTran = null;
            if (transaction == null) {
                tranProvided = false;
                siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                transaction = siTran;
            }
            Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
            try {
                DurableSubscriptionItemStream durableSubscriptionReferenceStream = new DurableSubscriptionItemStream(subState, this._baseDestinationHandler.getDestinationManager(), this._pubsubMessageItemStream, msTran);
                consumerDispatcher = this.configureDurableSubscription(durableSubscriptionReferenceStream);
                consumerDispatcher.registerControlAdapterAsMBean();
            }
            catch (OutOfCacheSpace e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (!tranProvided) {
                    this._baseDestinationHandler.handleRollback(siTran);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)"SIResourceException");
                }
                throw new SIResourceException(nls.getFormattedMessage("SUBSCRIPTION_CREATION_FAILED_CWSIP0033", new Object[]{this._baseDestinationHandler.getName(), subState.getSubscriberID(), e}, null), (Throwable)e);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.createLocalDurableSubscription", (String)"1:1093:1.35.2.4", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (!tranProvided) {
                    this._baseDestinationHandler.handleRollback(siTran);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.createLocalDurableSubscription", "1:1112:1.35.2.4", e, this._baseDestinationHandler.getName()});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1121:1.35.2.4", e, this._baseDestinationHandler.getName()}, null), (Throwable)e);
            }
            catch (SIDiscriminatorSyntaxException e) {
                this._baseDestinationHandler.handleRollback(siTran);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)((Object)e));
                }
                throw e;
            }
            catch (SISelectorSyntaxException e) {
                this._baseDestinationHandler.handleRollback(siTran);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)((Object)e));
                }
                throw e;
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.createLocalDurableSubscription", (String)"1:1153:1.35.2.4", (Object)this);
                if (siTran != null) {
                    this._baseDestinationHandler.handleRollback(siTran);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)e);
                }
                throw e;
            }
            if (!tranProvided) {
                try {
                    siTran.commit();
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.createLocalDurableSubscription", (String)"1:1182:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1191:1.35.2.4", e, this._baseDestinationHandler.getName()});
                    this._baseDestinationHandler.handleRollback(siTran);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1207:1.35.2.4", e, this._baseDestinationHandler.getName()}, null), (Throwable)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createLocalDurableSubscription");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumableKey attachToLocalDurableSubscription(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState) throws SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)new Object[]{consumerPoint, subState});
        }
        ConsumerDispatcher consumerDispatcher = null;
        ConsumableKey data = null;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            consumerDispatcher = this.getDurableSubscriptionConsumerDispatcher(subState);
            if (consumerDispatcher != null) {
                if (consumerDispatcher.hasConsumersAttached() && !subState.isCloned()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)"Consumers already attached");
                    }
                    throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (!consumerDispatcher.getConsumerDispatcherState().isReady() || !consumerDispatcher.getConsumerDispatcherState().equals(subState)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)subState);
                    }
                    throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (this._messageProcessor.isBusSecure() && !consumerDispatcher.getConsumerDispatcherState().equalUser(subState)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)subState);
                    }
                    throw new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("USER_NOT_AUTH_ACTIVATE_ERROR_CWSIP0312", new Object[]{subState.getUser(), subState.getSubscriberID(), this._baseDestinationHandler.getName()}, null));
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)"SIDurableSubscriptionNotFoundException");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
            }
            data = (ConsumableKey)consumerDispatcher.attachConsumerPoint(consumerPoint, null, consumerPoint.getConsumerSession().getConnectionUuid(), consumerPoint.getConsumerSession().getReadAhead(), consumerPoint.getConsumerSession().getForwardScanning(), null);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachToLocalDurableSubscription", (Object)data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLocalDurableSubscription(String subscriptionId) throws SIResourceException, SIMPDestinationLockedException, SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)new Object[]{subscriptionId});
        }
        DurableSubscriptionItemStream rstream = null;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            block27: {
                ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)this._consumerDispatchersDurable.get(subscriptionId);
                if (consumerDispatcher == null || !consumerDispatcher.getConsumerDispatcherState().isReady()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)("Sub not found " + subscriptionId));
                    }
                    throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{subscriptionId, this._messageProcessor.getMessagingEngineName()}, null));
                }
                if (consumerDispatcher.hasConsumersAttached()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)(" SIDestinationLockedException" + subscriptionId));
                    }
                    throw new SIMPDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subscriptionId, this._messageProcessor.getMessagingEngineName()}, null), 0);
                }
                SubscriptionStateFilter subStateFilter = new SubscriptionStateFilter();
                subStateFilter.setConsumerDispatcherStateFilter(consumerDispatcher.getConsumerDispatcherState());
                try {
                    rstream = (DurableSubscriptionItemStream)this._pubsubMessageItemStream.findFirstMatchingReferenceStream(subStateFilter);
                    if (rstream != null && rstream.getStatistics().getRemovingItemCount() != 0L) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)("SIDestinationLockedException" + rstream.getStatistics().getUnavailableItemCount() + ":" + subscriptionId));
                        }
                        throw new SIMPDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0153", new Object[]{subscriptionId, this._messageProcessor.getMessagingEngineName()}, null), 1);
                    }
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.deleteLocalDurableSubscription", (String)"1:1472:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1481:1.35.2.4", e, subscriptionId});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1493:1.35.2.4", e, subscriptionId}, null), (Throwable)e);
                }
                boolean persistingToBeDeletedFlag = false;
                try {
                    if (rstream != null) {
                        rstream.markAsToBeDeleted();
                        if (rstream.isInStore()) {
                            persistingToBeDeletedFlag = true;
                            rstream.requestUpdate((Transaction)this._messageProcessor.getTXManager().createAutoCommitTransaction());
                            persistingToBeDeletedFlag = false;
                        }
                    }
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.deleteLocalDurableSubscription", (String)"1:1523:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1532:1.35.2.4", e, subscriptionId});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)((Object)e));
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1544:1.35.2.4", e, subscriptionId}, null), (Throwable)e);
                }
                finally {
                    if (persistingToBeDeletedFlag) {
                        rstream.clearToBeDeleted();
                    }
                }
                this._consumerDispatchersDurable.remove(subscriptionId);
                try {
                    consumerDispatcher.deleteConsumerDispatcher(true);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.deleteLocalDurableSubscription", (String)"1:1580:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) break block27;
                    SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)((Object)e));
                }
            }
        }
        if (rstream != null) {
            rstream.deleteIfPossible(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLocalDurableSubscription", (Object)subscriptionId);
        }
    }

    private void reconstituteDurableSubscriptions() throws MessageStoreException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstituteDurableSubscriptions");
        }
        DurableSubscriptionItemStream durableSub = null;
        SubscriptionStateFilter subStateFilter = new SubscriptionStateFilter();
        NonLockingCursor subCursor = this._pubsubMessageItemStream.newNonLockingReferenceStreamCursor(subStateFilter);
        durableSub = (DurableSubscriptionItemStream)subCursor.next();
        while (durableSub != null) {
            durableSub.initializeNonPersistent(this._baseDestinationHandler);
            this._pubsubMessageItemStream.incrementReferenceStreamCount();
            boolean valid = this.checkDurableSubStillValid(durableSub);
            if (valid) {
                this.configureDurableSubscription(durableSub);
                Collection unrestoredMsgCollection = durableSub.clearUnrestoredMessages();
                if (unrestoredMsgCollection != null) {
                    Iterator indoubtMessages = unrestoredMsgCollection.iterator();
                    while (indoubtMessages.hasNext()) {
                        MessageItemReference itemRef = (MessageItemReference)this._baseDestinationHandler.findById((Long)indoubtMessages.next());
                        if (itemRef == null) continue;
                        durableSub.registerListeners(itemRef);
                    }
                }
            }
            durableSub = (DurableSubscriptionItemStream)subCursor.next();
        }
        subCursor.finished();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstituteDurableSubscriptions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerDispatcher configureDurableSubscription(DurableSubscriptionItemStream durableSub) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configureDurableSubscription", (Object)durableSub);
        }
        ConsumerDispatcher consumerDispatcher = this.createConsumerDispatcher(durableSub.getConsumerDispatcherState(), durableSub);
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            this._consumerDispatchersDurable.put(durableSub.getConsumerDispatcherState().getSubscriberID(), consumerDispatcher);
        }
        SelectionCriteria[] selCriteria = durableSub.getConsumerDispatcherState().getSelectionCriteriaList();
        if (selCriteria != null) {
            for (int i = 0; i < selCriteria.length; ++i) {
                this._messageProcessor.getMessageProcessorMatching().addConsumerDispatcherMatchTarget(consumerDispatcher, this._baseDestinationHandler.getUuid(), selCriteria[i]);
            }
        }
        this._subscriptionIndex.put(consumerDispatcher);
        consumerDispatcher.getControlAdapter().registerControlAdapterAsMBean();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configureDurableSubscription", (Object)consumerDispatcher);
        }
        return consumerDispatcher;
    }

    public void dereferenceSubscriptionConsumerDispatcher(ConsumerDispatcher cd, boolean isNonDurable, boolean callProxyCode) throws SIResourceException {
        block12: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher", (Object)new Object[]{cd, new Boolean(isNonDurable), new Boolean(callProxyCode)});
            }
            try {
                this._subscriptionIndex.remove(cd);
                SelectionCriteria[] selCriteria = cd.getConsumerDispatcherState().getSelectionCriteriaList();
                if (selCriteria != null) {
                    for (int i = 0; i < selCriteria.length; ++i) {
                        this._messageProcessor.getMessageProcessorMatching().removeConsumerDispatcherMatchTarget(cd, selCriteria[i]);
                    }
                }
                if (!isNonDurable) break block12;
                try {
                    SubscriptionItemStream subscription;
                    if (!cd.getConsumerDispatcherState().getSubscriberID().contains("_NON_DURABLE_NON_SHARED")) {
                        this._destinationManager.getNondurableSharedSubscriptions().remove(cd.getConsumerDispatcherState().getSubscriberID());
                    }
                    if ((subscription = (SubscriptionItemStream)this._pubsubMessageItemStream.findFirstMatchingReferenceStream(new SubscriptionFilter(cd))) != null) {
                        subscription.markAsToBeDeleted();
                        subscription.deleteIfPossible(true);
                    }
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.dereferenceSubscriptionConsumerDispatcher", (String)"1:1835:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1844:1.35.2.4", e, cd.getConsumerDispatcherState().getSubscriberID()});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher");
                    }
                    throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1856:1.35.2.4", e, cd.getConsumerDispatcherState().getSubscriberID()}, null), (Throwable)e);
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.dereferenceSubscriptionConsumerDispatcher", (String)"1:1869:1.35.2.4", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1878:1.35.2.4", e, cd.getConsumerDispatcherState().getSubscriberID()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:1890:1.35.2.4", e, cd.getConsumerDispatcherState().getSubscriberID()}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceSubscriptionConsumerDispatcher");
        }
    }

    public void addPubSubLocalisation(LocalizationDefinition destinationLocalizationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPubSubLocalisation", (Object)new Object[]{destinationLocalizationDefinition});
        }
        this._pubsubMessageItemStream.updateLocalizationDefinition(destinationLocalizationDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPubSubLocalisation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToBeDeleted() {
        super.setToBeDeleted();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setToBeDeleted");
        }
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            for (Object obj : this._consumerDispatchersDurable.values()) {
                ConsumerDispatcher cd;
                if (!(obj instanceof ConsumerDispatcher) || !(cd = (ConsumerDispatcher)obj).getDestination().equals(this._baseDestinationHandler) || !cd.isInMatchSpace() || cd.hasConsumersAttached()) continue;
                try {
                    this.dereferenceSubscriptionConsumerDispatcher(cd, !cd.isDurable(), false);
                }
                catch (SIResourceException e) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setToBeDeleted");
        }
    }

    public SubscriptionIndex getSubscriptionIndex() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionIndex");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionIndex", (Object)this._subscriptionIndex);
        }
        return this._subscriptionIndex;
    }

    private void createInputHandlersForPubSub() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createInputHandlersForPubSub");
        }
        this._baseDestinationHandler.setInputHandler(new PubSubInputHandler(this._baseDestinationHandler, this._pubSubRemoteSupport.getTargetProtocolItemStream(), this._pubsubMessageItemStream, this._proxyReferenceStream, this._pubSubRemoteSupport.getSourceProtocolItemStream()));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createInputHandlersForPubSub");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupDestination() throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupDestination");
        }
        Object debugItemStream = null;
        try {
            HashMap durableSubs;
            NonLockingCursor cursor = this._pubsubMessageItemStream.newNonLockingReferenceStreamCursor(new ClassEqualsFilter(SubscriptionItemStream.class, DurableSubscriptionItemStream.class));
            SubscriptionItemStream subscription = (SubscriptionItemStream)cursor.next();
            HashMap hashMap = durableSubs = this._destinationManager.getDurableSubscriptionsTable();
            synchronized (hashMap) {
                while (subscription != null) {
                    try {
                        this.deleteLocalDurableSubscription(subscription.getConsumerDispatcher().getConsumerDispatcherState().getSubscriberID());
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.cleanupDestination", (String)"1:2074:1.35.2.4", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                    subscription = (SubscriptionItemStream)cursor.next();
                }
            }
            cursor.finished();
            cursor = this._pubsubMessageItemStream.newNonLockingReferenceStreamCursor(new ClassEqualsFilter(SubscriptionItemStream.class, DurableSubscriptionItemStream.class));
            subscription = (SubscriptionItemStream)cursor.next();
            if (subscription == null) {
                Transaction msTran;
                LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                this._pubSubRemoteSupport.removeProtocolItems((TransactionCommon)siTran);
                siTran.commit();
                siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                this._pubSubRemoteSupport.resetProtocolStreams();
                if (this._proxyReferenceStream != null) {
                    BatchHandler sourceBatchHandler = this._messageProcessor.getSourceBatchHandler();
                    sourceBatchHandler.completeBatch(true);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        if (this._proxyReferenceStream.isInStore()) {
                            Statistics stats = this._proxyReferenceStream.getStatistics();
                            SibTr.debug((TraceComponent)tc, (String)("Destination :" + this._baseDestinationHandler.getName() + " " + this._baseDestinationHandler.getUuid().toString() + " Adding : " + stats.getAddingItemCount() + " Available : " + stats.getAvailableItemCount() + " Expiring : " + stats.getExpiringItemCount() + " Locked : " + stats.getLockedItemCount() + " Removing : " + stats.getRemovingItemCount() + " Total : " + stats.getTotalItemCount() + " Unavailable : " + stats.getUnavailableItemCount() + " Updating : " + stats.getUpdatingItemCount()));
                        } else {
                            SibTr.debug((TraceComponent)tc, (String)("Destination :" + this._baseDestinationHandler.getName() + " " + this._baseDestinationHandler.getUuid().toString()));
                        }
                    }
                    msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)siTran);
                    this._proxyReferenceStream.removeAll(msTran);
                    siTran.commit();
                    siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                    this._pubsubMessageItemStream.decrementReferenceStreamCount();
                    this._proxyReferenceStream = null;
                }
                BatchHandler publicationBatchHandler = this._messageProcessor.getPublicationBatchHandler();
                publicationBatchHandler.completeBatch(true);
                msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)siTran);
                this._pubsubMessageItemStream.removeAllItemsWithNoRefCount(msTran);
                this._pubsubMessageItemStream.removeItemStream(msTran, -2L);
                debugItemStream = this._pubsubMessageItemStream;
                siTran.commit();
                siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)siTran);
                this._baseDestinationHandler.remove(msTran, -2L);
                debugItemStream = this._baseDestinationHandler;
                siTran.commit();
                this._baseDestinationHandler.setDeleted();
            }
            cursor.finished();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.cleanupDestination", (String)"1:2223:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (debugItemStream != null && debugItemStream.isInStore()) {
                    Statistics stats = null;
                    try {
                        debugItemStream.xmlRequestWriteOnSystemOut();
                        stats = debugItemStream.getStatistics();
                        SibTr.debug((TraceComponent)tc, (String)("Destination :" + this._baseDestinationHandler.getName() + " " + debugItemStream.toString() + " Adding : " + stats.getAddingItemCount() + " Available : " + stats.getAvailableItemCount() + " Expiring : " + stats.getExpiringItemCount() + " Locked : " + stats.getLockedItemCount() + " Removing : " + stats.getRemovingItemCount() + " Total : " + stats.getTotalItemCount() + " Unavailable : " + stats.getUnavailableItemCount() + " Updating : " + stats.getUpdatingItemCount()));
                    }
                    catch (IOException e1) {
                        SibTr.debug((TraceComponent)tc, (String)("Could not output destination xml : " + e1));
                    }
                    catch (MessageStoreException e1) {
                        SibTr.debug((TraceComponent)tc, (String)("Could not output destination xml : " + (Object)((Object)e1)));
                    }
                } else {
                    SibTr.debug((TraceComponent)tc, (String)("Destination :" + this._baseDestinationHandler.getName()));
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"cleanupDestination", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupDestination");
        }
    }

    @Override
    public boolean cleanupLocalisations() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLocalisations");
        }
        boolean allCleanedUp = this._pubSubRemoteSupport.cleanupLocalisations(this._consumerDispatchersDurable);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLocalisations", (Object)new Boolean(allCleanedUp));
        }
        return allCleanedUp;
    }

    public PubSubMessageItemStream getPublishPoint() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPublishPoint");
            SibTr.exit((TraceComponent)tc, (String)"getPublishPoint", (Object)this._pubsubMessageItemStream);
        }
        return this._pubsubMessageItemStream;
    }

    public void updateLocalisationDefinition(LocalizationDefinition destinationLocalizationDefinition) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLocalisationDefinition", (Object)new Object[]{destinationLocalizationDefinition});
        }
        this._pubsubMessageItemStream.updateLocalizationDefinition(destinationLocalizationDefinition);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLocalisationDefinition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void itemReferencesDroppedToZero(SIMPMessage msg) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)msg);
        }
        BatchHandler batchHandler = this._messageProcessor.getPublicationBatchHandler();
        LocalTransaction transaction = null;
        boolean batched = true;
        boolean messageAddCall = false;
        try {
            boolean localTransactionCreated = false;
            LocalTransaction localTransaction = null;
            if (msg.getReportCOD() != null) {
                transaction = localTransaction = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                localTransactionCreated = true;
                transaction.registerCallback((TransactionCallback)msg);
                batched = false;
            } else if (((MessageItem)msg).getStorageStrategy() <= 2) {
                transaction = this._baseDestinationHandler.getTransactionManager().createAutoCommitTransaction();
                batched = false;
            } else {
                transaction = batchHandler.registerInBatch();
            }
            try {
                Transaction msTran = this._messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
                msg.remove(msTran, msg.getLockID());
                if (localTransactionCreated) {
                    localTransaction.commit();
                }
                if (batched) {
                    messageAddCall = true;
                    batchHandler.messagesAdded(1);
                }
            }
            catch (MessageStoreRuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                }
                if (msg.getReliability() != Reliability.BEST_EFFORT_NONPERSISTENT) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.itemReferencesDroppedToZero", (String)"1:2432:1.35.2.4", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)("MsgStoreRuntimeException " + (Object)((Object)e)));
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:2446:1.35.2.4", e, this._baseDestinationHandler.getName()}, null), (Throwable)e);
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.itemReferencesDroppedToZero", (String)"1:2457:1.35.2.4", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:2466:1.35.2.4", e, this._baseDestinationHandler.getName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)("ResourceException " + (Object)((Object)e)));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:2481:1.35.2.4", e, this._baseDestinationHandler.getName()}, null), (Throwable)e);
            }
        }
        finally {
            block24: {
                if (batched && !messageAddCall) {
                    try {
                        batchHandler.messagesAdded(0);
                    }
                    catch (SIResourceException e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    }
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)new Boolean(messageAddCall));
            }
        }
    }

    @Override
    public void onExpiryReport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onExpiryReport");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"onExpiryReport");
        }
    }

    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(10, this._baseDestinationHandler);
        msg.registerMessageEventListener(7, this._baseDestinationHandler);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public List<String> getSubscriptionList() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionList");
        }
        LinkedList<String> subscriptions = null;
        try {
            NonLockingCursor cursor = this._pubsubMessageItemStream.newNonLockingReferenceStreamCursor(new ClassEqualsFilter(SubscriptionItemStream.class, DurableSubscriptionItemStream.class));
            SubscriptionItemStream subscription = (SubscriptionItemStream)cursor.next();
            while (subscription != null) {
                if (subscriptions == null) {
                    subscriptions = new LinkedList<String>();
                }
                subscriptions.add(subscription.getConsumerDispatcher().getConsumerDispatcherState().getSubscriberID());
                subscription = (SubscriptionItemStream)cursor.next();
            }
            cursor.finished();
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.getSubscriptionList", (String)"1:2579:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriptionList", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionList", subscriptions);
        }
        return subscriptions;
    }

    public ProxyReferenceStream getProxyReferenceStream() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProxyReferenceStream");
            SibTr.exit((TraceComponent)tc, (String)"getProxyReferenceStream", (Object)((Object)this._proxyReferenceStream));
        }
        return this._proxyReferenceStream;
    }

    public void registerForMessageEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForMessageEvents", (Object)msg);
        }
        this.registerForEvents(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForMessageEvents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteDurableFromRemote(String subName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteDurableFromRemote", (Object)subName);
        }
        int status = 0;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            block17: {
                ConsumerDispatcher current = (ConsumerDispatcher)this._consumerDispatchersDurable.get(subName);
                if (current == null) {
                    status = 3;
                } else {
                    int count = current.getConsumerCount();
                    if (count == 0) {
                        try {
                            ((PubSubInputHandler)this._baseDestinationHandler.getInputHandler()).forceTargetBatchCompletion(null);
                            this.deleteLocalDurableSubscription(subName);
                        }
                        catch (SIMPDestinationLockedException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Durable subscription locked");
                            }
                            if (e.getType() == 0) {
                                status = 4;
                                break block17;
                            }
                            status = 7;
                        }
                        catch (SIDurableSubscriptionNotFoundException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Durable subscription not found");
                            }
                            status = 3;
                        }
                        catch (SIResourceException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Durable subscription resource exception");
                            }
                            status = 2;
                        }
                    } else {
                        status = 4;
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDurableFromRemote", (Object)new Integer(status));
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumableKey attachToRemoteDurableSubscription(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState, SIBUuid8 durableMEUuid) throws SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException, SIDurableSubscriptionMismatchException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)new Object[]{consumerPoint, subState, durableMEUuid});
        }
        String remSubName = this._baseDestinationHandler.constructPseudoDurableDestName(durableMEUuid.toString(), subState.getSubscriberID());
        boolean createConsumerDispatcher = true;
        ConsumableKey data = null;
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            Object current = null;
            boolean tryAgain = true;
            int remainingAttempts = 10;
            while (tryAgain) {
                tryAgain = false;
                current = this._consumerDispatchersDurable.get(remSubName);
                if (current != null) {
                    if (current instanceof RemoteConsumerDispatcher) {
                        RemoteConsumerDispatcher rcd = (RemoteConsumerDispatcher)current;
                        if (rcd.getPendingDelete() && (current = rcd.getResolvedDurableCD(rcd)) != null) {
                            ((RemoteConsumerDispatcher)current).setPendingDelete(false);
                        }
                    } else if (current instanceof String && subState.isCloned()) {
                        current = null;
                    }
                    if (current != null) continue;
                    if (--remainingAttempts == 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"Consumers already attached");
                        }
                        throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                    }
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Waiting on " + this._consumerDispatchersDurable));
                        }
                        this._consumerDispatchersDurable.wait(100L);
                    }
                    catch (InterruptedException rcd) {
                        // empty catch block
                    }
                    tryAgain = true;
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"No existing consumer dispatcher found");
            }
            if (current != null) {
                createConsumerDispatcher = false;
                if (current instanceof RemoteConsumerDispatcher) {
                    try {
                        data = (ConsumableKey)((RemoteConsumerDispatcher)current).attachConsumerPoint(consumerPoint, null, consumerPoint.getConsumerSession().getConnectionUuid(), consumerPoint.getConsumerSession().getReadAhead(), consumerPoint.getConsumerSession().getForwardScanning(), null);
                    }
                    catch (SIResourceException e) {
                        if (((RemoteConsumerDispatcher)current).hasConsumersAttached()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)new Object[]{"Consumers already attached locally", e});
                            }
                            throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                        }
                        if (((RemoteConsumerDispatcher)current).getAnycastInputHandler().testStreamStatus(0)) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)new Object[]{"Consumers already attached remotely", e});
                            }
                            throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)new Object[]{"Failed to attach remotely", e});
                        }
                        throw e;
                    }
                } else {
                    if (!subState.isCloned() && current instanceof String) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"Consumer in the process of attaching locally");
                        }
                        throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"A ConsumerDispatcher for this subscription exists locally.");
                    }
                    throw new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_ATTACH_FAILED_CWSIP0035", new Object[]{subState.getSubscriberID(), durableMEUuid}, null));
                }
            }
            if (createConsumerDispatcher) {
                this._consumerDispatchersDurable.put(remSubName, remSubName);
            }
        }
        if (createConsumerDispatcher) {
            RemoteConsumerDispatcher rcd = null;
            try {
                rcd = this._pubSubRemoteSupport.createRemoteConsumerDispatcher(remSubName, subState, durableMEUuid);
            }
            catch (Exception e) {
                HashMap<String, Object> hashMap2 = this._consumerDispatchersDurable;
                synchronized (hashMap2) {
                    this._consumerDispatchersDurable.remove(remSubName);
                }
                if (e instanceof SIDurableSubscriptionNotFoundException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"SIDurableSubscriptionNotFoundException");
                    }
                    throw (SIDurableSubscriptionNotFoundException)((Object)e);
                }
                if (e instanceof SIDestinationLockedException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"SIDestinationLockedException");
                    }
                    throw (SIDestinationLockedException)((Object)e);
                }
                if (e instanceof SIResourceException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"SIResourceException");
                    }
                    throw (SIResourceException)((Object)e);
                }
                if (e instanceof SIDurableSubscriptionMismatchException) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"SIDurableSubscriptionMismatchException");
                    }
                    throw (SIDurableSubscriptionMismatchException)((Object)e);
                }
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.attachToRemoteDurableSubscription", (String)"1:3044:1.35.2.4", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", (Object)"SIErrorException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:3059:1.35.2.4"}, null));
            }
            HashMap<String, Object> hashMap3 = this._consumerDispatchersDurable;
            synchronized (hashMap3) {
                this._consumerDispatchersDurable.put(remSubName, rcd);
                data = (ConsumableKey)rcd.attachConsumerPoint(consumerPoint, null, consumerPoint.getConsumerSession().getConnectionUuid(), consumerPoint.getConsumerSession().getReadAhead(), consumerPoint.getConsumerSession().getForwardScanning(), null);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Notifying all on " + this._consumerDispatchersDurable));
                }
                this._consumerDispatchersDurable.notifyAll();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachToRemoteDurableSubscription", data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachDurableFromRemote(ControlCreateStream request) throws SIDestinationLockedException, SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)request);
        }
        String subName = request.getDurableSubName();
        SIBUuid8 sender = request.getGuaranteedSourceMessagingEngineUUID();
        String destName = this._baseDestinationHandler.constructPseudoDurableDestName(request.getGuaranteedTargetMessagingEngineUUID().toString(), subName);
        SelectionCriteria criteria = this._messageProcessor.getSelectionCriteriaFactory().createSelectionCriteria(request.getDurableDiscriminator(), request.getDurableSelector(), SelectorDomain.getSelectorDomain((int)request.getDurableSelectorDomain()));
        ConsumerDispatcherState subState = new ConsumerDispatcherState(request.getDurableSubName(), request.getGuaranteedTargetDestinationDefinitionUUID(), criteria, request.isNoLocal(), this._messageProcessor.getMessagingEngineName(), null, null);
        subState.setIsCloned(request.isCloned());
        subState.setTopicSpaceName(this._baseDestinationHandler.getDefinition().getName());
        subState.setTopicSpaceBusName(this._baseDestinationHandler.getBus());
        String user = request.getSecurityUserid();
        boolean isSIBServerSubject = request.isSecurityUseridSentBySystem();
        subState.setUser(user, isSIBServerSubject);
        if (this._pubSubRemoteSupport.locateExistingAOH(request, sender, destName, subState) == null) {
            HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
            synchronized (hashMap) {
                ConsumerDispatcher cd = (ConsumerDispatcher)this._consumerDispatchersDurable.get(subName);
                if (cd == null) {
                    SIDurableSubscriptionNotFoundException e = new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{subName, this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)"Subscription does not exist");
                    }
                    throw e;
                }
                if (cd.getConsumerDispatcherState().getTargetDestination() != null) {
                    SIDurableSubscriptionMismatchException e = new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("INTERNAL_SUBSCRIPTION_ACCESS_DISALLOWED_CWSIP0147", new Object[]{subName, this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)"Attaching to internal subscriptions is not allowed");
                    }
                    throw e;
                }
                subState.setNoLocal(cd.getConsumerDispatcherState().isNoLocal());
                subState.setIsCloned(cd.getConsumerDispatcherState().isCloned());
                if (cd.hasConsumersAttached() && !subState.isCloned()) {
                    SIDestinationLockedException e = new SIDestinationLockedException(nls.getFormattedMessage("SUBSCRIPTION_IN_USE_ERROR_CWSIP0152", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)"Consumers already attached");
                    }
                    throw e;
                }
                if (!cd.getConsumerDispatcherState().isReady() || !cd.getConsumerDispatcherState().equals(subState)) {
                    SIDurableSubscriptionMismatchException e = new SIDurableSubscriptionMismatchException(nls.getFormattedMessage("SUBSCRIPTION_ALREADY_EXISTS_ERROR_CWSIP0143", new Object[]{subState.getSubscriberID(), this._messageProcessor.getMessagingEngineName()}, null));
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)subState);
                    }
                    throw e;
                }
                DestinationDefinition pseudoDest = null;
                AnycastOutputHandler pseudoHandler = null;
                try {
                    pseudoDest = this._messageProcessor.createDestinationDefinition(DestinationType.TOPICSPACE, destName);
                    pseudoDest.setReceiveExclusive(!subState.isCloned());
                    AOContainerItemStream aostream = new AOContainerItemStream(pseudoDest.getUUID(), subName);
                    LocalTransaction siTran = this._baseDestinationHandler.getTransactionManager().createLocalTransaction(true);
                    this._baseDestinationHandler.addItemStream(aostream, (Transaction)siTran);
                    siTran.commit();
                    pseudoHandler = new AnycastOutputHandler(pseudoDest.getName(), pseudoDest.getUUID(), pseudoDest.isReceiveExclusive(), null, cd, aostream, this._messageProcessor, this._destinationManager.getAsyncUpdateThread(), this._destinationManager.getPersistLockThread(), System.currentTimeMillis(), false);
                    this._pubSubRemoteSupport.storePseudoDestination(pseudoHandler, destName, pseudoDest);
                    pseudoHandler.handleControlMessage(sender, (ControlMessage)request);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.attachDurableFromRemote", (String)"1:3304:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    if (pseudoDest != null) {
                        this._pubSubRemoteSupport.cleanupPseudoDestination(destName, pseudoDest);
                    }
                    if (pseudoHandler != null) {
                        pseudoHandler.close();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote", (Object)"SIErrorException");
                    }
                    SIErrorException x = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.attachDurableFromRemote", "1:3329:1.35.2.4", e}, null));
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.attachDurableFromRemote", (String)"1:3335:1.35.2.4", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)e);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.attachDurableFromRemote", "1:3345:1.35.2.4", e});
                    throw x;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachDurableFromRemote");
        }
    }

    public ConsumableKey attachToDurableSubscription(LocalConsumerPoint consumerPoint, ConsumerDispatcherState subState) throws SIDurableSubscriptionMismatchException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SISelectorSyntaxException, SIDiscriminatorSyntaxException, SINotPossibleInCurrentConfigurationException, SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"attachToDurableSubscription", (Object)new Object[]{consumerPoint, subState});
        }
        ConsumableKey result = null;
        SIBUuid8 durableHomeID = this._messageProcessor.mapMeNameToUuid(subState.getDurableHome());
        if (durableHomeID == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"attachToDurableSubscription", (Object)"SIResourceException");
            }
            throw new SIResourceException(nls.getFormattedMessage("REMOTE_ME_MAPPING_ERROR_CWSIP0156", new Object[]{subState.getDurableHome()}, null));
        }
        if (durableHomeID.equals((Object)this._messageProcessor.getMessagingEngineUuid())) {
            result = this.attachToLocalDurableSubscription(consumerPoint, subState);
        } else {
            subState.setRemoteMEUuid(durableHomeID);
            result = this.attachToRemoteDurableSubscription(consumerPoint, subState, durableHomeID);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"attachToDurableSubscription", (Object)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRemoteDurableRME(ConsumerDispatcherState subState) throws SIDurableSubscriptionNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteRemoteDurableRME", (Object)new Object[]{subState});
        }
        Object rcd = null;
        SIBUuid8 remoteMEUuid = subState.getRemoteMEUuid();
        String remSubName = null;
        if (remoteMEUuid != null) {
            remSubName = this._baseDestinationHandler.constructPseudoDurableDestName(remoteMEUuid.toString(), subState.getSubscriberID());
        }
        HashMap<String, Object> hashMap = this._consumerDispatchersDurable;
        synchronized (hashMap) {
            if (remSubName != null) {
                rcd = this._consumerDispatchersDurable.get(remSubName);
            }
            if (rcd == null || !(rcd instanceof RemoteConsumerDispatcher)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableRME", (Object)"no such durable subcription");
                }
                throw new SIDurableSubscriptionNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0072", new Object[]{subState.getSubscriberID(), subState.getDurableHome()}, null));
            }
            ((RemoteConsumerDispatcher)rcd).setPendingDelete(true);
        }
        final String subName = remSubName;
        final AnycastInputHandler aih = this._pubSubRemoteSupport.getAIHByName(remSubName);
        final SIBUuid12 pseudoDestID = aih.getDestUuid();
        Runnable deleteAction = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"run");
                }
                try {
                    LocalTransaction siTran = PubSubRealization.this._baseDestinationHandler.getTransactionManager().createLocalTransaction(false);
                    boolean deleting = PubSubRealization.this._pubSubRemoteSupport.deleteRemoteDurableRME(subName, aih, (TransactionCommon)siTran);
                    if (deleting) {
                        PubSubRealization.this._destinationManager.removePseudoDestination(pseudoDestID);
                        HashMap hashMap = PubSubRealization.this._consumerDispatchersDurable;
                        synchronized (hashMap) {
                            PubSubRealization.this._consumerDispatchersDurable.remove(subName);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Notifying all on " + PubSubRealization.this._consumerDispatchersDurable));
                            }
                            PubSubRealization.this._consumerDispatchersDurable.notifyAll();
                        }
                    }
                    siTran.commit();
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.run", (String)"1:3539:1.35.2.4", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization", "1:3547:1.35.2.4", e});
                }
                SIBUuid12 sIBUuid12 = pseudoDestID;
                synchronized (sIBUuid12) {
                    pseudoDestID.notifyAll();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"run");
                }
            }
        };
        SIBUuid12 sIBUuid12 = pseudoDestID;
        synchronized (sIBUuid12) {
            AnycastInputHandler anycastInputHandler = aih;
            synchronized (anycastInputHandler) {
                if (!aih.testStreamStatus(0)) {
                    aih.addFlushedCallback(deleteAction);
                } else {
                    deleteAction.run();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteRemoteDurableRME");
        }
    }

    @Override
    public void registerControlAdapters() {
        super.registerControlAdapters();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapters");
        }
        if (this._pubsubMessageItemStream != null) {
            this._pubsubMessageItemStream.registerControlAdapterAsMBean();
        }
        super.registerControlAdapters();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapters");
        }
    }

    private boolean checkDurableSubStillValid(DurableSubscriptionItemStream durableSub) throws SIResourceException {
        boolean valid;
        block17: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkDurableSubStillValid", (Object)durableSub);
            }
            valid = false;
            ConsumerDispatcherState cdState = durableSub.getConsumerDispatcherState();
            if (durableSub.isToBeDeleted()) {
                valid = false;
                this._destinationManager.addSubscriptionToDelete(durableSub);
            } else if (cdState.getTopicSpaceUuid().equals((Object)this._baseDestinationHandler.getUuid())) {
                valid = true;
            } else {
                try {
                    BaseDestinationDefinition dh = this._destinationManager.getLocalME().getMessagingEngine().getSIBDestination(cdState.getTopicSpaceBusName(), cdState.getTopicSpaceName());
                    if (dh.getUUID().equals((Object)cdState.getTopicSpaceUuid())) {
                        valid = true;
                        break block17;
                    }
                    durableSub.markAsToBeDeleted();
                    try {
                        durableSub.requestUpdate((Transaction)this._messageProcessor.getTXManager().createAutoCommitTransaction());
                    }
                    catch (MessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.checkDurableSubStillValid", (String)"1:3667:1.35.2.4", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"checkDurableSubStillValid", (Object)"SIResourceException - Failed to update durable sub to delete.");
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.checkDurableSubStillValid", "1:3684:1.35.2.4", e}, null));
                    }
                    durableSub.deleteIfPossible(false);
                }
                catch (SIBExceptionBase e) {
                    durableSub.markAsToBeDeleted();
                    try {
                        durableSub.requestUpdate((Transaction)this._messageProcessor.getTXManager().createAutoCommitTransaction());
                    }
                    catch (MessageStoreException e1) {
                        FFDCFilter.processException((Throwable)e1, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.checkDurableSubStillValid", (String)"1:3712:1.35.2.4", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"checkDurableSubStillValid", (Object)"SIResourceException - Failed to update durable sub to delete.");
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.checkDurableSubStillValid", "1:3729:1.35.2.4", e}, null));
                    }
                    durableSub.deleteIfPossible(false);
                    this._messageProcessor.getProxyHandler().unsubscribeEvent(cdState, (Transaction)this._baseDestinationHandler.getTransactionManager().createAutoCommitTransaction(), true);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkDurableSubStillValid", (Object)new Boolean(valid));
        }
        return valid;
    }

    public void runtimeEventOccurred(MPRuntimeEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)event);
        }
        if (this._pubsubMessageItemStream != null) {
            this._pubsubMessageItemStream.getControlAdapter().runtimeEventOccurred(event);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)"publication point is null, cannot fire event");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"runtimeEventOccurred");
        }
    }

    public MessageItem retrieveMessageFromItemStream(long msgStoreID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"retrieveMessageFromItemStream", (Object)new Long(msgStoreID));
        }
        MessageItem msgItem = null;
        try {
            msgItem = (MessageItem)this._pubsubMessageItemStream.findById(msgStoreID);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.destination.PubSubRealization.retrieveMessageFromItemStream", (String)"1:3797:1.35.2.4", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"retrieveMessageFromItemStream", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveMessageFromItemStream", (Object)msgItem);
        }
        return msgItem;
    }

    public RemotePubSubSupport getRemotePubSubSupport() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemotePubSubSupport");
            SibTr.exit((TraceComponent)tc, (String)"getRemotePubSubSupport", (Object)this._pubSubRemoteSupport);
        }
        return this._pubSubRemoteSupport;
    }
}

