/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.AbstractMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.mfp.MessageCreateFailedException;
import com.ibm.ws.sib.mfp.ProtocolType;
import com.ibm.ws.sib.mfp.control.ControlAck;
import com.ibm.ws.sib.mfp.control.ControlAckExpected;
import com.ibm.ws.sib.mfp.control.ControlAreYouFlushed;
import com.ibm.ws.sib.mfp.control.ControlFlushed;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.mfp.control.ControlMessageType;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.mfp.control.ControlNotFlushed;
import com.ibm.ws.sib.mfp.control.ControlSilence;
import com.ibm.ws.sib.mfp.impl.ControlMessageFactory;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.PersistenceException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.SourceStreamManager;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.exceptions.FlushAlreadyInProgressException;
import com.ibm.ws.sib.processor.impl.interfaces.ControlHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DownstreamControl;
import com.ibm.ws.sib.processor.impl.interfaces.FlushComplete;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.InputHandlerStore;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.OutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.Reallocator;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.BatchHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.ProtocolItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.io.MPIO;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.transactions.LocalTransaction;
import com.ibm.ws.sib.transactions.TransactionCommon;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class PtoPOutputHandler
implements OutputHandler,
ControlHandler,
DownstreamControl,
MessageEventListener,
Reallocator {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register(PtoPOutputHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private BatchHandler sourceBatchHandler;
    private ControlMessageFactory cmf;
    private SIBUuid8 targetMEUuid;
    private SIBUuid8 routingMEUuid;
    private SIBUuid8 unknownUuid = new SIBUuid8("0000000000000001");
    private SourceStreamManager sourceStreamManager;
    private PtoPMessageItemStream transmissionItemStream;
    JsDestinationAddress routingDestination = null;
    boolean isSystemOrTemp = false;
    private DestinationHandler destinationHandler;
    private boolean isLink = false;
    private String linkName = null;
    private MessageProcessor messageProcessor;
    private boolean isGuess = false;
    private MPIO mpio;
    private long lockID = 0L;
    protected boolean flushedForDeleteSource = false;
    protected FlushComplete deleteFlushSource = null;
    private volatile boolean _qHigh;
    private MPAlarmManager am;

    public PtoPOutputHandler(DestinationHandler destinationHandler, MessageProcessor messageProcessor, ProtocolItemStream protocolItemStream, SIBUuid8 targetMEUuid, PtoPMessageItemStream itemStream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)new Object[]{destinationHandler, messageProcessor, protocolItemStream, targetMEUuid, itemStream});
        }
        try {
            this.lockID = messageProcessor.getMessageStore().getUniqueLockID(1);
        }
        catch (PersistenceException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)e);
        }
        this.destinationHandler = destinationHandler;
        this.transmissionItemStream = itemStream;
        this.sourceStreamManager = new SourceStreamManager(messageProcessor, this, destinationHandler, protocolItemStream, targetMEUuid, this);
        if (destinationHandler.isLink() && !destinationHandler.isMQLink()) {
            this.isLink = true;
            this.linkName = destinationHandler.getName();
            String linkType = ((LinkHandler)destinationHandler).getType();
            if (linkType.equals("SIBVirtualGatewayLink")) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"SIBLink type, set null routing cell");
                }
                this.routingMEUuid = null;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MQLink type, set routingCell: " + targetMEUuid));
                }
                this.routingMEUuid = targetMEUuid;
            }
        } else {
            this.routingMEUuid = targetMEUuid;
        }
        this.messageProcessor = messageProcessor;
        this.targetMEUuid = targetMEUuid;
        this.mpio = messageProcessor.getMPIO();
        this.sourceBatchHandler = messageProcessor.getSourceBatchHandler();
        this.cmf = MessageProcessor.getControlMessageFactory();
        if (destinationHandler.isSystem() || destinationHandler.isTemporary()) {
            this.routingDestination = SIMPUtils.createJsDestinationAddress(destinationHandler.getName(), null);
            this.isSystemOrTemp = true;
        }
        this.am = messageProcessor.getAlarmManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PtoPOutputHandler", (Object)this);
        }
    }

    public void startFlush(FlushComplete complete) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException, FlushAlreadyInProgressException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"startFlush");
        }
        this.sourceStreamManager.startFlush(complete);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"startFlush");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean put(SIMPMessage msg, TransactionCommon transaction, InputHandlerStore inputHandlerStore, boolean storedByIH) throws SIResourceException {
        block26: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{msg, transaction, inputHandlerStore, new Boolean(storedByIH)});
            }
            JsMessage jsMsg = msg.getMessage();
            SIMPUtils.setGuaranteedDeliveryProperties(jsMsg, this.messageProcessor.getMessagingEngineUuid(), this.transmissionItemStream.getLocalizingMEUuid(), null, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
            ((MessageItem)msg).setTransacted(!transaction.isAutoCommit());
            try {
                boolean addedToStream = this.sourceStreamManager.addMessage(msg);
                if (!addedToStream) {
                    if (msg.getStreamIsGuess()) break block26;
                    if (this.isLink) {
                        Object object = ((MessageItem)msg).getSynchUpdateLock();
                        synchronized (object) {
                            jsMsg = this.addLinkProps(jsMsg);
                        }
                    }
                    if (!msg.isTransacted()) {
                        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                            UserTrace.traceOutboundSend(jsMsg, this.routingMEUuid, this.destinationHandler.getName(), this.destinationHandler.isForeignBus() || this.destinationHandler.isLink(), this.destinationHandler.isMQLink(), this.destinationHandler.isTemporary());
                        }
                        this.mpio.sendToMe(this.routingMEUuid, msg.getPriority(), (AbstractMessage)jsMsg);
                    } else {
                        msg.registerMessageEventListener(9, this);
                    }
                    break block26;
                }
                LocalTransaction siTran = null;
                if (!msg.isTransacted()) {
                    siTran = this.messageProcessor.getTXManager().createLocalTransaction(false);
                    transaction = siTran;
                }
                Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction(transaction);
                try {
                    this.transmissionItemStream.addItem((MessageItem)msg, msTran);
                }
                catch (OutOfCacheSpace e) {
                    this.sourceStreamManager.removeMessage(msg);
                    throw e;
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.put", (String)"1:505:1.241", (Object)this);
                    this.sourceStreamManager.removeMessage(msg);
                    throw e;
                }
                this.registerForEvents(msg);
                if (siTran == null) break block26;
                try {
                    siTran.commit();
                }
                catch (SIConnectionLostException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                catch (SIIncorrectCallException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
                catch (SIErrorException e) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"put", (Object)"SIResourceException");
                    }
                    throw new SIResourceException((Throwable)e);
                }
            }
            catch (OutOfCacheSpace e) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.put", (String)"1:555:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"put", (Object)((Object)e));
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:565:1.241", e});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:571:1.241", e}, null), (Throwable)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)new Boolean(storedByIH));
        }
        return storedByIH;
    }

    @Override
    public void registerForEvents(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents", (Object)msg);
        }
        msg.registerMessageEventListener(2, this);
        msg.registerMessageEventListener(4, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    @Override
    public void handleControlMessage(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        ControlMessageType type;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleControlMessage", (Object)new Object[]{sourceMEUuid, cMsg});
        }
        if ((type = cMsg.getControlMessageType()) != ControlMessageType.REQUESTFLUSH) {
            if (type == ControlMessageType.AREYOUFLUSHED) {
                this.sourceStreamManager.processFlushQuery((ControlAreYouFlushed)cMsg);
            } else if (type == ControlMessageType.ACK) {
                this.processAck((ControlAck)cMsg);
            } else if (type == ControlMessageType.NACK) {
                this.sourceStreamManager.processNack((ControlNack)cMsg);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleControlMessage");
        }
    }

    private JsMessage addLinkProps(JsMessage msg) {
        String linkOutboundUserid;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps");
        }
        msg.setGuaranteedCrossBusLinkName(this.linkName);
        msg.setGuaranteedCrossBusSourceBusUUID(this.messageProcessor.getMessagingEngineBusUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Test whether outbound userid should be set in message");
        }
        if ((linkOutboundUserid = ((LinkHandler)this.destinationHandler).getOutboundUserid()) != null && !this.messageProcessor.getAuthorisationUtils().sentBySIBServer(msg)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Set outbound userid: " + linkOutboundUserid + ", in message"));
            }
            this.messageProcessor.getAccessChecker().setSecurityIDInMessage(linkOutboundUserid, msg);
            msg.setApiUserId(linkOutboundUserid);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return msg;
    }

    private ControlMessage addLinkProps(ControlMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLinkProps");
        }
        msg.setGuaranteedCrossBusLinkName(this.linkName);
        msg.setGuaranteedCrossBusSourceBusUUID(this.messageProcessor.getMessagingEngineBusUuid());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLinkProps");
        }
        return msg;
    }

    @Override
    public void sendAckExpectedMessage(long ackExpStamp, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)new Object[]{new Long(ackExpStamp), new Integer(priority), reliability});
        }
        if (this.routingMEUuid != null) {
            ControlAckExpected ackexpMsg;
            try {
                ackexpMsg = this.cmf.createNewControlAckExpected();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.sendAckExpectedMessage", (String)"1:733:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)e);
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage", (Object)e);
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:744:1.241", e});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:752:1.241", e}, null), (Throwable)e);
            }
            SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)ackexpMsg, this.messageProcessor.getMessagingEngineUuid(), this.targetMEUuid, stream, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
            ackexpMsg.setTick(ackExpStamp);
            ackexpMsg.setPriority(priority);
            ackexpMsg.setReliability(reliability);
            SourceStream sourceStream = (SourceStream)this.sourceStreamManager.getStreamSet().getStream(priority, reliability);
            if (sourceStream != null) {
                sourceStream.setLatestAckExpected(ackExpStamp);
                sourceStream.getControlAdapter().getHealthState().updateHealth(HealthStateListener.ACK_EXPECTED_STATE, 1);
            }
            if (this.isLink) {
                ackexpMsg = (ControlAckExpected)this.addLinkProps((ControlMessage)ackexpMsg);
            }
            if (this.isSystemOrTemp) {
                ackexpMsg.setRoutingDestination(this.routingDestination);
            }
            this.mpio.sendToMe(this.routingMEUuid, priority, (AbstractMessage)ackexpMsg);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unable to send AckExpected as Link not started");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAckExpectedMessage");
        }
    }

    @Override
    public void sendSilenceMessage(long startStamp, long endStamp, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        ControlSilence sMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendSilenceMessage");
        }
        try {
            sMsg = this.cmf.createNewControlSilence();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.sendSilenceMessage", (String)"1:849:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:856:1.241", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:867:1.241", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)sMsg, this.messageProcessor.getMessagingEngineUuid(), this.targetMEUuid, stream, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
        sMsg.setStartTick(startStamp);
        sMsg.setEndTick(endStamp);
        sMsg.setPriority(priority);
        sMsg.setReliability(reliability);
        sMsg.setCompletedPrefix(completedPrefix);
        if (this.isLink) {
            sMsg = (ControlSilence)this.addLinkProps((ControlMessage)sMsg);
        }
        if (this.isSystemOrTemp) {
            sMsg.setRoutingDestination(this.routingDestination);
        }
        if (requestedOnly) {
            this.mpio.sendToMe(this.routingMEUuid, priority + 1, (AbstractMessage)sMsg);
        } else {
            this.mpio.sendToMe(this.routingMEUuid, priority, (AbstractMessage)sMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendSilenceMessage");
        }
    }

    @Override
    public MessageItem getValueMessage(long msgStoreID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getValueMessage", (Object)new Long(msgStoreID));
        }
        MessageItem messageItem = null;
        try {
            messageItem = (MessageItem)this.transmissionItemStream.findById(msgStoreID);
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.getValueMessage", (String)"1:937:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getValueMessage", (Object)((Object)e));
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getValueMessage", (Object)messageItem);
        }
        return messageItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TickRange> sendValueMessages(List msgList, long completedPrefix, boolean requestedOnly, int priority, Reliability reliability, SIBUuid12 streamId) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendValueMessages", (Object)new Object[]{msgList, new Long(completedPrefix), this.targetMEUuid});
        }
        JsMessage jsMsg = null;
        TickRange tickRange = null;
        MessageItem msgItem = null;
        long msgId = -1L;
        ArrayList<TickRange> expiredMsgs = null;
        for (int i = 0; i < msgList.size(); ++i) {
            tickRange = (TickRange)msgList.get(i);
            msgId = tickRange.itemStreamIndex;
            msgItem = this.getValueMessage(msgId);
            boolean removeMessage = false;
            if (msgItem == null) {
                removeMessage = true;
            } else {
                try {
                    if (!msgItem.lockItemIfAvailable(this.lockID) && !msgItem.isLocked()) {
                        removeMessage = true;
                    }
                }
                catch (MessageStoreException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.sendValueMessages", (String)"1:1016:1.241", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", (Object)((Object)e));
                    }
                    throw new SIResourceException((Throwable)e);
                }
            }
            if (removeMessage) {
                if (expiredMsgs == null) {
                    expiredMsgs = new ArrayList<TickRange>();
                }
                expiredMsgs.add(tickRange);
                ControlSilence cMsg = this.createSilenceMessage(tickRange.valuestamp, completedPrefix, priority, reliability, streamId);
                if (this.isLink) {
                    cMsg = this.addLinkProps((ControlMessage)cMsg);
                }
                if (this.isSystemOrTemp) {
                    cMsg.setRoutingDestination(this.routingDestination);
                }
                if (requestedOnly) {
                    this.mpio.sendToMe(this.routingMEUuid, priority + 1, (AbstractMessage)cMsg);
                    continue;
                }
                this.mpio.sendToMe(this.routingMEUuid, priority, (AbstractMessage)cMsg);
                continue;
            }
            jsMsg = msgItem.getMessage();
            if (jsMsg.getGuaranteedStreamUUID() != streamId) {
                jsMsg.setGuaranteedStreamUUID(streamId);
            }
            if (jsMsg.getGuaranteedTargetMessagingEngineUUID().equals((Object)this.unknownUuid)) {
                jsMsg.setGuaranteedTargetMessagingEngineUUID(this.targetMEUuid);
            }
            if (tickRange.endstamp > tickRange.valuestamp) {
                jsMsg.setGuaranteedValueEndTick(tickRange.endstamp);
            }
            jsMsg.setGuaranteedValueCompletedPrefix(completedPrefix);
            long waitTime = msgItem.updateStatisticsMessageWaitTime();
            jsMsg.setMessageWaitTime(waitTime);
            if (this.isLink) {
                Object object = msgItem.getSynchUpdateLock();
                synchronized (object) {
                    jsMsg = this.addLinkProps(jsMsg);
                }
            }
            if (this.isSystemOrTemp && jsMsg.getRoutingDestination() == null) {
                jsMsg.setRoutingDestination(this.routingDestination);
            }
            if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                UserTrace.traceOutboundSend(jsMsg, this.routingMEUuid, this.destinationHandler.getName(), this.destinationHandler.isForeignBus() || this.destinationHandler.isLink(), this.destinationHandler.isMQLink(), this.destinationHandler.isTemporary());
            }
            if (requestedOnly) {
                this.mpio.sendToMe(this.routingMEUuid, priority + 1, (AbstractMessage)jsMsg);
                continue;
            }
            this.mpio.sendToMe(this.routingMEUuid, priority, (AbstractMessage)jsMsg);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendValueMessages", expiredMsgs);
        }
        return expiredMsgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAck(ControlAck ackMsg) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAck", (Object)new Object[]{ackMsg});
        }
        List indexList = null;
        SourceStream batchListener = null;
        SourceStreamManager sourceStreamManager = this.sourceStreamManager;
        synchronized (sourceStreamManager) {
            indexList = this.sourceStreamManager.processAck(ackMsg);
            batchListener = this.sourceStreamManager.getBatchListener(ackMsg);
        }
        long index = 0L;
        MessageItem msgItem = null;
        if (indexList != null) {
            TransactionCommon tran = this.sourceBatchHandler.registerInBatch();
            boolean messageAddCall = false;
            try {
                TickRange tr = null;
                for (int i = 0; i < indexList.size(); ++i) {
                    tr = (TickRange)indexList.get(i);
                    batchListener.addToBatchList(tr);
                    index = tr.itemStreamIndex;
                    try {
                        msgItem = (MessageItem)this.transmissionItemStream.findById(index);
                        if (msgItem == null) continue;
                        Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction(tran);
                        msgItem.remove(msTran, msgItem.getLockID());
                        continue;
                    }
                    catch (MessageStoreException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.processAck", (String)"1:1191:1.241", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1198:1.241", e});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"processAck", (Object)((Object)e));
                        }
                        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1209:1.241", e}, null), (Throwable)e);
                    }
                }
                messageAddCall = true;
                this.sourceBatchHandler.messagesAdded(indexList.size(), batchListener);
            }
            finally {
                block19: {
                    if (!messageAddCall) {
                        try {
                            this.sourceBatchHandler.messagesAdded(0);
                        }
                        catch (SIResourceException e) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block19;
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                        }
                    }
                }
            }
        }
        this.sourceStreamManager.attemptFlushIfNecessary();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAck");
        }
    }

    @Override
    public void messageEventOccurred(int event, SIMPMessage msg, TransactionCommon tran) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(event), msg, tran});
        }
        if (event == 9) {
            this.eventPostCommit(msg);
        } else if (event == 2) {
            this.eventPostAdd(msg, tran, false);
        } else if (event == 4) {
            this.eventPostAdd(msg, tran, true);
        } else {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1275:1.241"}, null));
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.messageEventOccurred", (String)"1:1281:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1288:1.241"});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)e));
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    private ControlSilence createSilenceMessage(long tick, long completedPrefix, int priority, Reliability reliability, SIBUuid12 stream) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSilenceMessage", (Object)new Object[]{new Long(tick), new Long(completedPrefix), new Integer(priority), reliability, stream});
        }
        ControlSilence sMsg = null;
        try {
            sMsg = this.cmf.createNewControlSilence();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createSilenceMessage", (String)"1:1327:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1333:1.241", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)e);
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1344:1.241", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)sMsg, this.messageProcessor.getMessagingEngineUuid(), this.targetMEUuid, stream, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
        sMsg.setStartTick(tick);
        sMsg.setEndTick(tick);
        sMsg.setPriority(priority);
        sMsg.setReliability(reliability);
        sMsg.setCompletedPrefix(completedPrefix);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSilenceMessage", (Object)sMsg);
        }
        return sMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eventPostAdd(SIMPMessage msg, TransactionCommon transaction, boolean rollback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostAdd", (Object)new Object[]{msg, transaction, new Boolean(rollback)});
        }
        JsMessage jsMsg = msg.getMessage();
        boolean sendMessage = false;
        sendMessage = rollback ? this.rollbackInsert((MessageItem)msg) : this.commitInsert((MessageItem)msg);
        if (this.isReallocationRequired(msg)) {
            ((BaseDestinationHandler)this.destinationHandler).requestReallocation();
            sendMessage = false;
        }
        if (sendMessage && !rollback) {
            boolean msgLocked = false;
            try {
                msgLocked = msg.lockItemIfAvailable(this.lockID);
                if (!msgLocked && msg.isLocked()) {
                    msgLocked = true;
                }
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.eventPostAdd", (String)"1:1438:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPostAdd", (Object)((Object)e));
                }
                throw new SIResourceException((Throwable)e);
            }
            if (!msgLocked) {
                boolean msgRemoved = this.sourceStreamManager.removeMessage(msg);
                if (msgRemoved) {
                    rollback = true;
                } else {
                    sendMessage = false;
                }
            }
        }
        if (sendMessage) {
            if (rollback) {
                ControlSilence cMsg = this.createSilenceMessage(jsMsg.getGuaranteedValueValueTick(), jsMsg.getGuaranteedValueCompletedPrefix(), msg.getPriority(), msg.getReliability(), msg.getMessage().getGuaranteedStreamUUID());
                if (this.isLink) {
                    cMsg = this.addLinkProps((ControlMessage)cMsg);
                }
                this.mpio.sendToMe(this.routingMEUuid, cMsg.getPriority(), (AbstractMessage)cMsg);
            } else {
                if (this.isLink) {
                    Object cMsg = ((MessageItem)msg).getSynchUpdateLock();
                    synchronized (cMsg) {
                        jsMsg = this.addLinkProps(jsMsg);
                    }
                }
                long waitTime = msg.updateStatisticsMessageWaitTime();
                jsMsg.setMessageWaitTime(waitTime);
                if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
                    UserTrace.traceOutboundSend(jsMsg, this.routingMEUuid, this.destinationHandler.getName(), this.destinationHandler.isForeignBus() || this.destinationHandler.isLink(), this.destinationHandler.isMQLink(), this.destinationHandler.isTemporary());
                }
                this.mpio.sendToMe(this.routingMEUuid, jsMsg.getPriority(), (AbstractMessage)jsMsg);
                msg.releaseJsMessage();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostAdd");
        }
    }

    private void eventPostCommit(SIMPMessage msg) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommit", (Object)msg);
        }
        JsMessage jsMsg = msg.getMessage();
        if (TraceComponent.isAnyTracingEnabled() && UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.traceOutboundSend(jsMsg, this.routingMEUuid, this.destinationHandler.getName(), this.destinationHandler.isForeignBus() || this.destinationHandler.isLink(), this.destinationHandler.isMQLink(), this.destinationHandler.isTemporary());
        }
        this.mpio.sendToMe(this.routingMEUuid, msg.getPriority(), (AbstractMessage)jsMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommit");
        }
    }

    public String toString() {
        return "PtoPOutputHandler: " + this.destinationHandler.getName() + " on " + this.transmissionItemStream.getLocalizingMEUuid().toString();
    }

    @Override
    public SIBUuid8 getTargetMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTargetMEUuid", (Object)this.transmissionItemStream.getLocalizingMEUuid());
        }
        return this.transmissionItemStream.getLocalizingMEUuid();
    }

    public SIBUuid8 getRoutingMEUuid() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRoutingMEUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRoutingMEUuid", (Object)this.routingMEUuid);
        }
        return this.routingMEUuid;
    }

    @Override
    public boolean commitInsert(MessageItem msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"commitInsert", (Object)msg);
        }
        boolean updated = this.updateSourceStream(msg, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"commitInsert", (Object)new Boolean(updated));
        }
        return updated;
    }

    @Override
    public boolean rollbackInsert(MessageItem msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rollbackInsert", (Object)msg);
        }
        boolean updated = this.updateSourceStream(msg, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rollbackInsert", (Object)new Boolean(updated));
        }
        return updated;
    }

    protected void handleRollback(LocalTransaction transaction) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)transaction);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleRollback", (String)"1:1644:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public boolean isReallocationRequired(SIMPMessage msg) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isReallocationRequired", (Object)msg);
        }
        boolean reallocate = false;
        reallocate = this.sourceStreamManager.isReallocationRequired(msg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isReallocationRequired");
        }
        return reallocate;
    }

    public boolean updateSourceStream(MessageItem msg, boolean rollback) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateSourceStream", (Object)new Object[]{msg, new Boolean(rollback)});
        }
        boolean sendMessage = true;
        sendMessage = this.sourceStreamManager.updateSourceStream(msg, rollback);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateSourceStream");
        }
        return sendMessage;
    }

    private ControlFlushed createControlFlushed(SIBUuid12 stream) throws SIResourceException {
        ControlFlushed flushedMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlFlushed", (Object)new Object[]{stream});
        }
        try {
            flushedMsg = this.cmf.createNewControlFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createControlFlushed", (String)"1:1730:1.241", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1742:1.241", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1750:1.241", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)flushedMsg, this.messageProcessor.getMessagingEngineUuid(), this.targetMEUuid, stream, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
        flushedMsg.setPriority(11);
        flushedMsg.setReliability(Reliability.ASSURED_PERSISTENT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlFlushed");
        }
        return flushedMsg;
    }

    private ControlNotFlushed createControlNotFlushed(SIBUuid12 stream, long reqID) throws SIResourceException {
        ControlNotFlushed notFlushedMsg;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlNotFlushed", (Object)new Object[]{stream, new Long(reqID)});
        }
        try {
            notFlushedMsg = this.cmf.createNewControlNotFlushed();
        }
        catch (MessageCreateFailedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.createControlNotFlushed", (String)"1:1803:1.241", (Object)this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed", (Object)((Object)e));
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1815:1.241", e});
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1823:1.241", e}, null), (Throwable)e);
        }
        SIMPUtils.setGuaranteedDeliveryProperties((ControlMessage)notFlushedMsg, this.messageProcessor.getMessagingEngineUuid(), this.targetMEUuid, stream, null, this.destinationHandler.getUuid(), ProtocolType.UNICASTINPUT, GDConfig.PROTOCOL_VERSION);
        notFlushedMsg.setPriority(11);
        notFlushedMsg.setReliability(Reliability.ASSURED_PERSISTENT);
        notFlushedMsg.setRequestID(reqID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlNotFlushed");
        }
        return notFlushedMsg;
    }

    public void reconstitutePtoPSourceStreams(StreamSet streamSet, int startMode) throws SIRollbackException, SIConnectionLostException, SIResourceException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)new Object[]{streamSet, new Integer(startMode)});
        }
        this.sourceStreamManager.reconstituteStreamSet(streamSet);
        if ((startMode & 1) == 1 && (startMode & 2) == 0) {
            this.sendFlushedMessage(null, streamSet.getStreamID());
            streamSet.setStreamID(new SIBUuid12());
            ExternalAutoCommitTransaction tran = this.messageProcessor.getTXManager().createAutoCommitTransaction();
            try {
                streamSet.requestUpdate((Transaction)tran);
            }
            catch (MessageStoreException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reconstitutePtoPSourceStreams", (String)"1:1883:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)"SIStoreException");
                }
                throw new SIResourceException((Throwable)e);
            }
        }
        NonLockingCursor cursor = null;
        try {
            cursor = this.transmissionItemStream.newNonLockingItemCursor(new ClassEqualsFilter(MessageItem.class));
            cursor.allowUnavailableItems();
            MessageItem msg = (MessageItem)cursor.next();
            while (msg != null) {
                if (msg.getGuaranteedStreamUuid() != streamSet.getStreamID()) {
                    msg.setGuaranteedStreamUuid(streamSet.getStreamID());
                }
                if (!msg.isAdding() && !msg.isRemoving()) {
                    this.sourceStreamManager.restoreMessage(msg, true);
                } else {
                    this.sourceStreamManager.restoreMessage(msg, false);
                }
                msg = (MessageItem)cursor.next();
            }
            List msgsToLock = this.sourceStreamManager.consolidateStreams(startMode);
            long msgId = 0L;
            MessageItem msgItem = null;
            for (int i = 0; i < msgsToLock.size(); ++i) {
                msgId = (Long)msgsToLock.get(i);
                msgItem = (MessageItem)this.transmissionItemStream.findById(msgId);
                if (msgItem != null) {
                    msgItem.lockItemIfAvailable(this.lockID);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)"message wasn't there when we tried to lock it");
            }
        }
        catch (MessageStoreException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reconstitutePtoPSourceStreams", (String)"1:1956:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1963:1.241", e});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams", (Object)((Object)e));
            }
            throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:1974:1.241", e}, null), (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.finished();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitutePtoPSourceStreams");
        }
    }

    @Override
    public void sendFlushedMessage(SIBUuid8 ignoreUuid, SIBUuid12 streamID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendFlushedMessage", (Object)new Object[]{ignoreUuid, streamID});
        }
        ControlFlushed flushMsg = this.createControlFlushed(streamID);
        if (this.isLink) {
            flushMsg = (ControlFlushed)this.addLinkProps((ControlMessage)flushMsg);
        }
        if (this.isSystemOrTemp) {
            flushMsg.setRoutingDestination(this.routingDestination);
        }
        this.mpio.sendToMe(this.routingMEUuid, 9, (AbstractMessage)flushMsg);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendFlushedMessage");
        }
    }

    @Override
    public void sendNotFlushedMessage(SIBUuid8 ignore, SIBUuid12 streamID, long requestID) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendNotFlushedMessage", (Object)new Object[]{ignore, streamID, new Long(requestID)});
        }
        ControlNotFlushed notFlushed = this.createControlNotFlushed(streamID, requestID);
        notFlushed = this.sourceStreamManager.stampNotFlushed(notFlushed);
        if (this.isLink) {
            notFlushed = (ControlNotFlushed)this.addLinkProps((ControlMessage)notFlushed);
            notFlushed.setRoutingDestination(this.routingDestination);
        } else if (this.isSystemOrTemp) {
            notFlushed.setRoutingDestination(this.routingDestination);
        }
        this.mpio.sendToMe(this.routingMEUuid, 9, (AbstractMessage)notFlushed);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendNotFlushedMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void reallocateMsgs(DestinationHandler destination, boolean allMsgs, boolean forceRemove) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateMsgs", (Object)new Object[]{this.toString(), destination, new Boolean(allMsgs), new Boolean(forceRemove)});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Reallocating messages queued for " + destination.getName() + " from ME " + this.messageProcessor.getMessagingEngineUuid() + " to ME " + this.targetMEUuid));
        }
        ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = null;
        LocalTransaction transaction = null;
        int transactionSize = -1;
        boolean streamCanSendMsgs = true;
        LockManager reallocationLock = ((BaseDestinationHandler)destination).getReallocationLockManager();
        reallocationLock.lockExclusive();
        reallocationLock.unlockExclusive();
        PtoPOutputHandler ptoPOutputHandler = this;
        synchronized (ptoPOutputHandler) {
            StreamSet streamSet = this.sourceStreamManager.getStreamSet();
            if (streamSet == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs");
                }
                return;
            }
            Iterator<Stream> stream_it = streamSet.iterator();
            while (stream_it.hasNext()) {
                transactionSize = 0;
                transaction = destination.getTxManager().createLocalTransaction(false);
                SourceStream stream = (SourceStream)stream_it.next();
                boolean streamStateChecked = false;
                boolean oldGuessState = stream.containsGuesses();
                stream.guessesInStream();
                List indexList = null;
                indexList = allMsgs ? stream.getAllMessagesOnStream() : stream.getMessagesAfterSendWindow();
                ArrayList<MessageItem> markedForSilence = new ArrayList<MessageItem>();
                Iterator indexList_it = indexList.iterator();
                long index = -1L;
                while (indexList_it.hasNext()) {
                    void var21_25;
                    index = (Long)indexList_it.next();
                    MessageItem msg = null;
                    try {
                        msg = (MessageItem)this.transmissionItemStream.findById(index);
                    }
                    catch (MessageStoreException messageStoreException) {
                        FFDCFilter.processException((Throwable)messageStoreException, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reallocateMsgs", (String)"1:2168:1.241", (Object)this);
                        SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                        try {
                            transaction.rollback();
                        }
                        catch (SIException ee) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)ee));
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs", (Object)((Object)messageStoreException));
                        }
                        return;
                    }
                    if (msg == null) continue;
                    streamStateChecked = true;
                    DestinationHandler destinationHandler = destination;
                    OutputHandler outputHandler = null;
                    streamCanSendMsgs = false;
                    boolean removeMsg = true;
                    boolean sendToInputHandler = false;
                    boolean newStreamIsGuess = false;
                    if (!destination.isToBeDeleted()) {
                        SIBUuid8 fixedME;
                        block48: {
                            fixedME = null;
                            JsDestinationAddress jsDestinationAddress = msg.getMessage().getRoutingDestination();
                            if (jsDestinationAddress != null && (fixedME = jsDestinationAddress.getME()) == null) {
                                try {
                                    DestinationHandler routingDestHandler = this.messageProcessor.getDestinationManager().getDestination(jsDestinationAddress, false);
                                    if (routingDestHandler.isAlias()) {
                                        DestinationHandler destinationHandler2 = routingDestHandler;
                                    }
                                }
                                catch (SIException e) {
                                    if (!TraceComponent.isAnyTracingEnabled()) break block48;
                                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                }
                            }
                        }
                        if ((outputHandler = var21_25.choosePtoPOutputHandler(fixedME, this.transmissionItemStream.getLocalizingMEUuid(), !msg.isFromRemoteME(), false, null)) != null) {
                            newStreamIsGuess = outputHandler.isWLMGuess();
                            if (outputHandler == this) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Leaving message " + msg.getMessage().getSystemMessageId() + " on this stream (" + newStreamIsGuess + ")"));
                                }
                                streamCanSendMsgs = !newStreamIsGuess;
                                removeMsg = false;
                                if (fixedME == null && var21_25.equals(destination)) {
                                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                                    SibTr.debug((TraceComponent)tc, (String)"Exiting reallocate due to no better options");
                                    break;
                                }
                            } else {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Reallocating message " + msg.getMessage().getSystemMessageId() + " to alternative ME"));
                                }
                                sendToInputHandler = true;
                            }
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("Leaving message " + msg.getMessage().getSystemMessageId() + " on this stream due to no OutputHandler!"));
                            }
                            removeMsg = false;
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Discarding message " + msg.getMessage().getSystemMessageId() + " due to deleted queue"));
                        }
                        if (!this.messageProcessor.discardMsgsAfterQueueDeletion()) {
                            UndeliverableReturnCode undeliverableReturnCode;
                            if (exceptionDestinationHandlerImpl == null) {
                                exceptionDestinationHandlerImpl = (ExceptionDestinationHandlerImpl)this.messageProcessor.createExceptionDestinationHandler(null);
                            }
                            String destName = this.destinationHandler.getName();
                            if (this.destinationHandler.isLink()) {
                                destName = ((LinkHandler)this.destinationHandler).getBusName();
                            }
                            if ((undeliverableReturnCode = exceptionDestinationHandlerImpl.handleUndeliverableMessage(msg, (TransactionCommon)transaction, 32, new String[]{destName, this.messageProcessor.getMessagingEngineName()})) == UndeliverableReturnCode.ERROR || undeliverableReturnCode == UndeliverableReturnCode.BLOCK) {
                                SIErrorException e = new SIErrorException(nls.getFormattedMessage("DESTINATION_DELETED_ERROR_CWSIP0550", new Object[]{this.destinationHandler.getName(), this.destinationHandler.getUuid().toString()}, null));
                                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.reallocateMsgs", (String)"1:2372:1.241", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                                removeMsg = false;
                                break;
                            }
                            ++transactionSize;
                        }
                    }
                    if (sendToInputHandler) {
                        InputHandler inputHandler = var21_25.getInputHandler(ProtocolType.UNICASTINPUT, null, msg.getMessage());
                        try {
                            JsMessage jsMessage = msg.getMessage().getReceived();
                            MessageItem messageItem = new MessageItem(jsMessage);
                            messageItem.setPreferLocal(msg.preferLocal());
                            inputHandler.handleMessage(messageItem, (TransactionCommon)transaction, this.messageProcessor.getMessagingEngineUuid());
                            ++transactionSize;
                        }
                        catch (SIException sIException) {
                            this.handleReallocationFailure((Exception)((Object)sIException), destination, transaction);
                        }
                        catch (MessageCopyFailedException messageCopyFailedException) {
                            this.handleReallocationFailure((Exception)((Object)messageCopyFailedException), destination, transaction);
                        }
                    }
                    if (removeMsg || forceRemove) {
                        Transaction msTran = this.messageProcessor.resolveAndEnlistMsgStoreTransaction((TransactionCommon)transaction);
                        try {
                            msg.remove(msTran, msg.getLockID());
                            ++transactionSize;
                            markedForSilence.add(msg);
                        }
                        catch (MessageStoreException messageStoreException) {
                            this.handleReallocationFailure((Exception)((Object)messageStoreException), destination, transaction);
                        }
                    }
                    if (transactionSize <= 100) continue;
                    try {
                        transaction.commit();
                        transaction = destination.getTxManager().createLocalTransaction(false);
                        transactionSize = 0;
                        for (SIMPMessage sIMPMessage : markedForSilence) {
                            stream.writeSilenceForced(sIMPMessage);
                        }
                        markedForSilence = new ArrayList();
                    }
                    catch (SIException e) {
                        this.handleReallocationFailure((Exception)((Object)e), destination, transaction);
                    }
                }
                try {
                    transaction.commit();
                    for (SIMPMessage sIMPMessage : markedForSilence) {
                        stream.writeSilenceForced(sIMPMessage);
                    }
                }
                catch (SIException e) {
                    this.handleReallocationFailure((Exception)((Object)e), destination, transaction);
                }
                if (!streamStateChecked) {
                    boolean bl = streamCanSendMsgs = !oldGuessState;
                }
                if (!streamCanSendMsgs) continue;
                stream.noGuessesInStream();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs");
        }
    }

    private void handleReallocationFailure(Exception e, DestinationHandler destination, LocalTransaction transaction) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleReallocationFailure", (Object)new Object[]{e, destination, transaction});
        }
        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleReallocationFailure", (String)"1:2512:1.241", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)e);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleReallocationFailure", (Object)e);
        }
        if (transaction != null) {
            try {
                transaction.rollback();
            }
            catch (SIException ee) {
                FFDCFilter.processException((Throwable)ee, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.handleReallocationFailure", (String)"1:2533:1.241", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)ee));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2540:1.241", ee, destination.getName()});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"handleReallocationFailure", (Object)"SIStoreException");
                }
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2552:1.241", ee, destination.getName()}, null), (Throwable)ee);
            }
        }
        throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.impl.PtoPOutputHandler", "1:2565:1.241", e, destination.getName()}, null), (Throwable)e);
    }

    @Override
    public boolean isWLMGuess() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isWLMGuess");
            SibTr.exit((TraceComponent)tc, (String)"isWLMGuess", (Object)this.isGuess);
        }
        return this.isGuess;
    }

    @Override
    public void setWLMGuess(boolean guess) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setWLMGuess", (Object)new Boolean(guess));
        }
        this.isGuess = guess;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setWLMGuess");
        }
    }

    @Override
    public boolean isQHighLimit() {
        boolean limited;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        if ((limited = this.transmissionItemStream.isQHighLimit()) && !this._qHigh) {
            this._qHigh = true;
            this.sourceStreamManager.getStreamSetRuntimeControl().getHealthState().updateHealth(HealthStateListener.STREAM_FULL_STATE, 1);
            this.am.create(5000L, new AlarmListener(){

                public void alarm(Object arg0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.entry((TraceComponent)tc, (String)"alarm");
                    }
                    if (!PtoPOutputHandler.this.isQHighLimit()) {
                        PtoPOutputHandler.this._qHigh = false;
                        PtoPOutputHandler.this.sourceStreamManager.getStreamSetRuntimeControl().getHealthState().updateHealth(HealthStateListener.STREAM_FULL_STATE, 2);
                    } else {
                        PtoPOutputHandler.this.am.create(5000L, this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"alarm");
                    }
                }
            });
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)new Boolean(limited));
        }
        return limited;
    }

    public void updateTargetCellule(SIBUuid8 targetMEUuid) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateTargetCellule", (Object)targetMEUuid);
        }
        this.targetMEUuid = targetMEUuid;
        this.sourceStreamManager.updateTargetCellule(targetMEUuid);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateTargetCellule");
        }
    }

    public void updateRoutingCellule(SIBUuid8 routingME) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateRoutingCellule", (Object)routingME);
        }
        this.routingMEUuid = routingME;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateRoutingCellule");
        }
    }

    public SourceStreamManager getSourceStreamManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSourceStreamManager");
            SibTr.exit((TraceComponent)tc, (String)"getSourceStreamManager", (Object)this.sourceStreamManager);
        }
        return this.sourceStreamManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushAllForDelete() throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"flushAllForDelete");
        }
        PtoPOutputHandler ptoPOutputHandler = this;
        synchronized (ptoPOutputHandler) {
            if (this.flushedForDeleteSource) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.TRUE);
                }
                return true;
            }
            if (this.deleteFlushSource != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.FALSE);
                }
                return false;
            }
            final PtoPOutputHandler psOH = this;
            this.deleteFlushSource = new FlushComplete(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void flushComplete(DestinationHandler destinationHandler) {
                    PtoPOutputHandler ptoPOutputHandler = psOH;
                    synchronized (ptoPOutputHandler) {
                        psOH.flushedForDeleteSource = true;
                        psOH.deleteFlushSource = null;
                    }
                    psOH.messageProcessor.getDestinationManager().startAsynchDeletion();
                }
            };
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)("Started PtoP source flush for destination: " + this.destinationHandler.getName()));
            }
            this.startFlush(this.deleteFlushSource);
        }
        catch (FlushAlreadyInProgressException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.impl.PtoPOutputHandler.flushAllForDelete", (String)"1:2756:1.241", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)"FlushAlreadyInProgressException");
            }
            throw new SIResourceException((Throwable)e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"flushAllForDelete", (Object)Boolean.FALSE);
        }
        return false;
    }

    @Override
    public long handleControlMessageWithReturnValue(SIBUuid8 sourceMEUuid, ControlMessage cMsg) throws SIIncorrectCallException, SIResourceException, SIConnectionLostException, SIRollbackException {
        return 0L;
    }
}

