/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.main;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ras.instrument.internal.bci.LibertyTracingClassAdapter;
import com.ibm.ws.ras.instrument.internal.main.ComputeRequiredException;
import com.ibm.ws.ras.instrument.internal.main.FileLogger;
import com.ibm.ws.ras.instrument.internal.main.LibertyJava8WorkaroundRuntimeTransformer;
import io.openliberty.asm.ASMHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceClassVisitor;

public class LibertyRuntimeTransformer
implements ClassFileTransformer {
    public static final String CLASS_NAME = "RuntimeTransformer";
    private static final TraceComponent tc;
    private static final boolean isIBMVirtualMachine;
    private static final boolean isSunVirtualMachine;
    private static final boolean detailedTransformTrace;
    private static Instrumentation instrumentation;
    private static LibertyRuntimeTransformer registeredTransformer;
    private static Map<Class<?>, WeakReference<TraceComponent>> traceComponentByClass;
    private static boolean injectAtTransform;
    private static boolean skipDebugData;
    private static final Boolean isJDK8WithHotReplaceBug;

    public static boolean isLoggableClassName(String className) {
        return FileLogger.isLoggableClassName(className);
    }

    public static boolean isLoggablePath(String path) {
        return FileLogger.isLoggablePath(path);
    }

    public static PrintWriter fileWriter() {
        return FileLogger.fileWriter();
    }

    public static void fileLog(String methodName, String text) {
        FileLogger.fileLog(CLASS_NAME, methodName, text);
    }

    public static void fileLog(String methodName, String text, Object value) {
        FileLogger.fileLog(CLASS_NAME, methodName, text, value);
    }

    public static void fileDump(String methodName, String text, byte[] bytes) {
        FileLogger.fileDump(CLASS_NAME, methodName, text, bytes);
    }

    public static void fileStack(String methodName, String text, Throwable th) {
        FileLogger.fileStack(CLASS_NAME, methodName, text, th);
    }

    public static synchronized void setInstrumentation(Instrumentation inst) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setInstrumentation", (Object[])new Object[]{inst});
        }
        if ((instrumentation = inst) != null) {
            if (Boolean.getBoolean("com.ibm.websphere.ras.inject.at.transform")) {
                LibertyRuntimeTransformer.setInjectAtTransform(true);
            } else if (!instrumentation.isRetransformClassesSupported()) {
                Tr.info((TraceComponent)tc, (String)"INSTRUMENTATION_RETRANSFORM_NOT_SUPPORTED", (Object[])new Object[0]);
                LibertyRuntimeTransformer.setInjectAtTransform(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setInstrumentation");
        }
    }

    protected static void setInjectAtTransform(boolean injectAtTransform) {
        LibertyRuntimeTransformer.injectAtTransform = injectAtTransform;
        if (injectAtTransform) {
            LibertyRuntimeTransformer.addTransformer();
        }
    }

    protected static void setSkipDebugData(boolean skipDebugData) {
        LibertyRuntimeTransformer.skipDebugData = skipDebugData;
    }

    private static synchronized void addTransformer() {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addTransformer", (Object[])new Object[0]);
        }
        if (registeredTransformer == null && instrumentation != null) {
            registeredTransformer = new LibertyRuntimeTransformer();
            instrumentation.addTransformer(registeredTransformer, true);
            LibertyRuntimeTransformer.fileLog("addTransformer", "Transformer", registeredTransformer);
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addTransformer");
        }
    }

    private static String isTransformPossible(byte[] bytes) {
        if (bytes.length < 8) {
            return "Incomplete class bytes [ " + bytes.length + " ]";
        }
        int classFileVersion = (bytes[6] & 0xFF) << 8 | bytes[7] & 0xFF;
        if (isJDK8WithHotReplaceBug.booleanValue()) {
            if (classFileVersion > 51) {
                return "HotReplaceBug: Class version [ " + classFileVersion + " ] Maximum [ " + 51 + " ]";
            }
            return null;
        }
        if (classFileVersion > ASMHelper.getMaximumJavaLevel()) {
            return "Class version [ " + classFileVersion + " ] Maximum [ " + ASMHelper.getMaximumJavaLevel() + " ]";
        }
        return null;
    }

    public static void traceStateChanged(TraceComponent traceComponent) {
        Class traceClass;
        if (instrumentation == null) {
            return;
        }
        if (!injectAtTransform && traceComponent.isEntryEnabled() && (traceClass = traceComponent.getTraceClass()) != null && traceClass != LibertyRuntimeTransformer.class) {
            LibertyRuntimeTransformer.addTransformer();
            traceComponentByClass.put(traceClass, new WeakReference<TraceComponent>(traceComponent));
            LibertyRuntimeTransformer.retransformClass(traceClass);
        }
    }

    private static final void retransformClass(Class<?> clazz) {
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retransformClass", (Object[])new Object[]{clazz});
        }
        try {
            instrumentation.retransformClasses(clazz);
        }
        catch (Throwable t) {
            Tr.error((TraceComponent)tc, (String)"INSTRUMENTATION_TRANSFORM_FAILED_FOR_CLASS_2", (Object[])new Object[]{clazz.getName(), t});
        }
        if (detailedTransformTrace && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retransformClass");
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] initialBytes) throws IllegalClassFormatException {
        byte[] finalBytes;
        String methodName = "transform";
        boolean isLoggable = LibertyRuntimeTransformer.isLoggableClassName(className);
        String failureReason = LibertyRuntimeTransformer.isTransformPossible(initialBytes);
        if (failureReason != null) {
            if (isLoggable) {
                LibertyRuntimeTransformer.fileLog(methodName, "Ignore [ " + className + " ]: " + failureReason);
            }
            return null;
        }
        boolean traceEnabledForClass = injectAtTransform;
        if (!injectAtTransform && classBeingRedefined != null) {
            WeakReference<TraceComponent> tcReference = traceComponentByClass.get(classBeingRedefined);
            TraceComponent traceComponent = tcReference == null ? null : (TraceComponent)tcReference.get();
            traceEnabledForClass |= traceComponent != null && traceComponent.isEntryEnabled();
        }
        if (!traceEnabledForClass) {
            if (isLoggable) {
                LibertyRuntimeTransformer.fileLog(methodName, "Ignore: Trace not enabled for class", className);
            }
            return null;
        }
        if (isLoggable) {
            LibertyRuntimeTransformer.fileLog(methodName, "Class", className);
            LibertyRuntimeTransformer.fileDump(methodName, "Initial bytes", initialBytes);
        }
        try {
            finalBytes = LibertyRuntimeTransformer.transform(className, initialBytes);
        }
        catch (Throwable t) {
            LibertyRuntimeTransformer.fileStack(methodName, "Transform failure [ " + className + " ]", t);
            Tr.error((TraceComponent)tc, (String)"INSTRUMENTATION_TRANSFORM_FAILED_FOR_CLASS_2", (Object[])new Object[]{className, t});
            return null;
        }
        if (isLoggable && finalBytes != null) {
            LibertyRuntimeTransformer.fileDump(methodName, "Final bytes", finalBytes);
        }
        return finalBytes;
    }

    public static byte[] transform(String className, byte[] bytes) throws IOException {
        return LibertyRuntimeTransformer.transform(className, bytes, true);
    }

    public static byte[] transform(byte[] bytes, boolean skipIfNotPreprocessed) throws IOException {
        return LibertyRuntimeTransformer.transform(null, bytes, skipIfNotPreprocessed);
    }

    public static byte[] transform(String className, byte[] classBytes, boolean skipIfNotPreprocessed) throws IOException {
        boolean isModified;
        String methodName = "transform";
        String debugClassName = className != null ? className : "**UNKNOWN**";
        boolean isLoggable = className != null && LibertyRuntimeTransformer.isLoggableClassName(className);
        boolean isDumpable = tc.isDumpEnabled();
        ClassReader classReader = new ClassReader(classBytes);
        ClassWriter classWriter = new ClassWriter(classReader, 1);
        PrintWriter traceWriter = isLoggable ? LibertyRuntimeTransformer.fileWriter() : null;
        StringWriter baseDumpWriter = isDumpable ? new StringWriter() : null;
        PrintWriter dumpWriter = isDumpable ? new PrintWriter(baseDumpWriter) : null;
        ClassVisitor classVisitor = LibertyRuntimeTransformer.addLogging(classWriter, traceWriter, dumpWriter);
        try {
            try {
                isModified = LibertyRuntimeTransformer.visit(classReader, classVisitor, true, skipIfNotPreprocessed);
            }
            catch (ComputeRequiredException e) {
                classReader = new ClassReader(classBytes);
                classWriter = new ClassWriter(classReader, 2);
                traceWriter = isLoggable ? LibertyRuntimeTransformer.fileWriter() : null;
                baseDumpWriter = isDumpable ? new StringWriter() : null;
                dumpWriter = isDumpable ? new PrintWriter(baseDumpWriter) : null;
                classVisitor = LibertyRuntimeTransformer.addLogging(classWriter, traceWriter, dumpWriter);
                isModified = LibertyRuntimeTransformer.visit(classReader, classVisitor, false, skipIfNotPreprocessed);
            }
        }
        catch (Throwable t) {
            LibertyRuntimeTransformer.fileStack(methodName, "Trace instrumentation failure [ " + debugClassName + " ]", t);
            throw new IOException("Trace instrumentation failure [ " + debugClassName + " ]: " + t.getMessage(), t);
        }
        if (isDumpable && isModified) {
            Tr.dump((TraceComponent)tc, (String)("Transformed class [ " + debugClassName + " ]"), (Object[])new Object[]{baseDumpWriter});
        }
        if (isLoggable) {
            LibertyRuntimeTransformer.fileLog(methodName, "IsModified [ " + debugClassName + " ]", isModified);
        }
        return !isModified ? null : classWriter.toByteArray();
    }

    private static ClassVisitor addLogging(ClassWriter classWriter, PrintWriter traceWriter, PrintWriter dumpWriter) {
        ClassWriter classVisitor = classWriter;
        if (traceWriter != null || dumpWriter != null) {
            classVisitor = new CheckClassAdapter((ClassVisitor)classVisitor, false);
        }
        if (traceWriter != null) {
            classVisitor = new TraceClassVisitor((ClassVisitor)classVisitor, traceWriter);
        }
        if (dumpWriter != null) {
            classVisitor = new TraceClassVisitor((ClassVisitor)classVisitor, dumpWriter);
        }
        return classVisitor;
    }

    protected static boolean visit(ClassReader classReader, ClassVisitor classVisitor, boolean throwComputeFrames, boolean skipIfNotPreprocessed) throws ComputeRequiredException {
        LibertyTracingClassAdapter traceVisitor = new LibertyTracingClassAdapter(classVisitor, throwComputeFrames, skipIfNotPreprocessed);
        classReader.accept((ClassVisitor)traceVisitor, skipDebugData ? 2 : 0);
        return traceVisitor.isClassModified();
    }

    static {
        LibertyRuntimeTransformer.fileLog("<init>", "Initializing");
        tc = Tr.register(LibertyRuntimeTransformer.class, (String)"logging", (String)"com.ibm.ws.logging.internal.resources.LoggingMessages");
        isIBMVirtualMachine = System.getProperty("java.vm.name", "unknown").contains("IBM J9") || System.getProperty("java.vm.name", "unknown").contains("OpenJ9");
        isSunVirtualMachine = System.getProperty("java.vm.name", "unknown").contains("HotSpot");
        detailedTransformTrace = Boolean.getBoolean("com.ibm.ws.logging.instrumentation.detail.enabled");
        traceComponentByClass = Collections.synchronizedMap(new WeakHashMap());
        isJDK8WithHotReplaceBug = LibertyJava8WorkaroundRuntimeTransformer.checkJDK8WithHotReplaceBug() != false ? Boolean.TRUE : Boolean.FALSE;
    }
}

