/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.internal.commands;

import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumpAction;
import com.ibm.ws.kernel.boot.internal.commands.JavaDumper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class HotSpotJavaDumperImpl
extends JavaDumper {
    private static final String PID = HotSpotJavaDumperImpl.getPID();
    private static final AtomicInteger nextSequenceNumber = new AtomicInteger(1);
    private final MBeanServer platformMBeanServer;
    private final ObjectName hotSpotDiagnosticName;
    private final ObjectName diagnosticCommandName;
    private VirtualMachine vm;

    private static String getPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        if (index == -1) {
            return null;
        }
        String pid = name.substring(0, index);
        if (!pid.matches("[0-9]+")) {
            return null;
        }
        return pid;
    }

    HotSpotJavaDumperImpl(MBeanServer platformMBeanServer, ObjectName diagName, ObjectName diagCommandName) {
        this.platformMBeanServer = platformMBeanServer;
        this.hotSpotDiagnosticName = diagName;
        this.diagnosticCommandName = diagCommandName;
    }

    @Override
    public File dump(JavaDumpAction action, File outputDir) {
        switch (action) {
            case HEAP: {
                return this.createHeapDump(outputDir);
            }
            case THREAD: {
                return this.createThreadDump(outputDir);
            }
        }
        return null;
    }

    private File createNewFile(File outputDir, String prefix, String extension) throws IOException {
        int sequenceNumber;
        String pid;
        File outputFile;
        String dateTime = new SimpleDateFormat("yyyyMMdd.HHmmss").format(new Date());
        while ((outputFile = new File(outputDir, String.format("%s.%s.%s%04d.%s", prefix, dateTime, pid = PID == null ? "" : PID + '.', sequenceNumber = nextSequenceNumber.getAndIncrement(), extension))).exists()) {
        }
        return outputFile;
    }

    private File createHeapDump(File outputDir) {
        File outputFile;
        if (this.hotSpotDiagnosticName == null) {
            return null;
        }
        try {
            outputFile = this.createNewFile(outputDir, "java", "hprof");
            this.platformMBeanServer.invoke(this.hotSpotDiagnosticName, "dumpHeap", new Object[]{outputFile.getAbsolutePath(), false}, new String[]{String.class.getName(), Boolean.TYPE.getName()});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return outputFile;
    }

    private File createThreadDump(File outputDir) {
        VirtualMachine vm;
        block14: {
            vm = null;
            try {
                vm = this.getAttachedVirtualMachine();
                if (vm == null && this.diagnosticCommandName == null) {
                    return null;
                }
            }
            catch (VirtualMachineException e) {
                if (this.diagnosticCommandName != null) break block14;
                Throwable cause = e.getCause();
                throw cause instanceof RuntimeException ? (RuntimeException)cause : new RuntimeException(cause);
            }
        }
        File outputFile = null;
        InputStream input = null;
        OutputStream output = null;
        boolean success = false;
        try {
            outputFile = this.createNewFile(outputDir, "javadump", "txt");
            if (vm != null) {
                int read;
                input = vm.remoteDataDump();
                input = new BufferedInputStream(input);
                output = new FileOutputStream(outputFile);
                output = new BufferedOutputStream(output);
                byte[] buf = new byte[8192];
                while ((read = input.read(buf)) != -1) {
                    output.write(buf, 0, read);
                }
            } else {
                String outputString;
                try {
                    outputString = (String)this.platformMBeanServer.invoke(this.diagnosticCommandName, "threadPrint", new Object[]{new String[]{"-l"}}, new String[]{String[].class.getName()});
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                output = new FileOutputStream(outputFile);
                OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);
                writer.write(outputString);
                ((Writer)writer).close();
            }
            success = true;
        }
        catch (IOException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                Utils.tryToClose(input);
                Utils.tryToClose(output);
                if (!success && outputFile != null && !outputFile.delete()) {
                    outputFile = null;
                }
                throw throwable;
            }
        }
        Utils.tryToClose(input);
        Utils.tryToClose(output);
        if (!success && outputFile != null && !outputFile.delete()) {
            outputFile = null;
        }
        return outputFile;
    }

    private synchronized VirtualMachine getAttachedVirtualMachine() throws VirtualMachineException {
        if (PID == null) {
            return null;
        }
        if (this.vm == null) {
            this.vm = this.createVirtualMachine();
        }
        return this.vm.isAttached() ? this.vm : null;
    }

    private VirtualMachine createVirtualMachine() throws VirtualMachineException {
        ClassLoader toolsClassLoader;
        File toolsJar = HotSpotJavaDumperImpl.getToolsJar();
        if (toolsJar == null) {
            toolsClassLoader = HotSpotJavaDumperImpl.class.getClassLoader();
        } else {
            try {
                toolsClassLoader = new URLClassLoader(new URL[]{toolsJar.getAbsoluteFile().toURI().toURL()});
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> vmClass = toolsClassLoader.loadClass("com.sun.tools.attach.VirtualMachine");
            Method attachMethod = vmClass.getMethod("attach", String.class);
            Object toolsVM = attachMethod.invoke(null, PID);
            Method remoteDataDumpMethod = toolsVM.getClass().getMethod("remoteDataDump", Object[].class);
            return new VirtualMachine(toolsVM, remoteDataDumpMethod);
        }
        catch (ClassNotFoundException vmClass) {
        }
        catch (InvocationTargetException e) {
            throw new VirtualMachineException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new VirtualMachine(null, null);
    }

    private static File getToolsJar() {
        String javaHome = System.getProperty("java.home");
        File file = new File(javaHome, "../lib/tools.jar");
        if (!file.exists() && !(file = new File(javaHome, "lib/tools.jar")).exists()) {
            return null;
        }
        return file;
    }

    private static class VirtualMachine {
        private final Object vm;
        private final Method remoteDataDumpMethod;

        VirtualMachine(Object vm, Method remoteDataDumpMethod) {
            this.vm = vm;
            this.remoteDataDumpMethod = remoteDataDumpMethod;
        }

        public boolean isAttached() {
            return this.vm != null;
        }

        public InputStream remoteDataDump() throws IOException {
            try {
                Object[] dumpArgs = new Object[]{"-l"};
                return (InputStream)this.remoteDataDumpMethod.invoke(this.vm, new Object[]{dumpArgs});
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException(cause);
            }
        }
    }

    private static class VirtualMachineException
    extends Exception {
        VirtualMachineException(Throwable cause) {
            super(cause);
        }
    }
}

