/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.context.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.UnauthenticatedSubjectService;
import com.ibm.ws.security.context.internal.SecurityContextImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import com.ibm.wsspi.threadcontext.ThreadContextProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ThreadContextProvider.class}, name="com.ibm.ws.security.context.provider", configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class SecurityContextProviderImpl
implements ThreadContextProvider {
    static final String KEY_CONFIGURATION_ADMIN = "configurationAdmin";
    public static final String KEY_SECURITY_SERVICE = "securityService";
    static final String KEY_UNAUTH_SERVICE = "unauthenticatedSubjectService";
    static final String KEY_NAME = "name";
    private final AtomicServiceReference<ConfigurationAdmin> configAdminRef = new AtomicServiceReference("configurationAdmin");
    protected final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    private final AtomicServiceReference<UnauthenticatedSubjectService> unauthenticatedSubjectServiceRef = new AtomicServiceReference("unauthenticatedSubjectService");
    static final String JAAS_LOGINCONTEXTENTRY_REF = "deserializeLoginContextRef";
    static final long serialVersionUID = 6977919340227302550L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Activate
    protected void activate(ComponentContext cc) {
        this.configAdminRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.unauthenticatedSubjectServiceRef.activate(cc);
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.configAdminRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.unauthenticatedSubjectServiceRef.deactivate(cc);
    }

    @Reference(service=ConfigurationAdmin.class, name="configurationAdmin", policy=ReferencePolicy.DYNAMIC)
    protected void setConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.setReference(ref);
    }

    protected void unsetConfigurationAdmin(ServiceReference<ConfigurationAdmin> ref) {
        this.configAdminRef.unsetReference(ref);
    }

    @Reference(service=SecurityService.class, name="securityService")
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
    }

    @Reference(service=UnauthenticatedSubjectService.class, name="unauthenticatedSubjectService")
    protected void setUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.setReference(ref);
    }

    protected void unsetUnauthenticatedSubjectService(ServiceReference<UnauthenticatedSubjectService> ref) {
        this.unauthenticatedSubjectServiceRef.unsetReference(ref);
    }

    public ThreadContext captureThreadContext(Map<String, String> execProps, Map<String, ?> threadContextConfig) {
        String jaasLoginContextEntry = this.getConfigNameForRef((String)threadContextConfig.get(JAAS_LOGINCONTEXTENTRY_REF));
        return new SecurityContextImpl(true, jaasLoginContextEntry);
    }

    public ThreadContext createDefaultThreadContext(Map<String, String> execProps) {
        return new SecurityContextImpl(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadContext deserializeThreadContext(ThreadContextDeserializationInfo info, @Sensitive byte[] bytes) throws ClassNotFoundException, IOException {
        SecurityContextImpl context = null;
        try (ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));){
            context = (SecurityContextImpl)in.readObject();
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            final SecurityContextImpl finalContext = context;
            AccessController.doPrivileged(new PrivilegedAction(){
                static final long serialVersionUID = -7229017552124952283L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() {
                    finalContext.recreateFullSubjects((SecurityService)SecurityContextProviderImpl.this.securityServiceRef.getService(), (AtomicServiceReference<UnauthenticatedSubjectService>)SecurityContextProviderImpl.this.unauthenticatedSubjectServiceRef);
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.internal.SecurityContextProviderImpl$1", 1.class, (String)"security", (String)"com.ibm.ws.security.context.internal.resources.SecurityContextMessages");
                }
            });
        } else {
            context.recreateFullSubjects((SecurityService)this.securityServiceRef.getService(), this.unauthenticatedSubjectServiceRef);
        }
        return context;
    }

    @Trivial
    public List<ThreadContextProvider> getPrerequisites() {
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private String getConfigNameForRef(final String ref) {
        String name = null;
        if (ref != null) {
            Configuration config;
            final ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminRef.getService();
            try {
                config = AccessController.doPrivileged(new PrivilegedExceptionAction<Configuration>(){
                    static final long serialVersionUID = -4909395897174528774L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Configuration run() throws IOException {
                        return configAdmin.getConfiguration(ref, SecurityContextProviderImpl.this.configAdminRef.getReference().getBundle().getLocation());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.internal.SecurityContextProviderImpl$2", 2.class, (String)"security", (String)"com.ibm.ws.security.context.internal.resources.SecurityContextMessages");
                    }
                });
            }
            catch (PrivilegedActionException paex) {
                return null;
            }
            Dictionary props = config.getProperties();
            name = (String)props.get(KEY_NAME);
        }
        return name;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.context.internal.SecurityContextProviderImpl", SecurityContextProviderImpl.class, (String)"security", (String)"com.ibm.ws.security.context.internal.resources.SecurityContextMessages");
    }
}

