/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl;

import com.ibm.jbatch.container.RASConstants;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.xml.bind.ValidationEvent;
import jakarta.xml.bind.ValidationEventHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class JSLValidationEventHandler
implements ValidationEventHandler,
RASConstants {
    private static final String CLASSNAME = JSLValidationEventHandler.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME, "com.ibm.jbatch.container.internal.resources.JBatchMessages");
    private boolean eventOccurred;
    static final long serialVersionUID = -4391735966254579989L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JSLValidationEventHandler() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "<init>", new Object[0]);
        }
        this.eventOccurred = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean handleEvent(ValidationEvent event) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "handleEvent", new Object[]{event});
        }
        StringBuilder buf = new StringBuilder(250);
        buf.append("\nMESSAGE: " + event.getMessage());
        buf.append("\nSEVERITY: " + event.getSeverity());
        buf.append("\nLINKED EXC: " + event.getLinkedException());
        buf.append("\nLOCATOR INFO:\n------------");
        buf.append("\n  COLUMN NUMBER:  " + event.getLocator().getColumnNumber());
        buf.append("\n  LINE NUMBER:  " + event.getLocator().getLineNumber());
        buf.append("\n  OFFSET:  " + event.getLocator().getOffset());
        buf.append("\n  CLASS:  " + event.getLocator().getClass());
        buf.append("\n  NODE:  " + event.getLocator().getNode());
        buf.append("\n  OBJECT:  " + event.getLocator().getObject());
        buf.append("\n  URL:  " + event.getLocator().getURL());
        logger.log(Level.SEVERE, "jsl.schema.invalid", new Object[]{event.getLocator().getURL(), buf});
        this.eventOccurred = true;
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "handleEvent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean eventOccurred() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "eventOccurred", new Object[0]);
        }
        boolean bl = this.eventOccurred;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.jsl.JSLValidationEventHandler", "eventOccurred", bl);
        }
        return bl;
    }
}

