/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeSplitFlowExecution;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.impl.ParallelStepBuilder;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.status.SplitExecutionStatus;
import com.ibm.jbatch.container.util.BatchSplitFlowWorkUnit;
import com.ibm.jbatch.container.util.SplitFlowConfig;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.BatchStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeWorkUnitExecution runtimeWorkUnitExecution;
    private volatile List<BatchSplitFlowWorkUnit> splitFlowWorkUnits;
    private final BlockingQueue<BatchSplitFlowWorkUnit> completedWorkQueue;
    final List<JSLJob> subJobs;
    protected Split split;
    private ExtendedBatchStatus aggregateStatus;
    static final long serialVersionUID = 2037624343464474656L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SplitControllerImpl(RuntimeWorkUnitExecution jobExecution, Split split, long rootJobExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "<init>", new Object[]{jobExecution, split, rootJobExecutionId});
        }
        this.completedWorkQueue = new LinkedBlockingQueue<BatchSplitFlowWorkUnit>();
        this.subJobs = new ArrayList<JSLJob>();
        this.aggregateStatus = null;
        this.runtimeWorkUnitExecution = jobExecution;
        this.split = split;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IBatchKernelService getBatchKernelService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getBatchKernelService", new Object[0]);
        }
        IBatchKernelService iBatchKernelService = ServicesManagerStaticAnchor.getServicesManager().getBatchKernelService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iBatchKernelService = iBatchKernelService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getBatchKernelService", iBatchKernelService);
        }
        return iBatchKernelService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ZosJBatchSMFLogging getJBatchSMFLoggingService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getJBatchSMFLoggingService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = ServicesManagerStaticAnchor.getServicesManager().getJBatchSMFService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getJBatchSMFLoggingService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobExecutionNotRunningException.class})
    public void stop() {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "stop", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            if (this.splitFlowWorkUnits != null) {
                for (BatchSplitFlowWorkUnit splitFlow : this.splitFlowWorkUnits) {
                    long workUnitExecutionId = -1L;
                    try {
                        this.getBatchKernelService().stopWorkUnit(splitFlow);
                    }
                    catch (JobExecutionNotRunningException e) {
                        logger.fine("Caught exception trying to stop work unit: " + workUnitExecutionId + ", which was not running.");
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.jbatch.container.controller.impl.SplitControllerImpl", (String)"114", (Object)this, (Object[])new Object[0]);
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "stop");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isJobStopping() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "isJobStopping", new Object[0]);
        }
        boolean bl = this.runtimeWorkUnitExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "isJobStopping", bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SplitExecutionStatus execute() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        RuntimeWorkUnitExecution.StopLock stopLock;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "execute", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock2 = stopLock = this.getStopLock();
        synchronized (stopLock2) {
            if (this.isJobStopping()) {
                SplitExecutionStatus retVal = new SplitExecutionStatus();
                retVal.setExtendedBatchStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
                SplitExecutionStatus splitExecutionStatus = retVal;
                // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    splitExecutionStatus = splitExecutionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "execute", splitExecutionStatus);
                }
                return splitExecutionStatus;
            }
            this.buildSubJobBatchWorkUnits();
            this.executeWorkUnits();
        }
        SplitExecutionStatus splitExecutionStatus = this.waitForCompletionAndAggregateStatus();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            splitExecutionStatus = splitExecutionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "execute", splitExecutionStatus);
        }
        return splitExecutionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void buildSubJobBatchWorkUnits() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "buildSubJobBatchWorkUnits", new Object[0]);
        }
        List<? extends Flow> flows = this.split.getFlows();
        this.splitFlowWorkUnits = new ArrayList<BatchSplitFlowWorkUnit>();
        for (Flow flow : flows) {
            JSLJob splitFlowJSLJob = ParallelStepBuilder.buildFlowInSplitSubJob(this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getWorkUnitJobContext(), this.split, flow);
            this.subJobs.add(splitFlowJSLJob);
            SplitFlowConfig splitFlowConfig = new SplitFlowConfig(this.runtimeWorkUnitExecution.getTopLevelNameInstanceExecutionInfo(), this.split.getId(), flow.getId(), this.runtimeWorkUnitExecution.getCorrelationId());
            BatchSplitFlowWorkUnit workUnit = this.getBatchKernelService().createSplitFlowWorkUnit(splitFlowConfig, splitFlowJSLJob, this.completedWorkQueue);
            this.splitFlowWorkUnits.add(workUnit);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "buildSubJobBatchWorkUnits");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void executeWorkUnits() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "executeWorkUnits", new Object[0]);
        }
        for (BatchSplitFlowWorkUnit work : this.splitFlowWorkUnits) {
            this.getBatchKernelService().runSplitFlow(work);
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "flow.started", new Object[]{work.getRuntimeWorkUnitExecution().getFlowName(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()}, logger);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "executeWorkUnits");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private SplitExecutionStatus waitForCompletionAndAggregateStatus() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "waitForCompletionAndAggregateStatus", new Object[0]);
        }
        SplitExecutionStatus splitStatus = new SplitExecutionStatus();
        for (int i = 0; i < this.subJobs.size(); ++i) {
            BatchSplitFlowWorkUnit batchWork;
            try {
                batchWork = this.completedWorkQueue.take();
            }
            catch (InterruptedException interruptedException) {
                void e;
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.jbatch.container.controller.impl.SplitControllerImpl", (String)"211", (Object)this, (Object[])new Object[0]);
                throw new BatchContainerRuntimeException((Throwable)e);
            }
            RuntimeSplitFlowExecution flowExecution = batchWork.getRuntimeWorkUnitExecution();
            ExecutionStatus flowStatus = flowExecution.getFlowStatus();
            if (flowStatus.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.NORMAL_COMPLETION)) {
                ZosJBatchSMFLogging smflogger = this.getJBatchSMFLoggingService();
                logger.fine("cutting an smf flow end record");
                if (smflogger != null) {
                    JobExecutionEntity jobExecution = this.getPersistenceManagerService().getJobExecution(flowExecution.getTopLevelExecutionId());
                    int rc = smflogger.buildAndWriteFlowEndRecord(flowExecution, jobExecution, this.getPersistenceManagerService().getPersistenceType(), this.getPersistenceManagerService().getDisplayId());
                    logger.fine("back from calling native smf, rc = " + rc);
                }
            }
            this.aggregateTerminatingStatusFromSingleFlow(flowStatus, splitStatus);
            if (flowStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                JoblogUtil.logToJobLogAndTraceOnly(Level.WARNING, "flow.failed", new Object[]{batchWork.getRuntimeWorkUnitExecution().getFlowName(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()}, logger);
            }
            JoblogUtil.logToJobLogAndTraceOnly(Level.FINE, "flow.ended", new Object[]{batchWork.getRuntimeWorkUnitExecution().getFlowName(), this.runtimeWorkUnitExecution.getTopLevelInstanceId(), this.runtimeWorkUnitExecution.getTopLevelExecutionId()}, logger);
        }
        if (this.aggregateStatus == null) {
            logger.fine("Setting normal split status as no contained flows ended the job.");
            this.aggregateStatus = ExtendedBatchStatus.NORMAL_COMPLETION;
        }
        splitStatus.setExtendedBatchStatus(this.aggregateStatus);
        logger.fine("Returning from waitForCompletionAndAggregateStatus with return value: " + splitStatus);
        SplitExecutionStatus splitExecutionStatus = splitStatus;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            splitExecutionStatus = splitExecutionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "waitForCompletionAndAggregateStatus", splitExecutionStatus);
        }
        return splitExecutionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void aggregateTerminatingStatusFromSingleFlow(ExecutionStatus flowStatus, SplitExecutionStatus splitStatus) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "aggregateTerminatingStatusFromSingleFlow", new Object[]{flowStatus, splitStatus});
        }
        String exitStatus = flowStatus.getExitStatus();
        String restartOn = flowStatus.getRestartOn();
        ExtendedBatchStatus flowBatchStatus = flowStatus.getExtendedBatchStatus();
        logger.fine("Aggregating possible terminating status for flow ending with status: " + flowStatus + ", restartOn = " + restartOn);
        if (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_STOP) || flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
            if (this.aggregateStatus == null) {
                logger.fine("A flow detected as ended because of a terminating condition: " + flowBatchStatus.name() + ". First flow detected in terminating state.  Setting exitStatus if non-null.");
                this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                this.aggregateStatus = flowBatchStatus;
            } else {
                splitStatus.setCouldMoreThanOneFlowHaveTerminatedJob(true);
                if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                    logger.fine("Current flow's batch and exit status will take precedence over and override earlier one from <end> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                    this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                    this.aggregateStatus = flowBatchStatus;
                } else if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_STOP)) {
                    if (!flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_END)) {
                        logger.fine("Current flow's batch and exit status will take precedence over and override earlier one from <stop> transition element. Overriding, setting exit status if non-null and preparing to end job.");
                        this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                        this.aggregateStatus = flowBatchStatus;
                    } else {
                        logger.fine("End does not override stop.  The flow with <end> will effectively be ignored with respect to terminating the job.");
                    }
                } else if (this.aggregateStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || this.aggregateStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                    if (flowBatchStatus.equals((Object)ExtendedBatchStatus.JSL_FAIL) || flowBatchStatus.equals((Object)ExtendedBatchStatus.EXCEPTION_THROWN)) {
                        logger.fine("Current flow's batch and exit status will take precedence over and override earlier one from <fail> transition element or exception thrown. Overriding, setting exit status if non-null and preparing to end job.");
                        this.setInJobContext(flowBatchStatus, exitStatus, restartOn);
                        this.aggregateStatus = flowBatchStatus;
                    } else {
                        logger.fine("End and stop do not override exception thrown or <fail>.   The flow with <end> or <stop> will effectively be ignored with respect to terminating the job.");
                    }
                }
            }
        } else {
            logger.fine("Flow completing normally without any terminating transition or exception thrown.");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "aggregateTerminatingStatusFromSingleFlow");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void setInJobContext(ExtendedBatchStatus flowBatchStatus, String exitStatus, String restartOn) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "setInJobContext", new Object[]{flowBatchStatus, exitStatus, restartOn});
        }
        if (exitStatus != null) {
            this.runtimeWorkUnitExecution.setExitStatus(exitStatus);
        }
        if (ExtendedBatchStatus.JSL_STOP.equals((Object)flowBatchStatus) && restartOn != null) {
            this.runtimeWorkUnitExecution.setRestartOnForNextExecution(restartOn);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "setInJobContext");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<BatchSplitFlowWorkUnit> getParallelJobExecs() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getParallelJobExecs", new Object[0]);
        }
        List<BatchSplitFlowWorkUnit> list = this.splitFlowWorkUnits;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getParallelJobExecs", list);
        }
        return list;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getLastRunStepExecutions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getLastRunStepExecutions", new Object[0]);
        }
        ArrayList<Long> stepExecIdList = new ArrayList<Long>();
        for (BatchSplitFlowWorkUnit workUnit : this.splitFlowWorkUnits) {
            List<Long> stepExecIds = workUnit.getController().getLastRunStepExecutions();
            if (stepExecIds == null) continue;
            stepExecIdList.addAll(stepExecIds);
        }
        ArrayList<Long> arrayList = stepExecIdList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getLastRunStepExecutions", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected RuntimeWorkUnitExecution.StopLock getStopLock() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getStopLock", new Object[0]);
        }
        RuntimeWorkUnitExecution.StopLock stopLock = this.runtimeWorkUnitExecution.getStopLock();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            stopLock = stopLock;
            logger.exiting("com.ibm.jbatch.container.controller.impl.SplitControllerImpl", "getStopLock", stopLock);
        }
        return stopLock;
    }
}

