/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.controller.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.controller.impl.ExecutionElementControllerFactory;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.navigator.IllegalTransitionException;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import com.ibm.jbatch.jsl.model.helper.ExecutionElement;
import com.ibm.jbatch.jsl.model.helper.Transition;
import com.ibm.jbatch.jsl.model.helper.TransitionElement;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.BatchStatus;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ExecutionTransitioner {
    private static final String CLASSNAME = ExecutionTransitioner.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private RuntimeWorkUnitExecution runtimeExecution;
    private long rootJobExecutionId;
    private ModelNavigator<?> modelNavigator;
    private volatile IExecutionElementController currentStoppableElementController;
    private IExecutionElementController previousElementController;
    private ExecutionElement currentExecutionElement;
    private ExecutionElement previousExecutionElement;
    private PartitionReplyQueue partitionReplyQueue;
    private List<Long> stepExecIds;
    static final long serialVersionUID = -8829602088494465630L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionTransitioner(RuntimeWorkUnitExecution jobExecution, ModelNavigator<?> modelNavigator) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "<init>", new Object[]{jobExecution, modelNavigator});
        }
        this.currentExecutionElement = null;
        this.previousExecutionElement = null;
        this.partitionReplyQueue = null;
        this.runtimeExecution = jobExecution;
        this.modelNavigator = modelNavigator;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionTransitioner(RuntimeWorkUnitExecution jobExecution, ModelNavigator<JSLJob> jobNavigator, PartitionReplyQueue partitionReplyQueue) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "<init>", new Object[]{jobExecution, jobNavigator, partitionReplyQueue});
        }
        this.currentExecutionElement = null;
        this.previousExecutionElement = null;
        this.partitionReplyQueue = null;
        this.runtimeExecution = jobExecution;
        this.modelNavigator = jobNavigator;
        this.partitionReplyQueue = partitionReplyQueue;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "<init>", this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus doExecutionLoop() {
        Transition nextTransition;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", new Object[0]);
        }
        String methodName = "doExecutionLoop";
        if (this.runtimeExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            logger.fine("doExecutionLoop Exiting execution loop as job is now in stopping state.");
            ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                executionStatus = executionStatus;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
            }
            return executionStatus;
        }
        try {
            this.currentExecutionElement = this.modelNavigator.getFirstExecutionElement(this.runtimeExecution.getRestartOnForThisExecution());
        }
        catch (IllegalTransitionException illegalTransitionException) {
            void e;
            FFDCFilter.processException((Throwable)illegalTransitionException, (String)"com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", (String)"93", (Object)this, (Object[])new Object[0]);
            String errorMsg = "Could not transition to first execution element within job.";
            throw new IllegalArgumentException(errorMsg, (Throwable)e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + this.currentExecutionElement.getId());
        }
        while (true) {
            IExecutionElementController currentElementController;
            this.currentStoppableElementController = currentElementController = this.getNextElementController();
            if (this.runtimeExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting execution loop as job is now in stopping state.");
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
                }
                return executionStatus;
            }
            ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService().updateJobInstanceNullOutRestartOn(this.runtimeExecution.getTopLevelInstanceId());
            ExecutionStatus status = currentElementController.execute();
            if ((this.currentExecutionElement instanceof Split || this.currentExecutionElement instanceof Flow) && !status.getExtendedBatchStatus().equals((Object)ExtendedBatchStatus.NORMAL_COMPLETION)) {
                logger.fine("Breaking out of loop with return status = " + status.getExtendedBatchStatus().name());
                ExecutionStatus executionStatus = status;
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
                }
                return executionStatus;
            }
            if (this.runtimeExecution.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
                String errorMsg = "Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.";
                throw new BatchContainerRuntimeException(errorMsg);
            }
            this.currentStoppableElementController = null;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + this.currentExecutionElement.getId() + ", exitStatus=" + status.getExitStatus());
            }
            if (this.runtimeExecution.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting as job has been stopped");
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.JOB_OPERATOR_STOPPING);
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
                }
                return executionStatus;
            }
            nextTransition = null;
            try {
                nextTransition = this.modelNavigator.getNextTransition(this.currentExecutionElement, status);
            }
            catch (IllegalTransitionException illegalTransitionException) {
                void e;
                FFDCFilter.processException((Throwable)illegalTransitionException, (String)"com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", (String)"151", (Object)this, (Object[])new Object[0]);
                String errorMsg = "Problem transitioning to next execution element.";
                throw new BatchContainerRuntimeException(errorMsg, (Throwable)e);
            }
            if (nextTransition.isFinishedTransitioning()) {
                logger.fine("doExecutionLoop , No next execution element, and no transition element found either.  Looks like we're done and ready for COMPLETED state.");
                this.stepExecIds = currentElementController.getLastRunStepExecutions();
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, status.getExitStatus());
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
                }
                return executionStatus;
            }
            if (nextTransition.noTransitionElementMatchedAfterException()) {
                ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, status.getExitStatus());
                if (logger != null && logger.isLoggable(Level.FINER)) {
                    executionStatus = executionStatus;
                    logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
                }
                return executionStatus;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            this.previousExecutionElement = this.currentExecutionElement;
            this.previousElementController = currentElementController;
            this.currentExecutionElement = nextTransition.getNextExecutionElement();
        }
        if (nextTransition.getTransitionElement() != null) {
            ExecutionStatus terminatingStatus = this.handleTerminatingTransitionElement(nextTransition.getTransitionElement());
            logger.finer("doExecutionLoop , Breaking out of execution loop after processing terminating transition element.");
            ExecutionStatus executionStatus = terminatingStatus;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                executionStatus = executionStatus;
                logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "doExecutionLoop", executionStatus);
            }
            return executionStatus;
        }
        throw new IllegalStateException("Not sure how we'd end up in this state...aborting rather than looping.");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private IExecutionElementController getNextElementController() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getNextElementController", new Object[0]);
        }
        IExecutionElementController elementController = null;
        if (this.currentExecutionElement instanceof Decision) {
            Decision decision = (Decision)this.currentExecutionElement;
            DecisionControllerImpl decisionController = elementController = ExecutionElementControllerFactory.getDecisionController(this.runtimeExecution, decision);
            decisionController.setPreviousStepExecutions(this.previousExecutionElement, this.previousElementController);
        } else if (this.currentExecutionElement instanceof Flow) {
            Flow flow = (Flow)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getFlowController(this.runtimeExecution, flow, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Split) {
            Split split = (Split)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getSplitController(this.runtimeExecution, split, this.rootJobExecutionId);
        } else if (this.currentExecutionElement instanceof Step) {
            Step step = (Step)this.currentExecutionElement;
            elementController = ExecutionElementControllerFactory.getStepController(this.runtimeExecution, step, this.rootJobExecutionId, this.partitionReplyQueue);
        }
        logger.fine("Next execution element controller = " + elementController);
        IExecutionElementController iExecutionElementController = elementController;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iExecutionElementController = iExecutionElementController;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getNextElementController", iExecutionElementController);
        }
        return iExecutionElementController;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ExecutionStatus handleTerminatingTransitionElement(TransitionElement transitionElement) {
        ExecutionStatus retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "handleTerminatingTransitionElement", new Object[]{transitionElement});
        }
        logger.fine("Found terminating transition element (stop, end, or fail).");
        if (transitionElement instanceof Stop) {
            Stop stopElement = (Stop)transitionElement;
            String restartOn = stopElement.getRestart();
            String exitStatusFromJSL = stopElement.getExitStatus();
            logger.fine("Next transition element is a <stop> : " + transitionElement + " with restartOn=" + restartOn + " , and JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_STOP);
            if (exitStatusFromJSL != null) {
                this.runtimeExecution.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
            if (restartOn != null) {
                this.runtimeExecution.setRestartOnForNextExecution(restartOn);
                retVal.setRestartOn(restartOn);
            }
        } else if (transitionElement instanceof End) {
            End endElement = (End)transitionElement;
            String exitStatusFromJSL = endElement.getExitStatus();
            logger.fine("Next transition element is an <end> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_END);
            if (exitStatusFromJSL != null) {
                this.runtimeExecution.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else if (transitionElement instanceof Fail) {
            Fail failElement = (Fail)transitionElement;
            String exitStatusFromJSL = failElement.getExitStatus();
            logger.fine("Next transition element is a <fail> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            retVal = new ExecutionStatus(ExtendedBatchStatus.JSL_FAIL);
            if (exitStatusFromJSL != null) {
                this.runtimeExecution.setExitStatus(exitStatusFromJSL);
                retVal.setExitStatus(exitStatusFromJSL);
            }
        } else {
            throw new IllegalStateException("Not sure how we'd get here...aborting.");
        }
        ExecutionStatus executionStatus = retVal;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "handleTerminatingTransitionElement", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IController getCurrentStoppableElementController() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getCurrentStoppableElementController", new Object[0]);
        }
        IExecutionElementController iExecutionElementController = this.currentStoppableElementController;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iExecutionElementController = iExecutionElementController;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getCurrentStoppableElementController", iExecutionElementController);
        }
        return iExecutionElementController;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getStepExecIds() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getStepExecIds", new Object[0]);
        }
        List<Long> list = this.stepExecIds;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.controller.impl.ExecutionTransitioner", "getStepExecIds", list);
        }
        return list;
    }
}

