/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.controller.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.DeciderProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.execution.impl.RuntimeWorkUnitExecution;
import com.ibm.jbatch.container.persistence.jpa.JobExecutionEntity;
import com.ibm.jbatch.container.persistence.jpa.TopLevelStepExecutionEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.container.ws.smf.ZosJBatchSMFLogging;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.helper.ExecutionElement;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.batch.runtime.StepExecution;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class DecisionControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = DecisionControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeWorkUnitExecution jobExecution;
    private final Decision decision;
    private StepExecution[] previousStepExecutions;
    static final long serialVersionUID = -2004226759762654174L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DecisionControllerImpl(RuntimeWorkUnitExecution jobExecution, Decision decision) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "<init>", new Object[]{jobExecution, decision});
        }
        this.previousStepExecutions = null;
        this.jobExecution = jobExecution;
        this.decision = decision;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public IPersistenceManagerService getPersistenceManagerService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getPersistenceManagerService", new Object[0]);
        }
        IPersistenceManagerService iPersistenceManagerService = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            iPersistenceManagerService = iPersistenceManagerService;
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getPersistenceManagerService", iPersistenceManagerService);
        }
        return iPersistenceManagerService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ZosJBatchSMFLogging getJBatchSMFLoggingService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getJBatchSMFLoggingService", new Object[0]);
        }
        ZosJBatchSMFLogging zosJBatchSMFLogging = ServicesManagerStaticAnchor.getServicesManager().getJBatchSMFService();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            zosJBatchSMFLogging = zosJBatchSMFLogging;
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getJBatchSMFLoggingService", zosJBatchSMFLogging);
        }
        return zosJBatchSMFLogging;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutionStatus execute() {
        DeciderProxy deciderProxy;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "execute", new Object[0]);
        }
        String deciderId = this.decision.getRef();
        List<Property> propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecution.getWorkUnitJobContext(), null, propList);
        try {
            deciderProxy = ProxyFactory.createDeciderProxy(deciderId, injectionRef);
        }
        catch (ArtifactValidationException artifactValidationException) {
            void e;
            FFDCFilter.processException((Throwable)artifactValidationException, (String)"com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", (String)"91", (Object)this, (Object[])new Object[0]);
            throw new BatchContainerServiceException("Cannot create the decider [" + deciderId + "]", (Throwable)e);
        }
        byte[] timeUsedBefore = null;
        ZosJBatchSMFLogging smflogger = this.getJBatchSMFLoggingService();
        if (smflogger != null) {
            timeUsedBefore = smflogger.getTimeUsedData();
        }
        Date startTime = new Date();
        String exitStatus = deciderProxy.decide(this.previousStepExecutions);
        Date endTime = new Date();
        byte[] timeUsedAfter = null;
        if (smflogger != null) {
            timeUsedAfter = smflogger.getTimeUsedData();
        }
        logger.fine("Decider exiting and setting job-level exit status to " + exitStatus);
        this.jobExecution.getWorkUnitJobContext().setExitStatus(exitStatus);
        if (smflogger != null) {
            JobExecutionEntity execution = this.getPersistenceManagerService().getJobExecution(this.jobExecution.getTopLevelExecutionId());
            this.getJBatchSMFLoggingService().buildAndWriteDeciderEndRecord(exitStatus, this.jobExecution, execution, this.decision.getRef(), this.getPersistenceManagerService().getPersistenceType(), this.getPersistenceManagerService().getDisplayId(), startTime, endTime, timeUsedBefore, timeUsedAfter);
        }
        ExecutionStatus executionStatus = new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, exitStatus);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executionStatus = executionStatus;
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "execute", executionStatus);
        }
        return executionStatus;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void setPreviousStepExecutions(ExecutionElement previousExecutionElement, IExecutionElementController previousElementController) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "setPreviousStepExecutions", new Object[]{previousExecutionElement, previousElementController});
        }
        if (previousExecutionElement != null && previousExecutionElement instanceof Decision) {
            throw new BatchContainerRuntimeException("A decision cannot precede another decision.");
        }
        List<Long> previousStepExecsIds = previousElementController.getLastRunStepExecutions();
        StepExecution[] stepExecArray = new StepExecution[previousStepExecsIds.size()];
        for (int i = 0; i < stepExecArray.length; ++i) {
            TopLevelStepExecutionEntity stepExec = this.getPersistenceManagerService().getStepExecutionTopLevel(previousStepExecsIds.get(i));
            stepExecArray[i] = stepExec;
        }
        this.previousStepExecutions = stepExecArray;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "setPreviousStepExecutions");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void stop() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "stop", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "stop");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public List<Long> getLastRunStepExecutions() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getLastRunStepExecutions", new Object[0]);
        }
        List<Long> list = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            list = list;
            logger.exiting("com.ibm.jbatch.container.controller.impl.DecisionControllerImpl", "getLastRunStepExecutions", list);
        }
        return list;
    }
}

